/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.Optional;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.data.provider.AbstractDataProvider;
import org.spongepowered.common.data.provider.ImmutableDataProvider;
import org.spongepowered.common.util.TypeTokenUtil;

public abstract class GenericImmutableDataProviderBase<H, V extends Value<E>, E>
extends ImmutableDataProvider<V, E>
implements AbstractDataProvider.KnownHolderType {
    private final Class<H> holderType;

    GenericImmutableDataProviderBase(Key<V> key, Class<H> holderType) {
        super(key);
        this.holderType = holderType;
    }

    GenericImmutableDataProviderBase(Key<V> key) {
        super(key);
        this.holderType = GenericTypeReflector.erase((Type)TypeTokenUtil.typeArgumentFromSupertype(this.getClass(), GenericImmutableDataProviderBase.class, 0));
    }

    private boolean isTypeAllowed(DataHolder dataHolder) {
        return this.holderType.isInstance(dataHolder);
    }

    public Class<H> getHolderType() {
        return this.holderType;
    }

    protected boolean supports(H dataHolder) {
        return true;
    }

    protected abstract Optional<E> getFrom(H var1);

    protected abstract Optional<H> set(H var1, E var2);

    protected V constructValue(H dataHolder, E element) {
        return (V)Value.genericImmutableOf(this.key(), element);
    }

    protected Optional<H> removeFrom(H dataHolder) {
        return Optional.empty();
    }

    public final Optional<E> get(DataHolder dataHolder) {
        if (!this.isSupported(dataHolder)) {
            return Optional.empty();
        }
        return this.getFrom(dataHolder);
    }

    public Optional<V> value(DataHolder dataHolder) {
        return this.get(dataHolder).map(e -> this.constructValue(dataHolder, e));
    }

    public boolean isSupported(DataHolder dataHolder) {
        return this.isTypeAllowed(dataHolder) && this.supports(dataHolder);
    }

    public boolean isSupported(Type dataHolder) {
        return this.holderType.isAssignableFrom(GenericTypeReflector.erase((Type)dataHolder));
    }

    public <I extends DataHolder.Immutable<I>> Optional<I> with(I immutable, E value) {
        if (!this.isSupported((DataHolder)immutable)) {
            return Optional.empty();
        }
        return this.set(immutable, value);
    }

    public <I extends DataHolder.Immutable<I>> Optional<I> without(I immutable) {
        if (!this.isSupported((DataHolder)immutable)) {
            return Optional.empty();
        }
        return this.removeFrom(immutable);
    }
}

