/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.world.biome;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.EntityCategory;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.world.biome.ambient.ParticleConfig;
import org.spongepowered.api.world.biome.ambient.SoundConfig;
import org.spongepowered.api.world.biome.climate.Precipitation;
import org.spongepowered.api.world.biome.climate.TemperatureModifier;
import org.spongepowered.api.world.biome.spawner.NaturalSpawnCost;
import org.spongepowered.api.world.biome.spawner.NaturalSpawner;
import org.spongepowered.api.world.generation.carver.Carver;
import org.spongepowered.api.world.generation.feature.DecorationStep;
import org.spongepowered.api.world.generation.feature.PlacedFeature;
import org.spongepowered.common.accessor.world.level.biome.BiomeAccessor;
import org.spongepowered.common.accessor.world.level.biome.Biome_ClimateSettingsAccessor;
import org.spongepowered.common.accessor.world.level.biome.MobSpawnSettingsAccessor;
import org.spongepowered.common.data.provider.DataProviderRegistrator;

public final class BiomeData {
    private BiomeData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)((DataProviderRegistrator.ImmutableRegistration)registrator.asImmutable(class_1959.class).create(Keys.BIOME_TEMPERATURE).get(h -> h.method_8712())).create(Keys.PRECIPITATION).get(h -> (Precipitation)(h.method_48163() ? (h.method_8712() >= 0.15f ? class_1959.class_1963.field_9382 : class_1959.class_1963.field_9383) : class_1959.class_1963.field_9384))).create(Keys.HAS_PRECIPITATION).get(class_1959::method_48163)).create(Keys.CARVERS).get(BiomeData::carvers)).create(Keys.FEATURES).get(BiomeData::features)).create(Keys.SPAWN_CHANCE).get(h -> h.method_30966().method_31002())).create(Keys.NATURAL_SPAWNERS).get(BiomeData::naturalSpawners)).create(Keys.NATURAL_SPAWNER_COST).get(BiomeData::naturalSpawnerCost)).create(Keys.FOG_COLOR).get(h -> Color.ofRgb((int)h.method_24377().method_24387()))).create(Keys.WATER_COLOR).get(h -> Color.ofRgb((int)h.method_24377().method_24388()))).create(Keys.WATER_FOG_COLOR).get(h -> Color.ofRgb((int)h.method_24377().method_24389()))).create(Keys.SKY_COLOR).get(h -> Color.ofRgb((int)h.method_24377().method_30810()))).create(Keys.FOLIAGE_COLOR).get(h -> h.method_24377().method_30811().map(Color::ofRgb).orElse(null))).create(Keys.GRASS_COLOR).get(h -> h.method_24377().method_30812().map(Color::ofRgb).orElse(null))).create(Keys.BACKGROUND_MUSIC).get(h -> h.method_24377().method_27345().map(SoundConfig.BackgroundMusic.class::cast).orElse(null))).create(Keys.AMBIENT_ADDITIONAL_SOUND).get(h -> h.method_24377().method_24941().map(SoundConfig.Additional.class::cast).orElse(null))).create(Keys.AMBIENT_MOOD).get(h -> h.method_24377().method_24940().map(SoundConfig.Mood.class::cast).orElse(null))).create(Keys.AMBIENT_PARTICLE).get(h -> h.method_24377().method_24390().map(ParticleConfig.class::cast).orElse(null))).asImmutable(BiomeAccessor.class).create(Keys.HUMIDITY).get(h -> h.accessor$climateSettings().comp_846())).create(Keys.TEMPERATURE_MODIFIER).get(h -> (TemperatureModifier)((Biome_ClimateSettingsAccessor)h.accessor$climateSettings()).accessor$temperatureModifier());
    }

    public static List<Carver> carvers(class_1959 biome) {
        class_5485 settings = biome.method_30970();
        Iterable carvers = settings.method_30976();
        return StreamSupport.stream(carvers.spliterator(), false).map(carver -> (Carver)carver.comp_349()).collect(Collectors.toList());
    }

    private static Map<DecorationStep, List<PlacedFeature>> features(class_1959 biome) {
        class_5485 settings = biome.method_30970();
        return Arrays.stream(class_2893.class_2895.values()).collect(Collectors.toMap(step -> (DecorationStep)step, step -> BiomeData.featureList(settings, step)));
    }

    private static List<PlacedFeature> featureList(class_5485 settings, class_2893.class_2895 step) {
        List features = settings.method_30983();
        if (step.ordinal() >= features.size()) {
            return List.of();
        }
        class_6885 holders = (class_6885)features.get(step.ordinal());
        return holders.method_40239().map(class_6880::comp_349).map(f -> (PlacedFeature)f).toList();
    }

    private static Map<EntityCategory, List<NaturalSpawner>> naturalSpawners(class_1959 biome) {
        HashMap<EntityCategory, List<NaturalSpawner>> map = new HashMap<EntityCategory, List<NaturalSpawner>>();
        for (class_1311 cat : class_1311.values()) {
            BiomeData.naturalSpawner(biome, cat).ifPresent(v -> map.put((EntityCategory)cat, (List<NaturalSpawner>)v));
        }
        return map;
    }

    private static Optional<List<NaturalSpawner>> naturalSpawner(class_1959 biome, class_1311 cat) {
        List unwrap = biome.method_30966().method_31004(cat).method_34994();
        if (unwrap.isEmpty()) {
            return Optional.empty();
        }
        ArrayList result = new ArrayList();
        unwrap.forEach(data -> result.add((NaturalSpawner)data));
        return Optional.of(result);
    }

    private static Map<EntityType<?>, NaturalSpawnCost> naturalSpawnerCost(class_1959 biome) {
        Map<class_1299<?>, class_5483.class_5265> costs = ((MobSpawnSettingsAccessor)biome.method_30966()).accessor$mobSpawnCosts();
        return costs.entrySet().stream().collect(Collectors.toMap(e -> (EntityType)e.getKey(), e -> (NaturalSpawnCost)e.getValue()));
    }
}

