/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.type;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1535;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.data.type.ArtType;
import org.spongepowered.api.data.type.ArtTypeTemplate;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;
import org.spongepowered.common.util.Preconditions;

public final class SpongeArtTypeTemplate
extends Record
implements ArtTypeTemplate {
    private final ResourceKey key;
    private final class_1535 representedType;
    private final DataPack<ArtTypeTemplate> pack;

    public SpongeArtTypeTemplate(ResourceKey key, class_1535 representedType, DataPack<ArtTypeTemplate> pack) {
        this.key = key;
        this.representedType = representedType;
        this.pack = pack;
    }

    public ArtType type() {
        return (ArtType)this.representedType;
    }

    public int contentVersion() {
        return 0;
    }

    public DataContainer toContainer() {
        JsonElement serialized = SpongeArtTypeTemplate.encode(this, (class_5455)SpongeCommon.server().method_30611());
        try {
            return ((StringDataFormat)DataFormats.JSON.get()).read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized DamageType:\n" + String.valueOf(serialized), e);
        }
    }

    public static JsonElement encode(ArtTypeTemplate template, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        return (JsonElement)class_1535.field_51596.encodeStart((DynamicOps)ops, (Object)((class_1535)template.type())).getOrThrow();
    }

    public static class_1535 decode(JsonElement json, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        return (class_1535)class_1535.field_51596.parse((DynamicOps)ops, (Object)json).getOrThrow();
    }

    public static SpongeArtTypeTemplate decode(DataPack<ArtTypeTemplate> pack, ResourceKey key, JsonElement packEntry, class_5455 registryAccess) {
        class_1535 parsed = SpongeArtTypeTemplate.decode(packEntry, registryAccess);
        return new SpongeArtTypeTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeArtTypeTemplate.class, "key;representedType;pack", "key", "representedType", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeArtTypeTemplate.class, "key;representedType;pack", "key", "representedType", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeArtTypeTemplate.class, "key;representedType;pack", "key", "representedType", "pack"}, this, o);
    }

    public ResourceKey key() {
        return this.key;
    }

    public class_1535 representedType() {
        return this.representedType;
    }

    public DataPack<ArtTypeTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<ArtType, ArtTypeTemplate, ArtTypeTemplate.Builder>
    implements ArtTypeTemplate.Builder {
        private int width;
        private int height;
        private class_2960 assetId;

        public ArtTypeTemplate.Builder dimensions(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public ArtTypeTemplate.Builder asset(ResourceKey assetId) {
            this.assetId = (class_2960)assetId;
            return this;
        }

        public ArtTypeTemplate.Builder fromValue(ArtType value) {
            ArtType artType = value;
            if (artType instanceof class_1535) {
                class_1535 variant = (class_1535)artType;
                this.width = variant.comp_2670();
                this.height = variant.comp_2671();
                this.assetId = variant.comp_2672();
            }
            return this;
        }

        public ArtTypeTemplate.Builder fromDataPack(DataView dataView) throws IOException {
            JsonElement json = JsonParser.parseString((String)((StringDataFormat)DataFormats.JSON.get()).write(dataView));
            class_1535 damageType = SpongeArtTypeTemplate.decode(json, (class_5455)SpongeCommon.server().method_30611());
            this.fromValue((ArtType)damageType);
            return this;
        }

        @Override
        public Function<ArtTypeTemplate, ArtType> valueExtractor() {
            return ArtTypeTemplate::type;
        }

        @Override
        protected ArtTypeTemplate build0() {
            Preconditions.checkArgument(this.width >= 0, "width must set");
            Preconditions.checkArgument(this.height >= 0, "height must set");
            Objects.requireNonNull(this.assetId, "assetId");
            return new SpongeArtTypeTemplate(this.key, new class_1535(this.width, this.height, this.assetId, Optional.empty(), Optional.empty()), (DataPack<ArtTypeTemplate>)this.pack);
        }
    }
}

