/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value;

import java.util.Objects;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.data.value.ValueConstructor;

final class CachedEnumValueConstructor<V extends Value<E>, E extends Enum<E>>
implements ValueConstructor<V, E> {
    private final ValueConstructor<V, E> original;
    private final V[] immutableValues;

    public CachedEnumValueConstructor(ValueConstructor<V, E> original, Class<E> enumType) {
        this.original = original;
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        this.immutableValues = new Value[constants.length];
        for (int i = 0; i < constants.length; ++i) {
            this.immutableValues[i] = this.original.getImmutable(constants[i]);
        }
    }

    @Override
    public V getMutable(E element) {
        return this.original.getMutable(element);
    }

    @Override
    public V getImmutable(E element) {
        Objects.requireNonNull(element, "element");
        return this.immutableValues[((Enum)element).ordinal()];
    }

    @Override
    public V getRawImmutable(E element) {
        return this.getImmutable(element);
    }
}

