/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.CollectionValue;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.common.data.key.SpongeKey;
import org.spongepowered.common.data.value.ImmutableSpongeCollectionValue;
import org.spongepowered.common.data.value.MutableSpongeListValue;

public class ImmutableSpongeListValue<E>
extends ImmutableSpongeCollectionValue<E, List<E>, ListValue.Immutable<E>, ListValue.Mutable<E>>
implements ListValue.Immutable<E> {
    public ImmutableSpongeListValue(Key<? extends CollectionValue<E, List<E>>> key, List<E> element) {
        super(key, element);
    }

    @Override
    public SpongeKey<? extends ListValue<E>, List<E>> key() {
        return super.key();
    }

    public E get(int index) {
        return ((List)this.element).get(index);
    }

    public int indexOf(E element) {
        return ((List)this.element).indexOf(element);
    }

    public ListValue.Immutable<E> with(int index, E value) {
        return this.modifyCollection((List<E> list) -> list.add(index, value));
    }

    public ListValue.Immutable<E> with(int index, Iterable<E> values) {
        return this.modifyCollection((List<E> list) -> {
            int offset = 0;
            for (Object value : values) {
                list.add(index + offset++, value);
            }
        });
    }

    @Override
    public ListValue.Immutable<E> without(int index) {
        return this.modifyCollection((List<E> list) -> list.remove(index));
    }

    public ListValue.Immutable<E> set(int index, E element) {
        return this.modifyCollection((List<E> list) -> list.set(index, element));
    }

    @Override
    protected ListValue.Immutable<E> modifyCollection(Consumer<List<E>> consumer) {
        ImmutableList list;
        if (this.element instanceof ImmutableList) {
            ArrayList temp = new ArrayList((Collection)this.element);
            consumer.accept(temp);
            list = ImmutableList.copyOf(temp);
        } else {
            list = new ArrayList((Collection)this.element);
            consumer.accept((List<E>)list);
        }
        return ((ListValue)this.key().getValueConstructor().getRawImmutable(list)).asImmutable();
    }

    public ListValue.Immutable<E> with(List<E> value) {
        return ((ListValue)this.key().getValueConstructor().getImmutable(value)).asImmutable();
    }

    public ListValue.Mutable<E> asMutable() {
        return new MutableSpongeListValue(this.key(), (List)this.get());
    }
}

