/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.common.data.key.SpongeKey;
import org.spongepowered.common.data.value.MutableSpongeCollectionValue;
import org.spongepowered.common.util.CopyHelper;

public final class MutableSpongeListValue<E>
extends MutableSpongeCollectionValue<E, List<E>, ListValue.Mutable<E>, ListValue.Immutable<E>>
implements ListValue.Mutable<E> {
    public MutableSpongeListValue(Key<? extends ListValue<E>> key, List<E> element) {
        super(key, element);
    }

    @Override
    public SpongeKey<? extends ListValue<E>, List<E>> key() {
        return super.key();
    }

    public E get(int index) {
        return ((List)this.element).get(index);
    }

    public int indexOf(E element) {
        return ((List)this.element).indexOf(element);
    }

    public ListValue.Mutable<E> add(int index, E value) {
        return this.modifyCollection((List<E> list) -> list.add(index, value));
    }

    public ListValue.Mutable<E> add(int index, Iterable<E> values) {
        return this.modifyCollection((List<E> list) -> {
            int offset = 0;
            for (Object value : values) {
                list.add(index + offset++, value);
            }
        });
    }

    @Override
    public ListValue.Mutable<E> remove(int index) {
        return this.modifyCollection((List<E> list) -> list.remove(index));
    }

    public ListValue.Mutable<E> set(int index, E element) {
        return this.modifyCollection((List<E> list) -> list.set(index, element));
    }

    public ListValue.Immutable<E> asImmutable() {
        return ((ListValue)this.key().getValueConstructor().getImmutable((List)this.element)).asImmutable();
    }

    public ListValue.Mutable<E> copy() {
        return new MutableSpongeListValue<E>(this.key(), CopyHelper.copy((List)this.element));
    }

    @Override
    protected ListValue.Mutable<E> modifyCollection(Consumer<List<E>> consumer) {
        List list = (List)this.element;
        if (list instanceof ImmutableList) {
            ArrayList copy = new ArrayList(list);
            consumer.accept(copy);
            this.set(ImmutableList.copyOf(copy));
        } else {
            consumer.accept(list);
        }
        return this;
    }
}

