/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.datapack.DataPackEntry;
import org.spongepowered.common.datapack.DataPackDecoder;
import org.spongepowered.common.datapack.DataPackEncoder;
import org.spongepowered.common.datapack.JsonDataPackSerializer;
import org.spongepowered.common.datapack.SpongeDataPack;
import org.spongepowered.common.datapack.SpongeDataPackType;

public abstract class DataPackSerializer<E, T extends DataPackEntry<T>> {
    protected DataPackEncoder<E, T> encoder;
    protected DataPackDecoder<E, T> decoder;

    public DataPackSerializer(DataPackEncoder<E, T> encoder, DataPackDecoder<E, T> decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public boolean serialize(SpongeDataPack<E, T> pack, Path packDir, List<T> packEntries) throws IOException {
        if (packEntries.isEmpty()) {
            return false;
        }
        for (DataPackEntry packEntry : packEntries) {
            this.serializeObject(pack, packDir, packEntry);
            this.serializeAdditional(pack, packDir, packEntry);
        }
        return true;
    }

    public Path packEntryFile(SpongeDataPackType<?, T> packType, ResourceKey key, Path packDir) {
        class_2960 loc = this.location(packType, key);
        return packDir.resolve("data").resolve(loc.method_12836()).resolve(loc.method_12832());
    }

    public class_2960 location(SpongeDataPackType<?, T> packType, ResourceKey key) {
        return class_2960.method_60655((String)key.namespace(), (String)(packType.dir() + "/" + key.value() + this.fileEnding()));
    }

    public abstract String fileEnding();

    public abstract void serializeObject(SpongeDataPack<E, T> var1, Path var2, T var3) throws IOException;

    protected abstract void serializeAdditional(SpongeDataPack<E, T> var1, Path var2, T var3) throws IOException;

    public abstract T deserialize(SpongeDataPack<E, T> var1, Path var2, ResourceKey var3) throws IOException;

    public abstract T deserialize(SpongeDataPack<E, T> var1, InputStream var2, ResourceKey var3) throws IOException;

    public static void writePackMetadata(SpongeDataPack<?, ?> pack, Path packDir, boolean replace) throws IOException {
        Path packMeta = packDir.resolve("pack.mcmeta");
        if (replace || !Files.exists(packMeta, new LinkOption[0])) {
            JsonObject packDataRoot = new JsonObject();
            JsonObject packData = new JsonObject();
            packDataRoot.add("pack", (JsonElement)packData);
            packData.addProperty("pack_format", (Number)class_155.method_16673().method_48017(class_3264.field_14190));
            packData.addProperty("description", pack.description());
            JsonDataPackSerializer.writeFile(packMeta, (JsonElement)packDataRoot);
        }
    }
}

