/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_5455;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.datapack.DataPackEntry;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.datapack.DataPackDecoder;
import org.spongepowered.common.datapack.DataPackEncoder;
import org.spongepowered.common.datapack.DataPackSerializer;
import org.spongepowered.common.datapack.SpongeDataPack;

public class NbtDataPackSerializer<T extends DataPackEntry<T>>
extends DataPackSerializer<class_2487, T> {
    public NbtDataPackSerializer(DataPackEncoder<class_2487, T> encoder, DataPackDecoder<class_2487, T> decoder) {
        super(encoder, decoder);
    }

    @Override
    public String fileEnding() {
        return ".nbt";
    }

    @Override
    public void serializeObject(SpongeDataPack<class_2487, T> pack, Path packDir, T packEntry) throws IOException {
        class_2487 serialized = (class_2487)this.encoder.encode(packEntry, (class_5455)SpongeCommon.server().method_30611());
        Path file = this.packEntryFile(pack.type(), packEntry.key(), packDir);
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        NbtDataPackSerializer.writeFile(file, serialized);
    }

    @Override
    protected void serializeAdditional(SpongeDataPack<class_2487, T> type, Path packDir, T entry) throws IOException {
    }

    @Override
    public T deserialize(SpongeDataPack<class_2487, T> pack, Path file, ResourceKey key) throws IOException {
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            T t = this.deserialize(pack, stream, key);
            return t;
        }
    }

    @Override
    public T deserialize(SpongeDataPack<class_2487, T> pack, InputStream is, ResourceKey key) throws IOException {
        try (DataInputStream dis = new DataInputStream(is);){
            class_2487 element = class_2507.method_10629((InputStream)dis, (class_2505)class_2505.method_53898());
            if (this.decoder != null) {
                Object t = this.decoder.decode(pack, key, element, (class_5455)SpongeCommon.server().method_30611());
                return t;
            }
        }
        return null;
    }

    public static void writeFile(Path file, class_2487 object) throws IOException {
        Files.deleteIfExists(file);
        class_2507.method_30614((class_2487)object, (Path)file);
    }
}

