/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.spongepowered.api.effect.ForwardingViewer;
import org.spongepowered.api.effect.Viewer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.World;
import org.spongepowered.common.effect.SpongeForwardingViewer;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeCustomForwardingViewer
implements SpongeForwardingViewer {
    private final Supplier<? extends Iterable<? extends Viewer>> viewersSupplier;

    private SpongeCustomForwardingViewer(Supplier<? extends Iterable<? extends Viewer>> viewersSupplier) {
        this.viewersSupplier = viewersSupplier;
    }

    public Iterable<? extends Viewer> audiences() {
        return this.viewersSupplier.get();
    }

    public static final class FactoryImpl
    implements ForwardingViewer.Factory {
        public ForwardingViewer of(Supplier<? extends Iterable<? extends Viewer>> viewersSupplier) {
            Objects.requireNonNull(viewersSupplier, "viewersSupplier");
            return new SpongeCustomForwardingViewer(viewersSupplier);
        }

        public ForwardingViewer of(Collection<? extends Viewer> viewers) {
            Objects.requireNonNull(viewers, "viewers");
            List<? extends Viewer> list = List.copyOf(viewers);
            return new SpongeCustomForwardingViewer(() -> list);
        }

        public ForwardingViewer of(Viewer ... viewers) {
            Objects.requireNonNull(viewers, "viewers");
            List<Viewer> list = List.of(viewers);
            return new SpongeCustomForwardingViewer(() -> list);
        }

        public ForwardingViewer allAround(World<?, ?> world, Vector3i position, int radius) {
            Objects.requireNonNull(world, "world");
            Objects.requireNonNull(position, "position");
            if (radius <= 0) {
                throw new IllegalArgumentException("The radius has to be greater then zero!");
            }
            return new SpongeCustomForwardingViewer(() -> FactoryImpl.listAllAround(world, position, radius));
        }

        public ForwardingViewer allAround(Entity entity, int radius) {
            Objects.requireNonNull(entity, "entity");
            if (radius <= 0) {
                throw new IllegalArgumentException("The radius has to be greater then zero!");
            }
            return new SpongeCustomForwardingViewer(() -> entity.isRemoved() ? List.of() : FactoryImpl.listAllAround(entity.world(), entity.blockPosition(), radius));
        }

        private static List<? extends Player> listAllAround(World<?, ?> world, Vector3i position, int radius) {
            int radiusSquared = radius * radius;
            return world.players().stream().filter(player -> player.blockPosition().distanceSquared(position) <= radiusSquared).toList();
        }
    }
}

