/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect;

import java.util.Objects;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.effect.Viewer;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.common.bridge.effect.ViewerBridge;
import org.spongepowered.common.effect.util.ViewerPacketUtil;

public interface SpongeViewer
extends Viewer {
    default public void sendWorldType(WorldType worldType) {
        ((ViewerBridge)((Object)this)).bridge$sendSpongePacketToViewer(ViewerPacketUtil.changeEnvironment(worldType));
    }

    default public void spawnParticles(ParticleEffect particleEffect, double x, double y, double z) {
        ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.spawnParticles(particleEffect, x, y, z));
    }

    default public void playMusicDisc(int x, int y, int z, MusicDisc musicDisc) {
    }

    default public void stopMusicDisc(int x, int y, int z) {
        ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.stopMusicDisc(x, y, z));
    }

    default public void sendBlockChange(int x, int y, int z, BlockState state) {
        ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.blockUpdate(x, y, z, state));
    }

    default public void resetBlockChange(int x, int y, int z) {
    }

    default public void sendBlockProgress(int x, int y, int z, double progress) {
    }

    default public void resetBlockProgress(int x, int y, int z) {
    }

    default public void stopSound(SoundStop stop) {
        ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.stopSound(stop));
    }

    default public void sendActionBar(Component message) {
        ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.setActionBarText(message));
    }

    default public void showTitle(Title title) {
        ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.showTitle(title));
    }

    default public <T> void sendTitlePart(TitlePart<T> part, T value) {
        Objects.requireNonNull(value, "value");
        if (part == TitlePart.TITLE) {
            ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.setTitleText((Component)value));
        } else if (part == TitlePart.SUBTITLE) {
            ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.setSubtitleText((Component)value));
        } else if (part == TitlePart.TIMES) {
            ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.setTitlesAnimation((Title.Times)value));
        } else {
            throw new IllegalArgumentException("Unknown TitlePart '" + String.valueOf(part) + "'");
        }
    }

    default public void clearTitle() {
        ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.clearTitles(false));
    }

    default public void resetTitle() {
        ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.clearTitles(true));
    }
}

