/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.data.DataDeserializer;
import org.spongepowered.common.effect.particle.SpongeParticleEffect;
import org.spongepowered.common.effect.particle.SpongeParticleOption;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.Preconditions;

public final class SpongeParticleEffectBuilder
extends AbstractDataBuilder<ParticleEffect>
implements ParticleEffect.Builder {
    private ParticleType type;
    private Map<ParticleOption<?>, Object> options;

    public SpongeParticleEffectBuilder() {
        super(ParticleEffect.class, 1);
        this.reset();
    }

    protected Optional<ParticleEffect> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Constants.Particles.PARTICLE_TYPE, new DataQuery[]{Constants.Particles.PARTICLE_OPTIONS})) {
            return Optional.empty();
        }
        ParticleType particleType = (ParticleType)container.getRegistryValue(Constants.Particles.PARTICLE_TYPE, (RegistryType)RegistryTypes.PARTICLE_TYPE, (RegistryHolder)Sponge.game()).get();
        HashMap options = new HashMap();
        ((List)container.getViewList(Constants.Particles.PARTICLE_OPTIONS).get()).forEach(view -> {
            ParticleOption option = (ParticleOption)view.getRegistryValue(Constants.Particles.PARTICLE_OPTION_KEY, (RegistryType)RegistryTypes.PARTICLE_OPTION, (RegistryHolder)Sponge.game()).get();
            BiFunction<DataView, DataQuery, Optional<DataView>> deserializer = DataDeserializer.deserializer(option.valueType());
            Object value = deserializer.apply((DataView)view, Constants.Particles.PARTICLE_OPTION_VALUE).get();
            options.put(option, value);
        });
        return Optional.of(new SpongeParticleEffect(particleType, options));
    }

    public ParticleEffect.Builder from(ParticleEffect particleEffect) {
        this.type = particleEffect.type();
        this.options = new HashMap(particleEffect.options());
        return this;
    }

    public ParticleEffect.Builder type(ParticleType particleType) {
        this.type = Objects.requireNonNull(particleType, "particleType");
        return this;
    }

    public ParticleEffect.Builder reset() {
        this.type = null;
        this.options = new HashMap();
        return this;
    }

    public <V> ParticleEffect.Builder option(ParticleOption<V> option, V value) throws IllegalArgumentException {
        Objects.requireNonNull(option, "option");
        Objects.requireNonNull(value, "value");
        IllegalArgumentException exception = ((SpongeParticleOption)option).validateValue(value);
        if (exception != null) {
            throw exception;
        }
        if (value instanceof List) {
            value = ImmutableList.copyOf((Collection)((List)value));
        }
        this.options.put(option, value);
        return this;
    }

    public ParticleEffect build() {
        Preconditions.checkArgument(this.type != null, "ParticleType must be set");
        return new SpongeParticleEffect(this.type, this.options);
    }
}

