/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_2388;
import net.minecraft.class_2390;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_5716;
import net.minecraft.class_5743;
import net.minecraft.class_5745;
import net.minecraft.class_7227;
import net.minecraft.class_7290;
import net.minecraft.class_8042;
import net.minecraft.class_9381;
import net.minecraft.class_9848;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.PositionSource;
import org.spongepowered.common.effect.particle.CachedParticlePacket;
import org.spongepowered.common.effect.particle.SpongeParticleEffect;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3f;

public final class SpongeParticleHelper {
    public static class_8042 createPacket(ParticleEffect effect, double x, double y, double z) {
        ArrayList<class_2596<? super class_2602>> packets = new ArrayList<class_2596<? super class_2602>>();
        SpongeParticleHelper.getCachedPacket((SpongeParticleEffect)effect).process(x, y, z, packets);
        return new class_8042(packets);
    }

    public static @Nullable class_2394 vanillaParticleOptions(ParticleEffect effect) {
        return SpongeParticleHelper.getCachedPacket((SpongeParticleEffect)effect).particleOptions();
    }

    private static CachedParticlePacket getCachedPacket(SpongeParticleEffect effect) {
        if (effect.cachedPacket == null) {
            ParticleType type = effect.type();
            effect.cachedPacket = SpongeParticleHelper.getNamedPacket(effect, (class_2396)type);
        }
        return effect.cachedPacket;
    }

    private static CachedParticlePacket getNamedPacket(ParticleEffect effect, class_2396<?> internalType) {
        Vector3f offset = ((Vector3d)effect.optionOrDefault((Supplier)ParticleOptions.OFFSET).get()).toFloat();
        int quantity = (Integer)effect.optionOrDefault((Supplier)ParticleOptions.QUANTITY).get();
        Vector3f velocity = effect.optionOrDefault((Supplier)ParticleOptions.VELOCITY).orElse(Vector3d.ZERO).toFloat();
        if (internalType instanceof class_2400) {
            return new NamedCachedPacket((class_2394)internalType, offset, quantity, velocity);
        }
        if (internalType == class_2398.field_11217 || internalType == class_2398.field_35434 || internalType == class_2398.field_11206 || internalType == class_2398.field_50248) {
            BlockState state = (BlockState)effect.optionOrDefault((Supplier)ParticleOptions.BLOCK_STATE).get();
            class_2388 particleData = new class_2388(internalType, (class_2680)state);
            return new NamedCachedPacket((class_2394)particleData, offset, quantity, velocity);
        }
        if (internalType == class_2398.field_28276) {
            Color color = (Color)effect.optionOrDefault((Supplier)ParticleOptions.COLOR).get();
            Color toColor = (Color)effect.optionOrDefault((Supplier)ParticleOptions.TO_COLOR).get();
            double scale = (Double)effect.optionOrDefault((Supplier)ParticleOptions.SCALE).get();
            class_5743 particleData = new class_5743(class_9848.method_61323((int)color.red(), (int)color.green(), (int)color.blue()), class_9848.method_61323((int)toColor.red(), (int)toColor.green(), (int)toColor.blue()), (float)scale);
            return new NamedCachedPacket((class_2394)particleData, offset, quantity, velocity);
        }
        if (internalType == class_2398.field_11212) {
            Color color = (Color)effect.optionOrDefault((Supplier)ParticleOptions.COLOR).get();
            double scale = (Double)effect.optionOrDefault((Supplier)ParticleOptions.SCALE).get();
            class_2390 particleData = new class_2390(class_9848.method_61323((int)color.red(), (int)color.green(), (int)color.blue()), (float)scale);
            return new NamedCachedPacket((class_2394)particleData, offset, quantity, velocity);
        }
        if (internalType == class_2398.field_11218) {
            ItemStackSnapshot snapshot = (ItemStackSnapshot)effect.optionOrDefault((Supplier)ParticleOptions.ITEM_STACK_SNAPSHOT).get();
            class_2392 particleData = new class_2392(internalType, ItemStackUtil.fromSnapshotToNative(snapshot));
            return new NamedCachedPacket((class_2394)particleData, offset, quantity, velocity);
        }
        if (internalType == class_2398.field_38003) {
            double roll = (Double)effect.optionOrDefault((Supplier)ParticleOptions.ROLL).get();
            class_7227 particleData = new class_7227((float)roll);
            return new NamedCachedPacket((class_2394)particleData, offset, quantity, velocity);
        }
        if (internalType == class_2398.field_38357) {
            int delay = (Integer)effect.optionOrDefault((Supplier)ParticleOptions.DELAY).get();
            class_7290 particleData = new class_7290(delay);
            return new NamedCachedPacket((class_2394)particleData, offset, quantity, velocity);
        }
        if (internalType == class_2398.field_28275) {
            PositionSource source = (PositionSource)effect.optionOrDefault((Supplier)ParticleOptions.DESTINATION).get();
            Ticks delay = (Ticks)effect.optionOrDefault((Supplier)ParticleOptions.TRAVEL_TIME).get();
            class_5745 particleData = new class_5745((class_5716)source, (int)delay.ticks());
            return new NamedCachedPacket((class_2394)particleData, offset, quantity, velocity);
        }
        if (internalType == class_2398.field_11226) {
            Color color = (Color)effect.optionOrDefault((Supplier)ParticleOptions.COLOR).get();
            double opacity = (Double)effect.optionOrDefault((Supplier)ParticleOptions.OPACITY).get();
            class_9381 particleData = class_9381.method_58256(internalType, (int)class_9848.method_61324((int)class_9848.method_61326((float)((float)opacity)), (int)color.red(), (int)color.green(), (int)color.blue()));
            return new NamedCachedPacket((class_2394)particleData, offset, quantity, velocity);
        }
        return EmptyCachedPacket.INSTANCE;
    }

    public static ParticleEffect spongeParticleOptions(class_2394 effect) {
        class_2396 type = effect.method_10295();
        if (type instanceof class_2400) {
            return new SpongeParticleEffect((ParticleType)type, Collections.emptyMap());
        }
        if (effect instanceof class_2388) {
            class_2388 blockOptions = (class_2388)effect;
            return new SpongeParticleEffect((ParticleType)type, Map.of((ParticleOption)ParticleOptions.BLOCK_STATE.get(), blockOptions.method_10278()));
        }
        if (effect instanceof class_5743) {
            class_5743 dustColorTransitionOptions = (class_5743)effect;
            return new SpongeParticleEffect((ParticleType)type, Map.of((ParticleOption)ParticleOptions.COLOR.get(), Color.of((Vector3f)Vector3f.from((float)dustColorTransitionOptions.method_33110().x, (float)dustColorTransitionOptions.method_33110().y, (float)dustColorTransitionOptions.method_33110().z).mul(255.0f)), (ParticleOption)ParticleOptions.TO_COLOR.get(), Color.of((Vector3f)Vector3f.from((float)dustColorTransitionOptions.method_33112().x, (float)dustColorTransitionOptions.method_33112().y, (float)dustColorTransitionOptions.method_33112().z).mul(255.0f)), (ParticleOption)ParticleOptions.SCALE.get(), Float.valueOf(dustColorTransitionOptions.method_59846())));
        }
        if (effect instanceof class_2390) {
            class_2390 dustOptions = (class_2390)effect;
            return new SpongeParticleEffect((ParticleType)type, Map.of((ParticleOption)ParticleOptions.COLOR.get(), Color.of((Vector3f)Vector3f.from((float)dustOptions.method_59843().x, (float)dustOptions.method_59843().y, (float)dustOptions.method_59843().z).mul(255.0f)), (ParticleOption)ParticleOptions.SCALE.get(), Float.valueOf(dustOptions.method_59846())));
        }
        if (effect instanceof class_2392) {
            class_2392 itemOptions = (class_2392)effect;
            return new SpongeParticleEffect((ParticleType)type, Map.of((ParticleOption)ParticleOptions.ITEM_STACK_SNAPSHOT.get(), ItemStackUtil.snapshotOf(itemOptions.method_10289())));
        }
        if (effect instanceof class_7227) {
            class_7227 sculkChargeOptions = (class_7227)effect;
            return new SpongeParticleEffect((ParticleType)type, Map.of((ParticleOption)ParticleOptions.ROLL.get(), Float.valueOf(sculkChargeOptions.comp_632())));
        }
        if (effect instanceof class_7290) {
            class_7290 shriekOption = (class_7290)effect;
            return new SpongeParticleEffect((ParticleType)type, Map.of((ParticleOption)ParticleOptions.DELAY.get(), shriekOption.method_42619()));
        }
        if (effect instanceof class_5745) {
            class_5745 vibrationOptions = (class_5745)effect;
            return new SpongeParticleEffect((ParticleType)type, Map.of((ParticleOption)ParticleOptions.DESTINATION.get(), vibrationOptions.method_33125(), (ParticleOption)ParticleOptions.TRAVEL_TIME.get(), Ticks.of((long)vibrationOptions.method_42624())));
        }
        if (effect instanceof class_9381) {
            class_9381 colorOptions = (class_9381)effect;
            return new SpongeParticleEffect((ParticleType)type, Map.of((ParticleOption)ParticleOptions.COLOR.get(), Color.of((Vector3f)Vector3f.from((float)colorOptions.method_58259(), (float)colorOptions.method_58263(), (float)colorOptions.method_58264()).mul(255.0f)), (ParticleOption)ParticleOptions.OPACITY.get(), Float.valueOf(colorOptions.method_58265())));
        }
        return new SpongeParticleEffect((ParticleType)type, Collections.emptyMap());
    }

    private static final class NamedCachedPacket
    implements CachedParticlePacket {
        private final class_2394 particleData;
        private final Vector3f offset;
        private final int quantity;
        private final Vector3f velocity;

        public NamedCachedPacket(class_2394 particleData, Vector3f offset, int quantity, Vector3f velocity) {
            this.particleData = particleData;
            this.offset = offset;
            this.quantity = quantity;
            this.velocity = velocity;
        }

        @Override
        public void process(double x, double y, double z, List<class_2596<? super class_2602>> output) {
            float posX = (float)x;
            float posY = (float)y;
            float posZ = (float)z;
            float offX = this.offset.x();
            float offY = this.offset.y();
            float offZ = this.offset.z();
            if (this.velocity.equals((Object)Vector3f.ZERO)) {
                class_2675 packet = new class_2675(this.particleData, true, (double)posX, (double)posY, (double)posZ, offX, offY, offZ, 0.0f, this.quantity);
                output.add((class_2596<? super class_2602>)packet);
            } else {
                float velocityX = this.velocity.x();
                float velocityY = this.velocity.y();
                float velocityZ = this.velocity.z();
                Random random = new Random();
                for (int i = 0; i < this.quantity; ++i) {
                    float px0 = posX + (random.nextFloat() * 2.0f - 1.0f) * offX;
                    float py0 = posY + (random.nextFloat() * 2.0f - 1.0f) * offY;
                    float pz0 = posZ + (random.nextFloat() * 2.0f - 1.0f) * offZ;
                    class_2675 packet = new class_2675(this.particleData, true, (double)px0, (double)py0, (double)pz0, velocityX, velocityY, velocityZ, 1.0f, 0);
                    output.add((class_2596<? super class_2602>)packet);
                }
            }
        }

        @Override
        public @Nullable class_2394 particleOptions() {
            return this.particleData;
        }
    }

    private static final class EmptyCachedPacket
    implements CachedParticlePacket {
        public static final EmptyCachedPacket INSTANCE = new EmptyCachedPacket();

        private EmptyCachedPacket() {
        }

        @Override
        public void process(double x, double y, double z, List<class_2596<? super class_2602>> output) {
        }

        @Override
        public @Nullable class_2394 particleOptions() {
            return null;
        }
    }
}

