/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.effect.particle.ParticleOption;

public final class SpongeParticleOption<V>
implements ParticleOption<V> {
    private final Class<V> valueType;
    private final @Nullable Function<V, IllegalArgumentException> valueValidator;

    public SpongeParticleOption(Class<V> valueType, @Nullable Function<V, IllegalArgumentException> valueValidator) {
        this.valueValidator = valueValidator;
        this.valueType = valueType;
    }

    public SpongeParticleOption(Class<V> valueType) {
        this(valueType, null);
    }

    public @Nullable IllegalArgumentException validateValue(V value) {
        if (this.valueValidator != null) {
            return this.valueValidator.apply(value);
        }
        return null;
    }

    public Class<V> valueType() {
        return this.valueType;
    }
}

