/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.potion;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_7923;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.Preconditions;
import org.spongepowered.common.util.SpongeTicks;

public final class SpongePotionBuilder
extends AbstractDataBuilder<PotionEffect>
implements PotionEffect.Builder {
    private @Nullable PotionEffectType potionType;
    private Ticks duration = Ticks.zero();
    private int amplifier;
    private boolean isAmbient;
    private boolean showParticles;
    private boolean showIcon;

    public SpongePotionBuilder() {
        super(PotionEffect.class, 2);
        this.reset();
    }

    public PotionEffect.Builder from(PotionEffect holder) {
        this.potionType = Objects.requireNonNull(holder).type();
        this.duration = holder.duration();
        this.amplifier = holder.amplifier();
        this.isAmbient = holder.isAmbient();
        this.showParticles = holder.showsParticles();
        this.showIcon = holder.showsIcon();
        return this;
    }

    protected Optional<PotionEffect> buildContent(DataView container) throws InvalidDataException {
        Objects.requireNonNull(container);
        if (!(container.contains(Constants.Item.Potions.POTION_TYPE) && container.contains(Constants.Item.Potions.POTION_DURATION) && container.contains(Constants.Item.Potions.POTION_AMPLIFIER) && container.contains(Constants.Item.Potions.POTION_AMBIANCE) && container.contains(Constants.Item.Potions.POTION_SHOWS_PARTICLES))) {
            return Optional.empty();
        }
        String effectName = (String)container.getString(Constants.Item.Potions.POTION_TYPE).get();
        Optional optional = Sponge.game().registry((RegistryType)RegistryTypes.POTION_EFFECT_TYPE).findValue(ResourceKey.resolve((String)effectName));
        if (!optional.isPresent()) {
            throw new InvalidDataException("The container has an invalid potion type name: " + effectName);
        }
        Ticks duration = SpongeTicks.ticksOrInfinite(((Integer)container.getInt(Constants.Item.Potions.POTION_DURATION).get()).intValue());
        int amplifier = (Integer)container.getInt(Constants.Item.Potions.POTION_AMPLIFIER).get();
        boolean ambience = (Boolean)container.getBoolean(Constants.Item.Potions.POTION_AMBIANCE).get();
        boolean particles = (Boolean)container.getBoolean(Constants.Item.Potions.POTION_SHOWS_PARTICLES).get();
        boolean showsIcon = container.getBoolean(Constants.Item.Potions.POTION_SHOWS_ICON).orElse(true);
        SpongePotionBuilder builder = new SpongePotionBuilder();
        return Optional.of(builder.potionType((PotionEffectType)optional.get()).showParticles(particles).showIcon(showsIcon).duration(duration).amplifier(amplifier).ambient(ambience).build());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull PotionEffect.Builder potionType(@NonNull PotionEffectType potionEffectType) {
        Objects.requireNonNull(potionEffectType, "Potion effect type cannot be null");
        this.potionType = potionEffectType;
        return this;
    }

    public PotionEffect.Builder duration(@NonNull Ticks duration) {
        if (!duration.isInfinite() && duration.ticks() <= 0L) {
            throw new IllegalArgumentException("Duration must be positive");
        }
        this.duration = duration;
        return this;
    }

    public PotionEffect.Builder amplifier(int amplifier) {
        this.amplifier = amplifier;
        return this;
    }

    public PotionEffect.Builder ambient(boolean ambience) {
        this.isAmbient = ambience;
        return this;
    }

    public PotionEffect.Builder showParticles(boolean showParticles) {
        this.showParticles = showParticles;
        return this;
    }

    public PotionEffect.Builder showIcon(boolean showIcon) {
        this.showIcon = showIcon;
        return this;
    }

    public PotionEffect build() throws IllegalStateException {
        Preconditions.checkState(this.potionType != null, "Potion type has not been set");
        if (!this.duration.isInfinite() && this.duration.ticks() <= 0L) {
            throw new IllegalStateException("Duration has not been set");
        }
        return (PotionEffect)new class_1293(class_7923.field_41174.method_47983((Object)((class_1291)this.potionType)), SpongeTicks.toSaturatedIntOrInfinite(this.duration), this.amplifier, this.isAmbient, this.showParticles, this.showIcon);
    }

    public PotionEffect.Builder reset() {
        this.potionType = null;
        this.amplifier = 0;
        this.duration = Ticks.zero();
        this.isAmbient = true;
        this.showParticles = true;
        this.showIcon = true;
        return this;
    }
}

