/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.util;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2620;
import net.minecraft.class_2626;
import net.minecraft.class_2673;
import net.minecraft.class_2680;
import net.minecraft.class_2765;
import net.minecraft.class_2767;
import net.minecraft.class_2770;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_5888;
import net.minecraft.class_5894;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8042;
import net.minecraft.class_9793;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Engine;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeEngine;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.effect.particle.SpongeParticleHelper;
import org.spongepowered.common.network.packet.ChangeViewerEnvironmentPacket;

public final class ViewerPacketUtil {
    public static ChangeViewerEnvironmentPacket changeEnvironment(WorldType worldType) {
        return new ChangeViewerEnvironmentPacket((class_2874)Objects.requireNonNull(worldType, "worldType"));
    }

    public static class_8042 spawnParticles(ParticleEffect particleEffect, double x, double y, double z) {
        return SpongeParticleHelper.createPacket(particleEffect, x, y, z);
    }

    public static class_2765 playSound(Sound sound, Entity entity) {
        Objects.requireNonNull(entity, "entity");
        class_6880<class_3414> event = ViewerPacketUtil.resolveEvent(sound);
        class_3419 source = SpongeAdventure.asVanilla(sound.source());
        class_1297 mcEntity = (class_1297)entity;
        long random = sound.seed().orElseGet(() -> mcEntity.method_37908().method_8409().method_43055());
        return new class_2765(event, source, mcEntity, sound.volume(), sound.pitch(), random);
    }

    public static class_2767 playSound(Sound sound, class_5819 randomSource, double x, double y, double z) {
        class_6880<class_3414> event = ViewerPacketUtil.resolveEvent(sound);
        class_3419 source = SpongeAdventure.asVanilla(sound.source());
        long random = sound.seed().orElseGet(() -> ((class_5819)randomSource).method_43055());
        return new class_2767(event, source, x, y, z, sound.volume(), sound.pitch(), random);
    }

    public static class_2770 stopSound(SoundStop stop) {
        Objects.requireNonNull(stop, "stop");
        @Nullable class_2960 sound = SpongeAdventure.asVanillaNullable(stop.sound());
        @Nullable class_3419 source = SpongeAdventure.asVanillaNullable(stop.source());
        return new class_2770(sound, source);
    }

    public static class_2673 playMusicDisc(int x, int y, int z, MusicDisc musicDisc, class_5455 registryAccess) {
        Objects.requireNonNull(musicDisc, "musicDisc");
        int songId = registryAccess.method_30530(class_7924.field_52176).method_10206((Object)((class_9793)musicDisc));
        return new class_2673(1010, new class_2338(x, y, z), songId, false);
    }

    public static class_2673 stopMusicDisc(int x, int y, int z) {
        return new class_2673(1011, new class_2338(x, y, z), 0, false);
    }

    public static class_2626 blockUpdate(int x, int y, int z, BlockState state) {
        Objects.requireNonNull(state, "state");
        return new class_2626(new class_2338(x, y, z), (class_2680)state);
    }

    public static class_2626 blockUpdate(int x, int y, int z, World<?, ?> world) {
        return new class_2626((class_1922)world, new class_2338(x, y, z));
    }

    public static class_2620 blockProgress(int x, int y, int z, double progress, Engine engine) {
        if (progress < 0.0 || progress > 1.0) {
            throw new IllegalArgumentException("Progress must be between 0 and 1");
        }
        class_2338 pos = new class_2338(x, y, z);
        int id = ((SpongeEngine)engine).getBlockDestructionIdCache().getOrCreate(pos);
        int progressStage = progress == 1.0 ? 9 : (int)(progress * 10.0);
        return new class_2620(id, pos, progressStage);
    }

    public static Optional<class_2620> resetBlockProgress(int x, int y, int z, Engine engine) {
        class_2338 pos = new class_2338(x, y, z);
        return ((SpongeEngine)engine).getBlockDestructionIdCache().get(pos).map(id -> new class_2620(id.intValue(), pos, -1));
    }

    public static class_5894 setActionBarText(Component message) {
        return new class_5894(SpongeAdventure.asVanilla(Objects.requireNonNull(message, "message")));
    }

    public static class_8042 showTitle(Title title) {
        Title.Times times = Objects.requireNonNull(title, "title").times();
        ArrayList<Object> packets = new ArrayList<Object>();
        if (times != null) {
            packets.add(ViewerPacketUtil.setTitlesAnimation(times));
        }
        packets.add(ViewerPacketUtil.setSubtitleText(title.subtitle()));
        packets.add(ViewerPacketUtil.setTitleText(title.title()));
        return new class_8042(packets);
    }

    public static class_5904 setTitleText(Component component) {
        return new class_5904(SpongeAdventure.asVanilla(component));
    }

    public static class_5903 setSubtitleText(Component component) {
        return new class_5903(SpongeAdventure.asVanilla(component));
    }

    public static class_5905 setTitlesAnimation(Title.Times times) {
        return new class_5905(ViewerPacketUtil.durationToTicks(times.fadeIn()), ViewerPacketUtil.durationToTicks(times.stay()), ViewerPacketUtil.durationToTicks(times.fadeOut()));
    }

    public static class_5888 clearTitles(boolean resetTimes) {
        return new class_5888(resetTimes);
    }

    private static class_6880<class_3414> resolveEvent(@NonNull Sound sound) {
        class_2960 soundKey = SpongeAdventure.asVanilla(Objects.requireNonNull(sound, "sound").name());
        class_2378 soundEventRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41225);
        class_3414 event = soundEventRegistry.method_17966(soundKey).orElseGet(() -> class_3414.method_47908((class_2960)soundKey));
        return soundEventRegistry.method_47983((Object)event);
    }

    private static int durationToTicks(Duration duration) {
        return (int)(duration.toMillis() / 50L);
    }

    private ViewerPacketUtil() {
    }
}

