/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1952;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_7924;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.util.weighted.WeightedSerializableObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.math.vector.Vector3d;

public final class EntityUtil {
    private EntityUtil() {
    }

    public static void despawnFilteredEntities(Iterable<? extends class_1297> originalEntities, SpawnEntityEvent event) {
        if (event.isCancelled()) {
            for (class_1297 class_12972 : originalEntities) {
                class_12972.method_31472();
            }
        } else {
            for (class_1297 class_12973 : originalEntities) {
                if (event.entities().contains(class_12973)) continue;
                class_12973.method_31472();
            }
        }
    }

    public static boolean processEntitySpawn(Entity entity, Supplier<Optional<UUID>> supplier, Consumer<class_1297> spawner) {
        Optional<class_1297> customEntityItem;
        class_1799 item;
        class_1297 minecraftEntity = (class_1297)entity;
        if (minecraftEntity instanceof class_1542 && !(item = ((class_1542)minecraftEntity).method_6983()).method_7960() && (customEntityItem = Optional.ofNullable(PlatformHooks.INSTANCE.getWorldHooks().getCustomEntityIfItem(minecraftEntity))).isPresent()) {
            class_1297 entityToSpawn = customEntityItem.get();
            supplier.get().ifPresent(spawned -> {
                if (entityToSpawn instanceof CreatorTrackedBridge) {
                    ((CreatorTrackedBridge)entityToSpawn).tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, (UUID)spawned);
                }
            });
            if (entityToSpawn.method_31481()) {
                ((EntityAccessor)entityToSpawn).invoker$unsetRemoved();
            }
            entityToSpawn.method_37908().method_8649(entityToSpawn);
            return true;
        }
        spawner.accept((class_1297)entity);
        return true;
    }

    public static Collection<Entity> spawnEntities(Iterable<? extends Entity> entities, Predicate<Entity> selector, Consumer<class_1297> spawning) {
        ArrayList<Entity> entitiesToSpawn = new ArrayList<Entity>();
        for (Entity entity : entities) {
            if (!selector.test(entity)) continue;
            entitiesToSpawn.add(entity);
        }
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom((Cause)PhaseTracker.getInstance().currentCause(), entitiesToSpawn);
        if (Sponge.eventManager().post((Event)event)) {
            return Collections.emptyList();
        }
        for (Entity entity : event.entities()) {
            EntityUtil.processEntitySpawn(entity, Optional::empty, spawning);
        }
        return Collections.unmodifiableCollection(new ArrayList(event.entities()));
    }

    private static Vector3d createDropMotion(boolean dropAround, class_1657 player, Random random) {
        double y;
        double z;
        double x;
        if (dropAround) {
            float f = random.nextFloat() * 0.5f;
            float f1 = random.nextFloat() * ((float)Math.PI * 2);
            x = -class_3532.method_15374((float)f1) * f;
            z = class_3532.method_15362((float)f1) * f;
            y = 0.2f;
        } else {
            float f2 = 0.3f;
            x = -class_3532.method_15374((float)(player.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(player.method_36455() * ((float)Math.PI / 180))) * f2;
            z = class_3532.method_15362((float)(player.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(player.method_36455() * ((float)Math.PI / 180))) * f2;
            y = -class_3532.method_15374((float)(player.method_36455() * ((float)Math.PI / 180))) * f2 + 0.1f;
            float f3 = random.nextFloat() * ((float)Math.PI * 2);
            f2 = 0.02f * random.nextFloat();
            x += Math.cos(f3) * (double)f2;
            y += (double)((random.nextFloat() - random.nextFloat()) * 0.1f);
            z += Math.sin(f3) * (double)f2;
        }
        return new Vector3d(x, y, z);
    }

    public static boolean isUntargetable(class_1297 from, class_1297 target) {
        if (((VanishableBridge)target).bridge$vanishState().untargetable()) {
            return true;
        }
        return from.method_37908() != target.method_37908();
    }

    public static EntityArchetype toArchetype(class_1952 logic) {
        class_2487 tag = logic.comp_64();
        String resourceLocation = tag.method_10558("id");
        class_2378 entityTypeRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41266);
        EntityType type = entityTypeRegistry.method_17966(class_2960.method_60654((String)resourceLocation)).map(EntityType.class::cast).orElse((EntityType)EntityTypes.PIG.get());
        return SpongeEntityArchetypeBuilder.pooled().type(type).entityData((DataView)NBTTranslator.INSTANCE.translateFrom(tag)).build();
    }

    public static class_1952 toSpawnData(EntityArchetype value) {
        class_2487 tag = NBTTranslator.INSTANCE.translate((DataView)value.entityData());
        if (!tag.method_10545("id")) {
            ResourceKey key = (ResourceKey)class_1299.method_5890((class_1299)((class_1299)value.type()));
            tag.method_10582("id", key.toString());
        }
        return new class_1952(tag, Optional.empty(), Optional.empty());
    }

    public static WeightedTable<EntityArchetype> toWeightedArchetypes(class_6005<class_1952> spawnData) {
        WeightedTable possibleEntities = new WeightedTable();
        for (class_6008.class_6010 weightedEntity : spawnData.method_34994()) {
            class_2487 nbt = ((class_1952)weightedEntity.comp_2542()).comp_64();
            String resourceLocation = nbt.method_10558("id");
            Optional mcType = SpongeCommon.vanillaRegistry(class_7924.field_41266).method_17966(class_2960.method_60654((String)resourceLocation));
            EntityType type = mcType.map(EntityType.class::cast).orElse((EntityType)EntityTypes.PIG.get());
            EntityArchetype archetype = SpongeEntityArchetypeBuilder.pooled().type(type).entityData((DataView)NBTTranslator.INSTANCE.translateFrom(nbt)).build();
            possibleEntities.add((TableEntry)new WeightedSerializableObject((DataSerializable)archetype, weightedEntity.method_34979().method_34976()));
        }
        return possibleEntities;
    }

    public static class_6005<class_1952> toSpawnPotentials(WeightedTable<EntityArchetype> table) {
        class_6005.class_6006 builder = class_6005.method_34971();
        for (TableEntry entry : table) {
            if (!(entry instanceof WeightedObject)) continue;
            WeightedObject weightedObj = (WeightedObject)entry;
            class_2487 tag = NBTTranslator.INSTANCE.translate((DataView)((EntityArchetype)weightedObj.get()).entityData());
            if (!tag.method_10545("id")) {
                class_2960 key = class_1299.method_5890((class_1299)((class_1299)((EntityArchetype)weightedObj.get()).type()));
                tag.method_10582("id", key.toString());
            }
            builder.method_34975((Object)new class_1952(tag, Optional.empty(), Optional.empty()), (int)entry.weight());
        }
        return builder.method_34974();
    }
}

