/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.bridge.data.DataContainerHolder;
import org.spongepowered.common.data.AbstractArchetype;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.validation.ValidationTypes;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.util.Constants;
import org.spongepowered.math.vector.Vector3d;

public final class SpongeEntityArchetype
extends AbstractArchetype<EntityType, EntitySnapshot, Entity>
implements EntityArchetype,
DataContainerHolder.Mutable {
    public static final ImmutableList<RawDataValidator> VALIDATORS = ImmutableList.of();
    private static final DataProviderLookup lookup = SpongeDataManager.getProviderRegistry().getProviderLookup(SpongeEntityArchetype.class);
    private @Nullable Vector3d position;

    SpongeEntityArchetype(SpongeEntityArchetypeBuilder builder) {
        this(builder.entityType, builder.compound);
        this.position = builder.position;
    }

    private SpongeEntityArchetype(EntityType<@NonNull ?> type, @Nullable class_2487 compound) {
        super(type, compound != null ? compound : new class_2487());
    }

    public EntityType<@NonNull ?> type() {
        return (EntityType)this.type;
    }

    public @Nullable class_2487 getData() {
        return this.compound;
    }

    @Override
    public DataProviderLookup getLookup() {
        return lookup;
    }

    public Optional<Vector3d> getPosition() {
        if (this.position != null) {
            return Optional.of(this.position);
        }
        if (!this.compound.method_10573("Pos", 9)) {
            return Optional.empty();
        }
        try {
            class_2499 pos = this.compound.method_10554("Pos", 6);
            double x = pos.method_10611(0);
            double y = pos.method_10611(1);
            double z = pos.method_10611(2);
            this.position = new Vector3d(x, y, z);
            return Optional.of(this.position);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public DataContainer data$getDataContainer() {
        return this.entityData();
    }

    @Override
    public void data$setDataContainer(DataContainer container) {
        this.compound = NBTTranslator.INSTANCE.translate((DataView)Objects.requireNonNull(container, "DataContainer cannot be null!"));
    }

    public DataContainer entityData() {
        return NBTTranslator.INSTANCE.translateFrom(this.compound);
    }

    public Optional<Entity> apply(ServerLocation location) {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return Optional.empty();
        }
        ServerWorld spongeWorld = (ServerWorld)location.world();
        class_3218 level = (class_3218)spongeWorld;
        class_2960 key = class_1299.method_5890((class_1299)((class_1299)this.type));
        if (key == null) {
            return Optional.empty();
        }
        class_2487 compound = this.compound.method_10553();
        compound.method_10582("id", key.toString());
        class_2499 pos = new class_2499();
        pos.add((Object)class_2489.method_23241((double)location.x()));
        pos.add((Object)class_2489.method_23241((double)location.y()));
        pos.add((Object)class_2489.method_23241((double)location.z()));
        compound.method_10566("Pos", (class_2520)pos);
        compound.method_10551("UUID");
        @Nullable class_1297 entity = class_1299.method_17842((class_2487)compound, (class_1937)level, (class_3730)class_3730.field_52444, e -> {
            e.method_24203(location.x(), location.y(), location.z());
            if (e instanceof class_1308) {
                class_1308 mobentity = (class_1308)e;
                mobentity.field_6241 = mobentity.method_36454();
                mobentity.field_6283 = mobentity.method_36455();
            }
            return e;
        });
        if (entity == null) {
            return Optional.empty();
        }
        if (level.method_30736(entity)) {
            return Optional.of((Entity)entity);
        }
        return Optional.empty();
    }

    public EntitySnapshot toSnapshot(ServerLocation location) {
        SpongeEntitySnapshotBuilder builder = new SpongeEntitySnapshotBuilder();
        builder.entityType = (EntityType)this.type;
        class_2487 newCompound = this.compound.method_10553();
        Vector3d pos = location.position();
        newCompound.method_10566("Pos", (class_2520)Constants.NBT.newDoubleNBTList(pos.x(), pos.y(), pos.z()));
        newCompound.method_10582("WorldKey", location.worldKey().formatted());
        builder.compound = newCompound;
        builder.worldKey = ((ServerWorld)location.world()).properties().key();
        builder.position = pos;
        builder.rotation = this.getRotation();
        builder.scale = Vector3d.ONE;
        return builder.build();
    }

    private Vector3d getRotation() {
        class_2499 tag = this.compound.method_10554("Rotation", 5);
        float rotationYaw = tag.method_10604(0);
        float rotationPitch = tag.method_10604(1);
        return new Vector3d(rotationPitch, rotationYaw, 0.0f);
    }

    public int contentVersion() {
        return 1;
    }

    public DataContainer toContainer() {
        return DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED).set(Queries.CONTENT_VERSION, (Object)this.contentVersion()).set(Constants.Sponge.EntityArchetype.ENTITY_TYPE, this.type).set(Constants.Sponge.EntityArchetype.ENTITY_DATA, (Object)this.entityData());
    }

    @Override
    protected ValidationType getValidationType() {
        return (ValidationType)ValidationTypes.ENTITY.get();
    }

    public SpongeEntityArchetype copy() {
        return new SpongeEntityArchetype((EntityType)this.type, this.compound.method_10553());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeEntityArchetype that = (SpongeEntityArchetype)o;
        return Objects.equals(this.position, that.position);
    }

    @Override
    protected ImmutableList<RawDataValidator> getValidators() {
        return VALIDATORS;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.position);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", SpongeEntityArchetype.class.getSimpleName() + "[", "]").add("position=" + String.valueOf(this.position)).add("type=" + String.valueOf(this.type)).toString();
    }
}

