/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.data.nbt.validation.DelegateDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.validation.ValidationTypes;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.entity.SpongeEntityArchetype;
import org.spongepowered.common.entity.SpongeEntityTypes;
import org.spongepowered.common.util.Constants;
import org.spongepowered.math.vector.Vector3d;

public class SpongeEntityArchetypeBuilder
extends AbstractDataBuilder<EntityArchetype>
implements EntityArchetype.Builder {
    private static final Deque<SpongeEntityArchetypeBuilder> pool = new ConcurrentLinkedDeque<SpongeEntityArchetypeBuilder>();
    @MonotonicNonNull EntityType<@NonNull ?> entityType = null;
    @Nullable class_2487 compound;
    // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable DataManipulator.Mutable manipulator;
    @Nullable Vector3d position;
    private final boolean pooled;

    public static SpongeEntityArchetypeBuilder unpooled() {
        return new SpongeEntityArchetypeBuilder(false);
    }

    public static SpongeEntityArchetypeBuilder pooled() {
        @Nullable SpongeEntityArchetypeBuilder builder = pool.pollFirst();
        if (builder != null) {
            return builder.reset();
        }
        return new SpongeEntityArchetypeBuilder(true);
    }

    private SpongeEntityArchetypeBuilder(boolean pooled) {
        super(EntityArchetype.class, 1);
        this.pooled = pooled;
    }

    public SpongeEntityArchetypeBuilder reset() {
        this.entityType = null;
        this.manipulator = null;
        this.compound = null;
        this.position = null;
        return this;
    }

    public EntityArchetype.Builder from(EntityArchetype value) {
        this.entityType = value.type();
        this.compound = NBTTranslator.INSTANCE.translate((DataView)value.entityData());
        SpongeEntityArchetypeBuilder.stripCompound(this.compound);
        this.manipulator = null;
        return this;
    }

    protected Optional<EntityArchetype> buildContent(DataView container) throws InvalidDataException {
        SpongeEntityArchetypeBuilder builder = SpongeEntityArchetypeBuilder.pooled();
        if (!container.contains(Constants.Sponge.EntityArchetype.ENTITY_TYPE)) {
            throw new InvalidDataException("Missing the EntityType! Cannot re-construct an EntityArchetype!");
        }
        builder.type((EntityType)container.getRegistryValue(Constants.Sponge.EntityArchetype.ENTITY_TYPE, (RegistryType)RegistryTypes.ENTITY_TYPE, (RegistryHolder)Sponge.game()).orElseThrow(() -> new InvalidDataException("Could not deserialize an EntityType!")));
        if (container.contains(Constants.Sponge.EntityArchetype.ENTITY_DATA)) {
            builder.entityData((DataView)container.getView(Constants.Sponge.EntityArchetype.ENTITY_DATA).orElseThrow(() -> new InvalidDataException("No DataView found for the 'EntityData' data tag!")));
        }
        return Optional.of(builder.build());
    }

    public EntityArchetype.Builder type(EntityType<@NonNull ?> type) {
        if (this.entityType != Objects.requireNonNull(type, "EntityType cannot be null!")) {
            this.compound = null;
        }
        this.entityType = type;
        return this;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public EntityArchetype.Builder from(Entity entity) {
        @NonNull EntityType entityType = Objects.requireNonNull(Objects.requireNonNull(entity, "Cannot build an EntityArchetype for a null entity!").type(), "Entity is returning a null EntityType!");
        if (!((class_1299)entityType).method_5893() && entityType != SpongeEntityTypes.HUMAN) {
            throw new IllegalArgumentException("Attempting to archetype a non-serializable entity: " + String.valueOf(entity));
        }
        this.entityType = entityType;
        class_2487 compound = new class_2487();
        class_1297 mcEntity = (class_1297)entity;
        if (entityType == SpongeEntityTypes.HUMAN) {
            mcEntity.method_5647(compound);
        } else {
            mcEntity.method_5786(compound);
        }
        this.position = new Vector3d(mcEntity.method_23317(), mcEntity.method_23318(), mcEntity.method_23321());
        SpongeEntityArchetypeBuilder.stripCompound(compound);
        this.position = entity.position();
        this.compound = compound;
        return this;
    }

    public void entityData(class_2487 tag) {
        Objects.requireNonNull(tag, "Provided CompoundTag cannot be null!");
        this.compound = tag.method_10553();
        SpongeEntityArchetypeBuilder.stripCompound(this.compound);
    }

    public EntityArchetype.Builder entityData(DataView view) {
        DataContainer container = Objects.requireNonNull(view, "Provided DataView cannot be null!").copy();
        new DelegateDataValidator(SpongeEntityArchetype.VALIDATORS, (ValidationType)ValidationTypes.ENTITY.get()).validate((DataView)container);
        this.entityData(NBTTranslator.INSTANCE.translate((DataView)container));
        return this;
    }

    public <V> EntityArchetype.Builder add(Key<? extends Value<V>> key, V value) {
        if (this.manipulator == null) {
            this.manipulator = DataManipulator.mutableOf();
        }
        this.manipulator.set(Objects.requireNonNull(key, "Key cannot be null!"), Objects.requireNonNull(value, "Value cannot be null!"));
        return this;
    }

    public EntityArchetype build() {
        Objects.requireNonNull(this.entityType, "Entity type cannot be nulL!");
        SpongeEntityArchetype archetype = new SpongeEntityArchetype(this);
        if (this.manipulator != null) {
            archetype.copyFrom((ValueContainer)this.manipulator);
        }
        if (this.pooled) {
            this.reset();
            pool.push(this);
        }
        return archetype;
    }

    protected static void stripCompound(class_2487 compound) {
        compound.method_10551("UUID");
        compound.method_10551("UUIDMost");
        compound.method_10551("UUIDLeast");
        compound.method_10551("Pos");
    }
}

