/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai.goal.builtin.creature;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ai.goal.builtin.creature.AvoidLivingGoal;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.PathfinderAgent;
import org.spongepowered.api.world.server.ServerWorld;

public final class SpongeAvoidLivingGoalBuilder
implements AvoidLivingGoal.Builder {
    private Predicate<Living> targetSelector;
    private float searchDistance;
    private double closeRangeSpeed;
    private double farRangeSpeed;

    public SpongeAvoidLivingGoalBuilder() {
        this.reset();
    }

    public AvoidLivingGoal.Builder targetSelector(Predicate<Living> predicate) {
        this.targetSelector = predicate;
        return this;
    }

    public AvoidLivingGoal.Builder searchDistance(float distance) {
        this.searchDistance = distance;
        return this;
    }

    public AvoidLivingGoal.Builder closeRangeSpeed(double speed) {
        this.closeRangeSpeed = speed;
        return this;
    }

    public AvoidLivingGoal.Builder farRangeSpeed(double speed) {
        this.farRangeSpeed = speed;
        return this;
    }

    public AvoidLivingGoal.Builder from(AvoidLivingGoal value) {
        return this.targetSelector(e -> value.targetSelector().test(e, (ServerWorld)e.world())).searchDistance(value.searchDistance()).closeRangeSpeed(value.closeRangeSpeed()).farRangeSpeed(value.farRangeSpeed());
    }

    public AvoidLivingGoal.Builder reset() {
        this.targetSelector = null;
        this.searchDistance = 1.0f;
        this.closeRangeSpeed = 1.0;
        this.farRangeSpeed = 1.0;
        return this;
    }

    public AvoidLivingGoal build(PathfinderAgent owner) {
        Objects.requireNonNull(owner);
        Objects.requireNonNull(this.targetSelector);
        return (AvoidLivingGoal)new class_1338((class_1314)owner, Entity.class, this.searchDistance, this.closeRangeSpeed, this.farRangeSpeed, this.targetSelector);
    }
}

