/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai.goal.builtin.creature;

import java.util.Objects;
import net.minecraft.class_1381;
import net.minecraft.class_1603;
import org.spongepowered.api.entity.ai.goal.builtin.creature.RangedAttackAgainstAgentGoal;
import org.spongepowered.api.entity.living.RangedAgent;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.util.SpongeTicks;

public final class SpongeRangedAttackAgainstAgentGoalBuilder
implements RangedAttackAgainstAgentGoal.Builder {
    private double maxSpeed;
    private Ticks delayBetweenAttacks = Ticks.zero();
    private float attackRadius;

    public SpongeRangedAttackAgainstAgentGoalBuilder() {
        this.reset();
    }

    public RangedAttackAgainstAgentGoal.Builder moveSpeed(double speed) {
        this.maxSpeed = speed;
        return this;
    }

    public RangedAttackAgainstAgentGoal.Builder delayBetweenAttacks(Ticks delay) {
        this.delayBetweenAttacks = delay;
        return this;
    }

    public RangedAttackAgainstAgentGoal.Builder attackRadius(float radius) {
        this.attackRadius = radius;
        return this;
    }

    public RangedAttackAgainstAgentGoal.Builder from(RangedAttackAgainstAgentGoal value) {
        Objects.requireNonNull(value);
        this.maxSpeed = value.moveSpeed();
        this.delayBetweenAttacks = value.delayBetweenAttacks();
        this.attackRadius = value.attackRadius();
        return this;
    }

    public RangedAttackAgainstAgentGoal.Builder reset() {
        this.maxSpeed = 1.25;
        this.delayBetweenAttacks = new SpongeTicks(20L);
        this.attackRadius = 10.0f;
        return this;
    }

    public RangedAttackAgainstAgentGoal build(RangedAgent owner) {
        Objects.requireNonNull(owner);
        if (!(owner instanceof class_1603)) {
            throw new IllegalArgumentException("Ranger must be an IRangedAttackMob!");
        }
        return (RangedAttackAgainstAgentGoal)new class_1381((class_1603)owner, this.maxSpeed, SpongeTicks.toSaturatedIntOrInfinite(this.delayBetweenAttacks, -2), this.attackRadius);
    }
}

