/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.effect;

import java.util.Objects;
import org.spongepowered.api.effect.VanishState;

public final class SpongeVanishState
implements VanishState {
    private static final VanishState VISIBLE = new SpongeVanishState(false, true, false, true, true, true, true);
    private static final VanishState DEFAULT_VANISHED = new SpongeVanishState(true, false, true, false, false, false, false);
    private final boolean vanished;
    private final boolean ignoresCollisions;
    private final boolean untargetable;
    private final boolean affectsSpawning;
    private final boolean createsSounds;
    private final boolean createsParticles;
    private final boolean triggersVibrations;

    SpongeVanishState(boolean vanished, boolean collisions, boolean untargetable, boolean affectsSpawning, boolean createsSounds, boolean createsParticles, boolean triggersVibrations) {
        this.vanished = vanished;
        if (!vanished) {
            this.ignoresCollisions = false;
            this.untargetable = false;
            this.affectsSpawning = true;
            this.createsSounds = true;
            this.createsParticles = true;
            this.triggersVibrations = true;
            return;
        }
        this.ignoresCollisions = collisions;
        this.untargetable = untargetable;
        this.affectsSpawning = affectsSpawning;
        this.createsSounds = createsSounds;
        this.createsParticles = createsParticles;
        this.triggersVibrations = triggersVibrations;
    }

    public boolean invisible() {
        return this.vanished;
    }

    public VanishState vanish() {
        if (this.vanished) {
            return this;
        }
        return DEFAULT_VANISHED;
    }

    public VanishState unvanish() {
        return VISIBLE;
    }

    public boolean ignoresCollisions() {
        return this.ignoresCollisions;
    }

    public VanishState ignoreCollisions(boolean ignoresCollisions) {
        if (!this.vanished) {
            return this;
        }
        if (this.ignoresCollisions == ignoresCollisions) {
            return this;
        }
        return new SpongeVanishState(true, ignoresCollisions, this.untargetable, this.affectsSpawning, this.createsSounds, this.createsParticles, this.triggersVibrations);
    }

    public boolean untargetable() {
        return this.untargetable;
    }

    public VanishState untargetable(boolean untargetable) {
        if (!this.vanished) {
            return this;
        }
        if (this.untargetable == untargetable) {
            return this;
        }
        return new SpongeVanishState(true, this.ignoresCollisions, untargetable, this.affectsSpawning, this.createsSounds, this.createsParticles, this.triggersVibrations);
    }

    public boolean affectsMonsterSpawning() {
        return this.affectsSpawning;
    }

    public VanishState affectMonsterSpawning(boolean affectsMonsterSpawning) {
        if (!this.vanished) {
            return this;
        }
        if (this.affectsSpawning == affectsMonsterSpawning) {
            return this;
        }
        return new SpongeVanishState(true, this.ignoresCollisions, this.untargetable, affectsMonsterSpawning, this.createsSounds, this.createsParticles, this.triggersVibrations);
    }

    public boolean createsSounds() {
        return this.createsSounds;
    }

    public VanishState createSounds(boolean createSounds) {
        if (!this.vanished) {
            return this;
        }
        if (this.createsSounds == createSounds) {
            return this;
        }
        return new SpongeVanishState(true, this.ignoresCollisions, this.untargetable, this.affectsSpawning, createSounds, this.createsParticles, this.triggersVibrations);
    }

    public boolean createsParticles() {
        return this.createsParticles;
    }

    public VanishState createParticles(boolean createParticles) {
        if (!this.vanished) {
            return this;
        }
        if (this.createsParticles == createParticles) {
            return this;
        }
        return new SpongeVanishState(true, this.ignoresCollisions, this.untargetable, this.affectsSpawning, this.createsSounds, createParticles, this.triggersVibrations);
    }

    public boolean triggerVibrations() {
        return this.triggersVibrations;
    }

    public VanishState triggerVibrations(boolean triggerVibrations) {
        if (!this.vanished) {
            return this;
        }
        if (this.triggersVibrations == triggerVibrations) {
            return this;
        }
        return new SpongeVanishState(true, this.ignoresCollisions, this.untargetable, this.affectsSpawning, this.createsSounds, this.createsParticles, triggerVibrations);
    }

    public String toString() {
        return "SpongeVanishState{vanished=" + this.vanished + ", ignoresCollisions=" + this.ignoresCollisions + ", untargetable=" + this.untargetable + ", affectsSpawning=" + this.affectsSpawning + ", createsSounds=" + this.createsSounds + ", createsParticles=" + this.createsParticles + "}";
    }

    public int hashCode() {
        return Objects.hash(this.vanished, this.ignoresCollisions, this.untargetable, this.affectsSpawning, this.createsSounds, this.createsParticles);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VanishState)) {
            return false;
        }
        VanishState other = (VanishState)obj;
        return this.invisible() == other.invisible() && this.ignoresCollisions == other.ignoresCollisions() && this.untargetable == other.untargetable() && this.affectsSpawning == other.affectsMonsterSpawning() && this.createsSounds == other.createsSounds() && this.createsParticles == other.createsParticles();
    }

    public static final class SpongeVanishStateFactory
    implements VanishState.Factory {
        public VanishState vanished() {
            return DEFAULT_VANISHED;
        }

        public VanishState unvanished() {
            return VISIBLE;
        }
    }
}

