/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.living.human;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1394;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1744;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_268;
import net.minecraft.class_2703;
import net.minecraft.class_2716;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_7828;
import net.minecraft.class_7924;
import net.minecraft.class_9296;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.scoreboard.TeamMember;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.protocol.game.ClientboundAddEntityPacketAccessor;
import org.spongepowered.common.accessor.network.protocol.game.ClientboundPlayerInfoUpdatePacketAccessor;
import org.spongepowered.common.accessor.world.entity.LivingEntityAccessor;
import org.spongepowered.common.accessor.world.entity.player.PlayerAccessor;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.profile.SpongeProfileProperty;
import org.spongepowered.common.util.SpongeTicks;

public final class HumanEntity
extends class_1314
implements TeamMember,
class_1603 {
    public static final class_5321<class_1299<?>> KEY = class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"sponge", (String)"human"));
    private final Map<UUID, List<Stream<class_2596<?>>>> playerPacketMap = new HashMap();
    private class_9296 fakeProfile = new class_9296(new GameProfile(this.field_6021, ""));
    private boolean aiDisabled = false;
    private boolean leftHanded = false;

    public static class_5132 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23719, (double)0.23f).method_26867(class_5134.field_23723).method_26867(class_5134.field_23726).method_26866();
    }

    public HumanEntity(class_1299<? extends HumanEntity> type, class_1937 world) {
        super(type, world);
        this.method_5952(true);
        this.field_6011.method_12778(PlayerAccessor.accessor$DATA_PLAYER_MODE_CUSTOMISATION(), (Object)127);
    }

    protected void method_5693(class_2945.class_9222 $$0) {
        $$0.method_56912(LivingEntityAccessor.accessor$DATA_LIVING_ENTITY_FLAGS(), (Object)0);
        $$0.method_56912(LivingEntityAccessor.accessor$DATA_HEALTH_ID(), (Object)Float.valueOf(1.0f));
        $$0.method_56912(LivingEntityAccessor.accessor$DATA_EFFECT_PARTICLES(), List.of());
        $$0.method_56912(LivingEntityAccessor.accessor$DATA_EFFECT_AMBIENCE_ID(), (Object)Boolean.FALSE);
        $$0.method_56912(LivingEntityAccessor.accessor$DATA_ARROW_COUNT_ID(), (Object)0);
        $$0.method_56912(LivingEntityAccessor.accessor$DATA_STINGER_COUNT_ID(), (Object)0);
        $$0.method_56912(LivingEntityAccessor.accessor$SLEEPING_POS_ID(), Optional.empty());
        $$0.method_56912(PlayerAccessor.accessor$DATA_PLAYER_ABSORPTION_ID(), (Object)Float.valueOf(0.0f));
        $$0.method_56912(PlayerAccessor.accessor$DATA_SCORE_ID(), (Object)0);
        $$0.method_56912(PlayerAccessor.accessor$DATA_PLAYER_MODE_CUSTOMISATION(), (Object)0);
        $$0.method_56912(PlayerAccessor.accessor$DATA_PLAYER_MAIN_HAND(), (Object)1);
        $$0.method_56912(PlayerAccessor.accessor$DATA_SHOULDER_LEFT(), (Object)new class_2487());
        $$0.method_56912(PlayerAccessor.accessor$DATA_SHOULDER_RIGHT(), (Object)new class_2487());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
    }

    public boolean method_5961() {
        return this.leftHanded;
    }

    public boolean method_5987() {
        return this.aiDisabled;
    }

    public Component teamRepresentation() {
        return Component.text((String)this.fakeProfile.comp_2410().orElse(""));
    }

    public class_268 method_5781() {
        return this.method_37908().method_8428().method_1164(this.fakeProfile.comp_2410().orElse(""));
    }

    public void method_5665(@Nullable class_2561 name) {
        class_2561 customName = this.method_5797();
        if (customName == null && name == null || customName != null && customName.equals((Object)name)) {
            return;
        }
        super.method_5665(name);
        this.setProfileName(name);
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("profile")) {
            class_9296.field_49359.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("profile")).resultOrPartial($$0x -> SpongeCommon.logger().error("Failed to load profile from player head: {}", $$0x)).ifPresent(profile -> {
                this.fakeProfile = profile;
            });
            this.method_5826((UUID)this.fakeProfile.comp_2411().get());
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        DataResult result = class_9296.field_49359.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.fakeProfile);
        result.ifSuccess(gameProfile -> tag.method_10566("profile", gameProfile));
    }

    public void method_6007() {
        super.method_6007();
        this.method_6119();
    }

    public void method_5977(boolean disable) {
        this.aiDisabled = disable;
    }

    public void method_5937(boolean leftHanded) {
        this.leftHanded = leftHanded;
    }

    public void method_19540(boolean aggressive) {
    }

    protected class_3414 method_5737() {
        return class_3417.field_14998;
    }

    protected class_3414 method_5625() {
        return class_3417.field_14810;
    }

    public int method_5806() {
        return 10;
    }

    public void method_6078(@Nullable class_1282 cause) {
        super.method_6078(cause);
        this.method_23311();
        if (cause != null) {
            this.method_18800(-class_3532.method_15362((float)((this.method_48157() + this.method_36454()) * ((float)Math.PI / 180))) * 0.1f, 0.1f, -class_3532.method_15374((float)((this.method_48157() + this.method_36454()) * ((float)Math.PI / 180))) * 0.1f);
        } else {
            this.method_18800(0.0, 0.1, 0.0);
        }
        this.method_5646();
        this.method_5729(0, false);
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15115;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14904;
    }

    public class_243 method_55668(class_1297 $$0) {
        return super.method_55668($$0);
    }

    public float method_6029() {
        return (float)this.method_5996(class_5134.field_23719).method_6194();
    }

    public class_1309.class_6823 method_39760() {
        return new class_1309.class_6823(class_3417.field_14778, class_3417.field_14794);
    }

    public float method_6067() {
        return ((Float)this.method_5841().method_12789(PlayerAccessor.accessor$DATA_PLAYER_ABSORPTION_ID())).floatValue();
    }

    public void method_52544(float amount) {
        this.method_5841().method_12778(PlayerAccessor.accessor$DATA_PLAYER_ABSORPTION_ID(), (Object)Float.valueOf(amount));
    }

    protected float method_6031(float p_110146_1_, float p_110146_2_) {
        float retValue = super.method_6031(p_110146_1_, p_110146_2_);
        this.method_36456(this.method_5791());
        return retValue;
    }

    protected class_2568 method_5769() {
        return new class_2568(class_2568.class_5247.field_24344, (Object)new class_2568.class_5248(class_1299.field_6097, this.method_5667(), this.method_5477()));
    }

    private void setProfileName(@Nullable class_2561 newName) {
        Optional<String> optName = Optional.ofNullable(newName).map(class_2561::getString);
        this.fakeProfile = new class_9296(optName, this.fakeProfile.comp_2411(), this.fakeProfile.comp_2412());
    }

    public boolean getOrLoadSkin(UUID minecraftAccount) {
        GameProfile gameProfile = SpongeCommon.server().method_3793().method_14512(minecraftAccount).orElse(null);
        if (gameProfile == null) {
            ProfileResult result = SpongeCommon.server().method_3844().fetchProfile(minecraftAccount, true);
            if (result == null) {
                return false;
            }
            gameProfile = result.profile();
            SpongeCommon.server().method_3793().method_14508(gameProfile);
        }
        this.fakeProfile.comp_2412().replaceValues((Object)"textures", (Iterable)gameProfile.getProperties().get((Object)"textures"));
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
        return true;
    }

    public boolean getOrLoadSkin(String minecraftAccount) {
        Objects.requireNonNull(minecraftAccount);
        GameProfile gameProfile = SpongeCommon.server().method_3793().method_14515(minecraftAccount).orElse(null);
        if (gameProfile == null) {
            return false;
        }
        if (gameProfile.getProperties().isEmpty()) {
            ProfileResult result = SpongeCommon.server().method_3844().fetchProfile(gameProfile.getId(), true);
            if (result == null) {
                return false;
            }
            gameProfile = result.profile();
            SpongeCommon.server().method_3793().method_14508(gameProfile);
        }
        this.fakeProfile.comp_2412().clear();
        this.fakeProfile.comp_2412().putAll((Multimap)gameProfile.getProperties());
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
        return true;
    }

    public void removeFromTabListDelayed(@Nullable class_3222 player, class_7828 removePacket) {
        int delay = ((WorldConfig)SpongeGameConfigs.getForWorld((class_1937)this.method_37908()).get()).entity.human.tabListRemoveDelay;
        Runnable removeTask = () -> this.pushPackets(player, new class_2596[]{removePacket});
        if (delay == 0) {
            removeTask.run();
        } else {
            Sponge.server().scheduler().submit(Task.builder().execute(removeTask).delay((Ticks)new SpongeTicks(delay)).plugin(((Launch)Launch.instance()).commonPlugin()).build());
        }
    }

    public SpongeProfileProperty getSkinProperty() {
        Collection properties = this.fakeProfile.comp_2412().get((Object)"textures");
        if (properties.isEmpty()) {
            return null;
        }
        return new SpongeProfileProperty((Property)properties.iterator().next());
    }

    public void setSkinProperty(ProfileProperty property) {
        this.fakeProfile.comp_2412().replaceValues((Object)"textures", Collections.singletonList(((SpongeProfileProperty)property).asProperty()));
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
    }

    private boolean isAliveAndInWorld() {
        return this.method_37908().method_8469(this.method_5628()) == this && !this.method_31481();
    }

    private void respawnOnClient() {
        this.pushPackets(new class_2596[]{new class_2716(new int[]{this.method_5628()}), this.createPlayerListPacket(EnumSet.allOf(class_2703.class_5893.class))});
        this.pushPackets(this.method_18002(new class_3231((class_3218)this.method_37908(), (class_1297)this, 1, true, packet -> {})));
    }

    public boolean canRemoveFromListImmediately() {
        return !this.fakeProfile.comp_2412().containsKey((Object)"textures");
    }

    public void untrackFrom(class_3222 player) {
        this.playerPacketMap.remove(player.method_5667());
        player.field_13987.method_14364((class_2596)new class_7828(List.of(this.field_6021)));
    }

    public class_2703 createPlayerListPacket(EnumSet<class_2703.class_5893> actions) {
        class_2703 packet = new class_2703(actions, List.of());
        ((ClientboundPlayerInfoUpdatePacketAccessor)packet).accessor$entries(List.of(new class_2703.class_2705(this.field_6021, this.fakeProfile.comp_2413(), false, 0, class_1934.field_28045, this.method_5476(), 0, null)));
        return packet;
    }

    public void pushPackets(class_2596<?> ... packets) {
        this.pushPackets((class_3222)null, packets);
    }

    public void pushPackets(@Nullable class_3222 player, class_2596<?> ... packets) {
        List queue = player == null ? this.playerPacketMap.computeIfAbsent(null, k -> new ArrayList()) : this.playerPacketMap.computeIfAbsent(player.method_5667(), k -> new ArrayList());
        queue.add(Stream.of(packets));
    }

    public Stream<class_2596<?>> popQueuedPackets(@Nullable class_3222 player) {
        List<Stream<class_2596<?>>> queue = this.playerPacketMap.get(player == null ? null : player.method_5667());
        return queue == null || queue.isEmpty() ? Stream.empty() : queue.remove(0);
    }

    public void method_7105(class_1309 target, float distanceFactor) {
        class_1799 itemstack = this.method_5998(class_1268.field_5810);
        class_1799 weaponStack = this.method_59958();
        class_1667 arrow = new class_1667(this.method_37908(), (class_1309)this, itemstack.method_7909() instanceof class_1744 ? itemstack : new class_1799((class_1935)class_1802.field_8107), weaponStack);
        double d0 = target.method_23317() - this.method_23317();
        double d1 = target.method_5829().field_1322 + (double)(target.method_17682() / 3.0f) - arrow.method_23318();
        double d2 = target.method_23321() - this.method_23321();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        arrow.method_7485(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.method_37908().method_8407().method_5461() * 4));
        this.method_5783(class_3417.field_14600, 1.0f, 1.0f / (this.field_5974.method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)arrow);
    }

    public class_2596<class_2602> method_18002(class_3231 $$0) {
        class_2604 packet = new class_2604((class_1297)this, $$0);
        ((ClientboundAddEntityPacketAccessor)packet).accessor$type(class_1299.field_6097);
        return packet;
    }
}

