/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1730;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3551;
import net.minecraft.class_4284;
import net.minecraft.class_5218;
import net.minecraft.class_7225;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.effect.VanishState;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.entity.UserInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.RespawnLocation;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.bridge.authlib.GameProfileHolderBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.bridge.data.TransientBridge;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.permissions.SubjectBridge;
import org.spongepowered.common.bridge.world.entity.player.BedLocationHolderBridge;
import org.spongepowered.common.data.DataUtil;
import org.spongepowered.common.data.holder.SpongeMutableDataHolder;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;
import org.spongepowered.common.entity.player.SpongeUserInventory;
import org.spongepowered.common.entity.player.SpongeUserInventoryEnderchest;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.service.server.permission.BridgeSubject;
import org.spongepowered.common.service.server.permission.SubjectHelper;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.FileUtil;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.math.vector.Vector3d;

public final class SpongeUserData
implements Identifiable,
DataSerializable,
BedLocationHolderBridge,
SpongeMutableDataHolder,
DataCompoundHolder,
VanishableBridge,
GameProfileHolderBridge,
User,
BridgeSubject,
TransientBridge {
    private final Map<ResourceKey, RespawnLocation> spawnLocations = Maps.newHashMap();
    private ResourceKey worldKey = (ResourceKey)class_1937.field_25179.method_29177();
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private boolean invulnerable;
    private boolean isVanished;
    private boolean isInvisible;
    private VanishState vanishState;
    private boolean vanishIgnoresCollision;
    private boolean vanishPreventsTargeting;
    private final GameProfile profile;
    private boolean isTransient;
    private @Nullable SpongeUserInventory inventory;
    private @Nullable class_1730 enderChest;
    private class_2487 compound;
    private boolean isConstructing;

    public static SpongeUserData create(GameProfile profile) throws IOException {
        class_3218 world = SpongeCommon.server().method_30002();
        if (world == null) {
            SpongeCommon.logger().warn("Overworld not initialized, cannot create users!");
            throw new IllegalStateException("Overworld not initialized, cannot create users!");
        }
        class_32.class_5143 storageSource = ((MinecraftServerAccessor)Sponge.server()).accessor$storageSource();
        Path p = storageSource.method_27010(class_5218.field_24182).resolve(profile.getId().toString() + ".dat");
        if (!Files.exists(p, new LinkOption[0])) {
            return new SpongeUserData(profile, new class_2487());
        }
        try {
            class_2487 compound;
            try (InputStream in = Files.newInputStream(p, new OpenOption[0]);){
                compound = class_2507.method_10629((InputStream)in, (class_2505)class_2505.method_53898());
            }
            int version = compound.method_10573("DataVersion", 3) ? compound.method_10550("DataVersion") : -1;
            class_4284.field_19213.method_48130(class_3551.method_15450(), compound, version);
            return new SpongeUserData(profile, compound);
        }
        catch (IOException e) {
            SpongeCommon.logger().warn("Unable to load corrupt user file '{}'!", (Object)p.relativize(Paths.get("", new String[0])).toString(), (Object)e);
            FileUtil.copyCorruptedFile(p);
            throw e;
        }
    }

    private SpongeUserData(GameProfile profile, class_2487 tag) {
        this.profile = profile;
        this.compound = tag;
        this.readCompound(this.compound);
        SubjectHelper.applySubject((SubjectBridge)((Object)this), "user");
    }

    public User asUser() {
        return ((SpongeServer)SpongeCommon.server()).userManager().asUser(this);
    }

    private void reset() {
        this.spawnLocations.clear();
    }

    @Override
    public List<DataHolder> impl$delegateDataHolder() {
        return Collections.singletonList(this.getDataHolder(true));
    }

    public DataHolder.Mutable getDataHolder(boolean markDirty) {
        if (this.isOnline()) {
            return (DataHolder.Mutable)this.player().get();
        }
        if (markDirty) {
            this.markDirty();
        }
        return this;
    }

    private UserInventory loadInventory() {
        if (this.inventory == null) {
            this.inventory = new SpongeUserInventory(this);
            class_2499 listNBT = this.compound.method_10554("Inventory", 10);
            this.inventory.readList(listNBT);
            this.inventory.currentItem = this.compound.method_10550("SelectedItemSlot");
        }
        return (UserInventory)this.inventory;
    }

    private SpongeUserData loadEnderInventory() {
        if (this.enderChest == null) {
            this.enderChest = new SpongeUserInventoryEnderchest(this);
            if (this.compound.method_10573("EnderItems", 9)) {
                class_2499 nbttaglist1 = this.compound.method_10554("EnderItems", 10);
                this.enderChest.method_7659(nbttaglist1, (class_7225.class_7874)SpongeCommon.server().method_30611());
            }
        }
        return this;
    }

    public void readCompound(class_2487 compound) {
        this.reset();
        this.compound = compound;
        if (!compound.method_10545("WorldKey")) {
            this.worldKey = ResourceKey.resolve((String)compound.method_10558("WorldKey"));
        }
        class_2499 position = compound.method_10554("Pos", 6);
        class_2499 rotation = compound.method_10554("Rotation", 5);
        this.x = position.method_10611(0);
        this.y = position.method_10611(1);
        this.z = position.method_10611(2);
        this.yaw = rotation.method_10604(0);
        this.pitch = rotation.method_10604(1);
        this.isConstructing = true;
        DataUtil.syncTagToData(this);
        this.isConstructing = false;
    }

    public void writeCompound(class_2487 compound) {
        compound.method_10582("WorldKey", this.worldKey.formatted());
        this.loadInventory();
        this.loadEnderInventory();
        compound.method_10566("Inventory", (class_2520)this.inventory.writeList(new class_2499()));
        compound.method_10566("EnderItems", (class_2520)this.enderChest.method_7660((class_7225.class_7874)SpongeCommon.server().method_30611()));
        compound.method_10569("SelectedItemSlot", this.inventory.currentItem);
        compound.method_10566("Pos", (class_2520)Constants.NBT.newDoubleNBTList(this.x, this.y, this.z));
        compound.method_10566("Rotation", (class_2520)Constants.NBT.newFloatNBTList(this.yaw, this.pitch));
        if (DataUtil.syncDataToTag(this)) {
            compound.method_10543(this.data$getCompound());
        }
    }

    public UUID uniqueId() {
        return this.profile.getId();
    }

    public String name() {
        return this.profile.getName();
    }

    public int contentVersion() {
        return 1;
    }

    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.contentVersion()).set(Constants.Entity.Player.UUID, (Object)this.profile.getId()).set(Constants.Entity.Player.NAME, (Object)this.profile.getName()).set(Constants.Entity.Player.SPAWNS, this.spawnLocations);
    }

    public boolean canEquip(EquipmentType type) {
        return true;
    }

    public boolean canEquip(EquipmentType type, @Nullable ItemStackLike equipment) {
        return true;
    }

    public Optional<ItemStack> equipped(EquipmentType type) {
        throw new MissingImplementationException("SpongeUser", "equipped");
    }

    public boolean equip(EquipmentType type, @Nullable ItemStackLike equipment) {
        if (this.canEquip(type, equipment)) {
            this.loadInventory();
            this.setEquippedItem(type, equipment);
            return true;
        }
        return false;
    }

    public UserInventory inventory() {
        return this.loadInventory();
    }

    public EquipmentInventory equipment() {
        return this.inventory().equipment();
    }

    public ItemStack itemInHand(HandType handType) {
        if (handType == HandTypes.MAIN_HAND.get()) {
            this.equipped((EquipmentType)EquipmentTypes.MAINHAND.get()).orElseThrow(IllegalStateException::new);
        } else if (handType == HandTypes.OFF_HAND.get()) {
            this.equipped((EquipmentType)EquipmentTypes.OFFHAND.get()).orElseThrow(IllegalStateException::new);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf(handType));
    }

    public ItemStack head() {
        return this.equipped((EquipmentType)EquipmentTypes.HEAD.get()).orElseThrow(IllegalStateException::new);
    }

    public void setHead(ItemStackLike helmet) {
        this.equip((EquipmentType)EquipmentTypes.HEAD.get(), helmet);
    }

    public ItemStack chest() {
        return this.equipped((EquipmentType)EquipmentTypes.CHEST.get()).orElseThrow(IllegalStateException::new);
    }

    public void setChest(ItemStackLike chestplate) {
        this.equip((EquipmentType)EquipmentTypes.CHEST.get(), chestplate);
    }

    public ItemStack legs() {
        return this.equipped((EquipmentType)EquipmentTypes.LEGS.get()).orElseThrow(IllegalStateException::new);
    }

    public void setLegs(ItemStackLike leggings) {
        this.equip((EquipmentType)EquipmentTypes.LEGS.get(), leggings);
    }

    public ItemStack feet() {
        return this.equipped((EquipmentType)EquipmentTypes.FEET.get()).orElseThrow(IllegalStateException::new);
    }

    public void setFeet(ItemStackLike boots) {
        this.equip((EquipmentType)EquipmentTypes.FEET.get(), boots);
    }

    public void setItemInHand(HandType handType, @Nullable ItemStackLike itemInHand) {
        if (handType == HandTypes.MAIN_HAND.get()) {
            this.setEquippedItem((Supplier<? extends EquipmentType>)EquipmentTypes.MAINHAND, itemInHand);
        } else if (handType == HandTypes.OFF_HAND.get()) {
            this.setEquippedItem((Supplier<? extends EquipmentType>)EquipmentTypes.OFFHAND, itemInHand);
        } else {
            throw new IllegalArgumentException("Invalid hand " + String.valueOf(handType));
        }
    }

    @Override
    public Map<ResourceKey, RespawnLocation> bridge$getBedlocations() {
        Optional<ServerPlayer> player = this.player();
        return player.map(value -> ((BedLocationHolderBridge)value).bridge$getBedlocations()).orElse(this.spawnLocations);
    }

    @Override
    public boolean bridge$setBedLocations(Map<ResourceKey, RespawnLocation> value) {
        Optional<ServerPlayer> player = this.player();
        if (player.isPresent()) {
            return ((BedLocationHolderBridge)player.get()).bridge$setBedLocations(value);
        }
        this.spawnLocations.clear();
        this.spawnLocations.putAll(value);
        if (value.isEmpty()) {
            ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.RESPAWN_LOCATIONS);
        } else {
            ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.RESPAWN_LOCATIONS, value);
        }
        this.markDirty();
        return true;
    }

    @Override
    public ImmutableMap<ResourceKey, RespawnLocation> bridge$removeAllBeds() {
        Optional<ServerPlayer> player = this.player();
        if (player.isPresent()) {
            return ((BedLocationHolderBridge)player.get()).bridge$removeAllBeds();
        }
        ImmutableMap locations = ImmutableMap.copyOf(this.spawnLocations);
        this.spawnLocations.clear();
        ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.RESPAWN_LOCATIONS);
        this.markDirty();
        return locations;
    }

    public void markDirty() {
        if (this.isConstructing) {
            return;
        }
        ((SpongeServer)SpongeCommon.server()).userManager().markDirty(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        SpongeUserData spongeUserData = this;
        synchronized (spongeUserData) {
            SpongeUserManager userManager = ((SpongeServer)SpongeCommon.server()).userManager();
            class_32.class_5143 storageSource = ((MinecraftServerAccessor)Sponge.server()).accessor$storageSource();
            Path p = storageSource.method_27010(class_5218.field_24182).resolve(String.valueOf(this.uniqueId()) + ".dat");
            this.writeCompound(this.compound);
            try (OutputStream out = Files.newOutputStream(p, new OpenOption[0]);){
                class_2507.method_10634((class_2487)this.compound, (OutputStream)out);
                userManager.unmarkDirty(this);
            }
            catch (IOException e) {
                SpongeCommon.logger().warn("Failed to save user file [{}]!", (Object)p, (Object)e);
                throw e;
            }
        }
    }

    private void setEquippedItem(Supplier<? extends EquipmentType> type, @Nullable ItemStackLike item) {
        this.setEquippedItem(type.get(), item);
    }

    private void setEquippedItem(EquipmentType type, @Nullable ItemStackLike item) {
        throw new MissingImplementationException("SpongeUser", "setEquippedItem");
    }

    public org.spongepowered.api.profile.GameProfile profile() {
        return SpongeGameProfile.of(this.profile);
    }

    public boolean isOnline() {
        return this.player().isPresent();
    }

    public Optional<ServerPlayer> player() {
        return Optional.ofNullable((ServerPlayer)SpongeCommon.server().method_3760().method_14602(this.profile.getId()));
    }

    public Vector3d position() {
        return this.player().map(Entity::position).orElseGet(() -> new Vector3d(this.x, this.y, this.z));
    }

    public ResourceKey worldKey() {
        Optional<ServerPlayer> player = this.player();
        return player.map(serverPlayer -> serverPlayer.world().key()).orElseGet(() -> this.worldKey);
    }

    public boolean setLocation(ResourceKey key, Vector3d position) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(position);
        Optional<ServerPlayer> player = this.player();
        if (player.isPresent()) {
            Optional world = Sponge.server().worldManager().world(key);
            return world.filter(serverWorld -> ((ServerPlayer)player.get()).setLocation(ServerLocation.of((ServerWorld)serverWorld, (Vector3d)position))).isPresent();
        }
        this.worldKey = key;
        this.x = position.x();
        this.y = position.y();
        this.z = position.z();
        this.markDirty();
        return true;
    }

    public Vector3d rotation() {
        return this.player().map(Entity::rotation).orElseGet(() -> new Vector3d(this.pitch, this.yaw, 0.0f));
    }

    public void setRotation(Vector3d rotation) {
        Objects.requireNonNull(rotation, "Rotation was null!");
        Optional<ServerPlayer> playerOpt = this.player();
        if (playerOpt.isPresent()) {
            playerOpt.get().setRotation(rotation);
            return;
        }
        this.markDirty();
        this.pitch = (float)rotation.x() % 360.0f;
        this.yaw = (float)rotation.y() % 360.0f;
    }

    public Inventory enderChestInventory() {
        Optional<ServerPlayer> playerOpt = this.player();
        if (playerOpt.isPresent()) {
            return playerOpt.get().enderChestInventory();
        }
        this.loadEnderInventory();
        return (Inventory)this.enderChest;
    }

    @Override
    public VanishState bridge$vanishState() {
        return this.vanishState;
    }

    @Override
    public void bridge$vanishState(VanishState state) {
        Optional<ServerPlayer> playerOpt = this.player();
        if (playerOpt.isPresent()) {
            ((VanishableBridge)playerOpt.get()).bridge$vanishState(state);
            return;
        }
        this.vanishState = state;
        this.markDirty();
        ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.VANISH_STATE, state);
    }

    @Override
    public boolean bridge$isInvisible() {
        return this.player().map(player -> ((VanishableBridge)player).bridge$isInvisible()).orElseGet(() -> this.isInvisible);
    }

    @Override
    public void bridge$setInvisible(boolean invisible) {
        Optional<ServerPlayer> player = this.player();
        if (player.isPresent()) {
            ((VanishableBridge)player.get()).bridge$setInvisible(invisible);
            return;
        }
        this.isInvisible = invisible;
        if (invisible) {
            ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.IS_INVISIBLE, true);
        } else {
            ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.IS_INVISIBLE);
        }
    }

    @Override
    public class_2487 data$getCompound() {
        return this.compound;
    }

    @Override
    public void data$setCompound(class_2487 nbt) {
        this.compound = nbt;
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.PLAYER;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpongeUserData other = (SpongeUserData)obj;
        return this.profile.getId().equals(other.profile.getId());
    }

    public int hashCode() {
        return this.profile.getId().hashCode();
    }

    public String toString() {
        return new StringJoiner(", ", SpongeUserData.class.getSimpleName() + "[", "]").add("isOnline=" + this.isOnline()).add("profile=" + String.valueOf(this.profile())).toString();
    }

    @Override
    public GameProfile bridge$getGameProfile() {
        return this.profile;
    }

    public Boolean isInvulnerable() {
        return this.player().map(player -> ((class_1297)player).method_5655()).orElse(this.invulnerable);
    }

    public void setInvulnerable(boolean invulnerable) {
        Optional<ServerPlayer> playerOpt = this.player();
        if (playerOpt.isPresent()) {
            ((class_1297)playerOpt.get()).method_5684(invulnerable);
            return;
        }
        this.invulnerable = invulnerable;
        this.markDirty();
    }

    public String identifier() {
        return this.uniqueId().toString();
    }

    @Override
    public boolean bridge$isTransient() {
        return this.isTransient;
    }

    @Override
    public void bridge$setTransient(boolean value) {
        this.isTransient = value;
    }
}

