/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.value.CollectionValue;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.inventory.ArmorEquipable;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Equipable;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.equipment.EquipmentInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.util.Nameable;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.bridge.permissions.SubjectBridge;
import org.spongepowered.common.entity.player.SpongeUserData;
import org.spongepowered.common.service.server.permission.BridgeSubject;
import org.spongepowered.common.service.server.permission.SubjectHelper;
import org.spongepowered.math.vector.Vector3d;

public abstract class SpongeUserView
implements User,
BridgeSubject {
    protected final UUID uuid;

    public static User create(UUID uuid) {
        return new Standard(uuid);
    }

    public static User createLoginEventUser(ServerPlayer serverPlayer) {
        return new Login(serverPlayer);
    }

    protected SpongeUserView(UUID uuid) {
        this.uuid = uuid;
        SubjectHelper.applySubject((SubjectBridge)((Object)this), "user");
    }

    public <E> DataTransactionResult offer(Key<? extends Value<E>> key, E value) {
        return this.dataHolderBackingObject().offer(key, value);
    }

    public DataTransactionResult offer(Value<?> value) {
        return this.dataHolderBackingObject().offer(value);
    }

    public <E> DataTransactionResult offerSingle(Key<? extends CollectionValue<E, ?>> key, E element) {
        return this.dataHolderBackingObject().offerSingle(key, element);
    }

    public <K, V> DataTransactionResult offerSingle(Key<? extends MapValue<K, V>> key, K valueKey, V value) {
        return this.dataHolderBackingObject().offerSingle(key, valueKey, value);
    }

    public <K, V> DataTransactionResult offerAll(Key<? extends MapValue<K, V>> key, Map<? extends K, ? extends V> map) {
        return this.dataHolderBackingObject().offerAll(key, map);
    }

    public DataTransactionResult offerAll(MapValue<?, ?> value) {
        return this.dataHolderBackingObject().offerAll(value);
    }

    public DataTransactionResult offerAll(CollectionValue<?, ?> value) {
        return this.dataHolderBackingObject().offerAll(value);
    }

    public <E> DataTransactionResult offerAll(Key<? extends CollectionValue<E, ?>> key, Collection<? extends E> elements) {
        return this.dataHolderBackingObject().offerAll(key, elements);
    }

    public <E> DataTransactionResult removeSingle(Key<? extends CollectionValue<E, ?>> key, E element) {
        return this.dataHolderBackingObject().removeSingle(key, element);
    }

    public <K> DataTransactionResult removeKey(Key<? extends MapValue<K, ?>> key, K mapKey) {
        return this.dataHolderBackingObject().removeKey(key, mapKey);
    }

    public DataTransactionResult removeAll(CollectionValue<?, ?> value) {
        return this.dataHolderBackingObject().removeAll(value);
    }

    public <E> DataTransactionResult removeAll(Key<? extends CollectionValue<E, ?>> key, Collection<? extends E> elements) {
        return this.dataHolderBackingObject().removeAll(key, elements);
    }

    public DataTransactionResult removeAll(MapValue<?, ?> value) {
        return this.dataHolderBackingObject().removeAll(value);
    }

    public <K, V> DataTransactionResult removeAll(Key<? extends MapValue<K, V>> key, Map<? extends K, ? extends V> map) {
        return this.dataHolderBackingObject().removeAll(key, map);
    }

    public <E> DataTransactionResult tryOffer(Key<? extends Value<E>> key, E value) {
        return this.dataHolderBackingObject().tryOffer(key, value);
    }

    public DataTransactionResult remove(Key<?> key) {
        return this.dataHolderBackingObject().remove(key);
    }

    public DataTransactionResult undo(DataTransactionResult result) {
        return this.dataHolderBackingObject().undo(result);
    }

    public DataTransactionResult copyFrom(ValueContainer that, MergeFunction function) {
        return this.dataHolderBackingObject().copyFrom(that, function);
    }

    public <E> Optional<E> get(Key<? extends Value<E>> key) {
        return this.dataHolderBackingObject().get(key);
    }

    public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        return this.dataHolderBackingObject().getValue(key);
    }

    public boolean supports(Key<?> key) {
        return this.dataHolderBackingObject().supports(key);
    }

    public Set<Key<?>> getKeys() {
        return this.dataHolderBackingObject().getKeys();
    }

    public Set<Value.Immutable<?>> getValues() {
        return this.dataHolderBackingObject().getValues();
    }

    public GameProfile profile() {
        return this.backingObject(Player::profile, SpongeUserData::profile);
    }

    public String name() {
        return this.backingObject(Nameable::name, SpongeUserData::name);
    }

    public boolean isOnline() {
        return this.player().isPresent();
    }

    public Optional<ServerPlayer> player() {
        return Sponge.server().player(this.uuid);
    }

    public Vector3d position() {
        return this.backingObject(Entity::position, SpongeUserData::position);
    }

    public ResourceKey worldKey() {
        return this.backingObject(player -> player.world().key(), SpongeUserData::worldKey);
    }

    public boolean setLocation(ResourceKey world, Vector3d position) {
        return this.backingObject(player -> player.setLocation(ServerLocation.of((ResourceKey)world, (Vector3d)position)), user -> user.setLocation(world, position));
    }

    public void setRotation(Vector3d rotation) {
        this.backingObjectConsumer(player -> player.setRotation(rotation), user -> user.setRotation(rotation));
    }

    public Vector3d rotation() {
        return this.backingObject(Entity::rotation, SpongeUserData::rotation);
    }

    public CarriedInventory<? extends Carrier> inventory() {
        return this.backingObject(Player::inventory, SpongeUserData::inventory);
    }

    public Inventory enderChestInventory() {
        return this.backingObject(Player::enderChestInventory, SpongeUserData::enderChestInventory);
    }

    public ItemStack head() {
        return this.backingObject(ArmorEquipable::head, SpongeUserData::head);
    }

    public void setHead(ItemStackLike head) {
        this.backingObjectConsumer(player -> player.setHead(head), user -> user.setHead(head));
    }

    public ItemStack chest() {
        return this.backingObject(ArmorEquipable::chest, SpongeUserData::chest);
    }

    public void setChest(ItemStackLike chest) {
        this.backingObjectConsumer(player -> player.setChest(chest), user -> user.setChest(chest));
    }

    public ItemStack legs() {
        return this.backingObject(ArmorEquipable::legs, SpongeUserData::legs);
    }

    public void setLegs(ItemStackLike legs) {
        this.backingObjectConsumer(player -> player.setLegs(legs), user -> user.setLegs(legs));
    }

    public ItemStack feet() {
        return this.backingObject(ArmorEquipable::feet, SpongeUserData::feet);
    }

    public void setFeet(ItemStackLike feet) {
        this.backingObjectConsumer(player -> player.setFeet(feet), user -> user.setFeet(feet));
    }

    public ItemStack itemInHand(HandType handType) {
        return this.backingObject(player -> player.itemInHand(handType), user -> user.itemInHand(handType));
    }

    public void setItemInHand(HandType handType, ItemStackLike itemInHand) {
        this.backingObjectConsumer(player -> player.setItemInHand(handType, itemInHand), user -> user.setItemInHand(handType, itemInHand));
    }

    public EquipmentInventory equipment() {
        return this.backingObject(Equipable::equipment, SpongeUserData::equipment);
    }

    public boolean canEquip(EquipmentType type) {
        return this.backingObject(player -> player.canEquip(type), user -> user.canEquip(type));
    }

    public boolean canEquip(EquipmentType type, ItemStackLike equipment) {
        return this.backingObject(player -> player.canEquip(type, equipment), user -> user.canEquip(type, equipment));
    }

    public Optional<ItemStack> equipped(EquipmentType type) {
        return this.backingObject(player -> player.equipped(type), user -> user.equipped(type));
    }

    public boolean equip(EquipmentType type, ItemStackLike equipment) {
        return this.backingObject(player -> player.equip(type, equipment), user -> user.equip(type, equipment));
    }

    public String identifier() {
        return this.uuid.toString();
    }

    public UUID uniqueId() {
        return this.uuid;
    }

    private void backingObjectConsumer(FunctionConsumer<? super ServerPlayer> playerFunc, FunctionConsumer<? super SpongeUserData> userFunc) {
        this.backingObject(playerFunc, userFunc);
    }

    protected abstract DataHolder.Mutable dataHolderBackingObject();

    private <T> T backingObject(Function<? super ServerPlayer, T> playerFunc, Function<? super SpongeUserData, T> userFunc) {
        DataHolder.Mutable mutable = this.dataHolderBackingObject();
        if (mutable instanceof ServerPlayer) {
            return playerFunc.apply((ServerPlayer)((ServerPlayer)mutable));
        }
        return userFunc.apply((SpongeUserData)mutable);
    }

    static final class Standard
    extends SpongeUserView {
        Standard(UUID uuid) {
            super(uuid);
        }

        @Override
        protected DataHolder.Mutable dataHolderBackingObject() {
            @Nullable ServerPlayer serverPlayer = (ServerPlayer)SpongeCommon.server().method_3760().method_14602(this.uuid);
            if (serverPlayer != null) {
                return serverPlayer;
            }
            SpongeUserData user = ((SpongeServer)SpongeCommon.server()).userManager().userFromCache(this.uuid);
            if (user != null) {
                return user;
            }
            throw new IllegalStateException("Player is not online and user is not loaded - it must be loaded from the UserManager.");
        }
    }

    static final class Login
    extends SpongeUserView {
        private final WeakReference<ServerPlayer> player;

        Login(ServerPlayer serverPlayer) {
            super(serverPlayer.uniqueId());
            this.player = new WeakReference<ServerPlayer>(serverPlayer);
        }

        @Override
        protected DataHolder.Mutable dataHolderBackingObject() {
            @Nullable ServerPlayer player = (ServerPlayer)this.player.get();
            if (player == null) {
                throw new IllegalStateException("The Player is no longer available, do not store this object!");
            }
            return player;
        }
    }

    @FunctionalInterface
    static interface FunctionConsumer<T>
    extends Function<T, Void>,
    Consumer<T> {
        @Override
        default public Void apply(T t) {
            this.accept(t);
            return null;
        }
    }
}

