/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player.tab;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_2772;
import net.minecraft.class_3244;
import net.minecraft.class_7822;
import net.minecraft.class_7828;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.common.accessor.network.protocol.game.ClientboundPlayerInfoUpdatePacketAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.entity.player.tab.SpongeTabListEntry;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.util.Preconditions;

public final class SpongeTabList
implements TabList {
    private static final class_2561 EMPTY_COMPONENT = class_2561.method_43470((String)"");
    private final class_3244 connection;
    private @Nullable Component header;
    private @Nullable Component footer;
    private final Map<UUID, TabListEntry> entries = Maps.newHashMap();

    public SpongeTabList(class_3244 connection) {
        this.connection = connection;
    }

    public ServerPlayer player() {
        return (ServerPlayer)this.connection.field_14140;
    }

    public Optional<Component> header() {
        return Optional.ofNullable(this.header);
    }

    public TabList setHeader(@Nullable Component header) {
        this.header = header;
        this.refreshClientHeaderFooter();
        return this;
    }

    public Optional<Component> footer() {
        return Optional.ofNullable(this.footer);
    }

    public TabList setFooter(@Nullable Component footer) {
        this.footer = footer;
        this.refreshClientHeaderFooter();
        return this;
    }

    public TabList setHeaderAndFooter(@Nullable Component header, @Nullable Component footer) {
        this.header = header;
        this.footer = footer;
        this.refreshClientHeaderFooter();
        return this;
    }

    private void refreshClientHeaderFooter() {
        class_2772 packet = new class_2772(this.header == null ? EMPTY_COMPONENT : SpongeAdventure.asVanilla(this.header), this.footer == null ? EMPTY_COMPONENT : SpongeAdventure.asVanilla(this.footer));
        this.connection.method_14364((class_2596)packet);
    }

    public Collection<TabListEntry> entries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    public Optional<TabListEntry> entry(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "unique id");
        return Optional.ofNullable(this.entries.get(uniqueId));
    }

    public TabList addEntry(TabListEntry entry) throws IllegalArgumentException {
        Objects.requireNonNull(entry, "builder");
        Preconditions.checkState(entry.list().equals((Object)this), "the provided tab list entry was not created for this tab list");
        Preconditions.checkArgument(this.entries.putIfAbsent(entry.profile().uniqueId(), entry) == null, "cannot add duplicate entry");
        this.sendUpdate(entry, EnumSet.allOf(class_2703.class_5893.class));
        return this;
    }

    private void addEntry(class_2703.class_2705 entry) {
        this.entries.computeIfAbsent(entry.comp_1106(), $ -> {
            @Nullable class_2561 displayName = entry.comp_1111();
            return new SpongeTabListEntry(this, SpongeGameProfile.of(entry.comp_1107()), displayName == null ? null : SpongeAdventure.asAdventure(displayName), entry.comp_1109(), (GameMode)entry.comp_1110(), entry.comp_1108(), entry.comp_2889(), entry.comp_1112() == null ? null : entry.comp_1112().comp_1088());
        });
    }

    public Optional<TabListEntry> removeEntry(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "unique id");
        TabListEntry entry = this.entries.remove(uniqueId);
        if (entry != null) {
            this.connection.method_14364((class_2596)new class_7828(List.of(entry.profile().uniqueId())));
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    void sendUpdate(TabListEntry entry, EnumSet<class_2703.class_5893> actions) {
        class_2703 packet = new class_2703(actions, List.of());
        class_7822.class_7823 chatSessionData = ((SpongeTabListEntry)entry).profilePublicKey() == null ? null : new class_7822.class_7823(entry.profile().uuid(), ((SpongeTabListEntry)entry).profilePublicKey());
        class_2561 displayName = entry.displayName().isPresent() ? SpongeAdventure.asVanilla((Component)entry.displayName().get()) : null;
        class_2703.class_2705 data = new class_2703.class_2705(entry.profile().uniqueId(), SpongeGameProfile.toMcProfile(entry.profile()), entry.listed(), entry.latency(), (class_1934)entry.gameMode(), displayName, entry.weight(), chatSessionData);
        ((ClientboundPlayerInfoUpdatePacketAccessor)packet).accessor$entries(List.of(data));
        this.connection.method_14364((class_2596)packet);
    }

    public @Nullable class_2703 updateEntriesOnSend(class_2703 packet) {
        @MonotonicNonNull ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
        class_2703.class_2705> filteredEntries = null;
        EnumSet actions = packet.method_46327();
        for (int i = 0; i < packet.method_46329().size(); ++i) {
            TabListEntry entry;
            class_2703.class_2705 update = (class_2703.class_2705)packet.method_46329().get(i);
            if (actions.contains(class_2703.class_5893.field_29136)) {
                this.addEntry(update);
            }
            if ((entry = (TabListEntry)this.entry(update.comp_1106()).orElse(null)) != null) {
                if (filteredEntries != null) {
                    filteredEntries.add(update);
                }
                if (actions.contains(class_2703.class_5893.field_29139)) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setDisplayName(update.comp_1111() == null ? null : SpongeAdventure.asAdventure(update.comp_1111()));
                }
                if (actions.contains(class_2703.class_5893.field_29138)) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setLatency(update.comp_1109());
                }
                if (actions.contains(class_2703.class_5893.field_29137)) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setGameMode((GameMode)update.comp_1110());
                }
                if (!actions.contains(class_2703.class_5893.field_40700)) continue;
                ((SpongeTabListEntry)entry).updateWithoutSend();
                entry.setListed(update.comp_1108());
                continue;
            }
            if (filteredEntries != null) continue;
            if (packet.method_46329().size() == 1) {
                return null;
            }
            filteredEntries = new ArrayList<class_2703.class_2705>(packet.method_46329().subList(0, i));
        }
        if (filteredEntries == null) {
            return packet;
        }
        class_2703 filteredPacket = new class_2703(packet.method_46327(), List.of());
        ((ClientboundPlayerInfoUpdatePacketAccessor)filteredPacket).accessor$entries(filteredEntries);
        return filteredPacket;
    }

    public @Nullable class_7828 updateEntriesOnSend(class_7828 packet) {
        @MonotonicNonNull ArrayList<UUID> filteredProfileIds = null;
        for (int i = 0; i < packet.comp_1105().size(); ++i) {
            UUID uniqueId = (UUID)packet.comp_1105().get(i);
            TabListEntry entry = this.entries.remove(uniqueId);
            if (entry != null) {
                if (filteredProfileIds == null) continue;
                filteredProfileIds.add(uniqueId);
                continue;
            }
            if (filteredProfileIds != null) continue;
            if (packet.comp_1105().size() == 1) {
                return null;
            }
            filteredProfileIds = new ArrayList<UUID>(packet.comp_1105().subList(0, i));
        }
        if (filteredProfileIds == null) {
            return packet;
        }
        return new class_7828(filteredProfileIds);
    }

    public String toString() {
        return new StringJoiner(", ", SpongeTabList.class.getSimpleName() + "[", "]").add("player=" + String.valueOf(this.connection.field_14140)).add("header=" + String.valueOf(this.header)).add("footer=" + String.valueOf(this.footer)).add("entries=" + String.valueOf(this.entries)).toString();
    }
}

