/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player.tab;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2703;
import net.minecraft.class_7428;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.common.entity.player.tab.SpongeTabList;
import org.spongepowered.common.util.Preconditions;

public final class SpongeTabListEntry
implements TabListEntry {
    private final SpongeTabList list;
    private final GameProfile profile;
    private @Nullable Component displayName;
    private int latency;
    private GameMode gameMode;
    private boolean listed;
    private int weight;
    private boolean updateWithoutSend;
    private final class_7428.class_7443 profilePublicKey;

    public SpongeTabListEntry(TabList list, GameProfile profile, @Nullable Component displayName, int latency, GameMode gameMode, boolean listed, int weight, class_7428.class_7443 profilePublicKey) {
        Preconditions.checkState(list instanceof SpongeTabList, "list is not a SpongeTabList");
        this.list = (SpongeTabList)list;
        this.profile = Objects.requireNonNull(profile, "profile");
        this.displayName = displayName;
        this.latency = latency;
        this.gameMode = Objects.requireNonNull(gameMode, "game mode");
        this.listed = listed;
        this.weight = weight;
        this.profilePublicKey = profilePublicKey;
    }

    public TabList list() {
        return this.list;
    }

    public GameProfile profile() {
        return this.profile;
    }

    public Optional<Component> displayName() {
        return Optional.ofNullable(this.displayName);
    }

    public TabListEntry setDisplayName(@Nullable Component displayName) {
        this.displayName = displayName;
        this.sendUpdate(class_2703.class_5893.field_29139);
        return this;
    }

    public int latency() {
        return this.latency;
    }

    public TabListEntry setLatency(int latency) {
        this.latency = latency;
        this.sendUpdate(class_2703.class_5893.field_29138);
        return this;
    }

    public GameMode gameMode() {
        return this.gameMode;
    }

    public TabListEntry setGameMode(GameMode gameMode) {
        this.gameMode = Objects.requireNonNull(gameMode, "game mode");
        this.sendUpdate(class_2703.class_5893.field_29137);
        return this;
    }

    public boolean listed() {
        return this.listed;
    }

    public SpongeTabListEntry setListed(boolean listed) {
        this.listed = listed;
        this.sendUpdate(class_2703.class_5893.field_40700);
        return this;
    }

    public int weight() {
        return this.weight;
    }

    public SpongeTabListEntry setWeight(int weight) {
        this.weight = weight;
        this.sendUpdate(class_2703.class_5893.field_52324);
        return this;
    }

    public class_7428.class_7443 profilePublicKey() {
        return this.profilePublicKey;
    }

    private void sendUpdate(class_2703.class_5893 action) {
        if (this.updateWithoutSend) {
            this.updateWithoutSend = false;
            return;
        }
        this.list.sendUpdate(this, EnumSet.of(action));
    }

    public void updateWithoutSend() {
        this.updateWithoutSend = true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TabListEntry that = (TabListEntry)other;
        return Objects.equals(this.profile.uniqueId(), that.profile().uniqueId());
    }

    public int hashCode() {
        return Objects.hashCode(this.profile);
    }

    public String toString() {
        return new StringJoiner(", ", SpongeTabListEntry.class.getSimpleName() + "[", "]").add("profile=" + String.valueOf(this.profile)).add("latency=" + this.latency).add("displayName=" + String.valueOf(this.displayName)).add("gameMode=" + String.valueOf(this.gameMode)).add("listed=" + this.listed).toString();
    }
}

