/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.projectile;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1501;
import net.minecraft.class_1531;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1670;
import net.minecraft.class_1671;
import net.minecraft.class_1673;
import net.minecraft.class_1674;
import net.minecraft.class_1677;
import net.minecraft.class_1679;
import net.minecraft.class_1680;
import net.minecraft.class_1681;
import net.minecraft.class_1682;
import net.minecraft.class_1683;
import net.minecraft.class_1684;
import net.minecraft.class_1686;
import net.minecraft.class_1687;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2601;
import net.minecraft.class_3532;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.entity.carrier.Dispenser;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.golem.Shulker;
import org.spongepowered.api.entity.projectile.Egg;
import org.spongepowered.api.entity.projectile.EnderPearl;
import org.spongepowered.api.entity.projectile.ExperienceBottle;
import org.spongepowered.api.entity.projectile.FishingBobber;
import org.spongepowered.api.entity.projectile.LlamaSpit;
import org.spongepowered.api.entity.projectile.Potion;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.entity.projectile.Snowball;
import org.spongepowered.api.entity.projectile.arrow.Arrow;
import org.spongepowered.api.entity.projectile.arrow.SpectralArrow;
import org.spongepowered.api.entity.projectile.explosive.FireworkRocket;
import org.spongepowered.api.entity.projectile.explosive.WitherSkull;
import org.spongepowered.api.entity.projectile.explosive.fireball.DragonFireball;
import org.spongepowered.api.entity.projectile.explosive.fireball.ExplosiveFireball;
import org.spongepowered.api.entity.projectile.explosive.fireball.SmallFireball;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.entity.projectile.DispenserSourceLogic;
import org.spongepowered.common.entity.projectile.ProjectileLogic;
import org.spongepowered.common.entity.projectile.ProjectileSourceLogic;
import org.spongepowered.common.entity.projectile.ShulkerSourceLogic;
import org.spongepowered.common.entity.projectile.SimpleDispenserLaunchLogic;
import org.spongepowered.common.entity.projectile.SimpleEntityLaunchLogic;
import org.spongepowered.common.entity.projectile.SimpleItemLaunchLogic;
import org.spongepowered.math.vector.Vector3d;

public final class ProjectileUtil {
    private static final Map<EntityType<? extends Projectile>, ProjectileLogic<?>> projectileLogic = Maps.newHashMap();
    private static final Map<Class<? extends ProjectileSource>, ProjectileSourceLogic<?>> projectileSourceLogic = Maps.newHashMap();

    public static <T extends Projectile> Optional<T> launch(EntityType<T> projectileType, ProjectileSource source, @Nullable Vector3d vel) {
        ProjectileLogic<T> logic = ProjectileUtil.getLogic(projectileType);
        if (logic == null) {
            return Optional.empty();
        }
        Optional<Projectile> projectile = logic.launch(source);
        projectile.ifPresent(t -> {
            if (vel != null) {
                t.offer(Keys.VELOCITY, (Object)vel);
            }
            t.offer(Keys.SHOOTER, (Object)source);
        });
        return projectile;
    }

    public static <T extends Projectile, S extends ProjectileSource> Optional<T> launchWithArgs(EntityType<T> projectileType, Class<S> projectileSourceClass, S source, @Nullable Vector3d vel, Object ... args) {
        ProjectileSourceLogic<S> sourceLogic = ProjectileUtil.getSourceLogic(projectileSourceClass);
        if (sourceLogic == null) {
            return Optional.empty();
        }
        ProjectileLogic<T> logic = ProjectileUtil.getLogic(projectileType);
        if (logic == null) {
            return Optional.empty();
        }
        Optional<Projectile> projectile = sourceLogic.launch(logic, source, projectileType, args);
        projectile.ifPresent(t -> {
            if (vel != null) {
                t.offer(Keys.VELOCITY, (Object)vel);
            }
            t.offer(Keys.SHOOTER, (Object)source);
        });
        return projectile;
    }

    private static void configureThrowable(class_1682 entity) {
        double x = entity.method_23317() - (double)(class_3532.method_15362((float)(entity.method_36454() / 180.0f * (float)Math.PI)) * 0.16f);
        double y = entity.method_23318() - 0.1;
        double z = entity.method_23321() - (double)(class_3532.method_15374((float)(entity.method_36454() / 180.0f * (float)Math.PI)) * 0.16f);
        entity.method_5814(x, y, z);
        float f = 0.4f;
        double motionX = -class_3532.method_15374((float)(entity.method_36454() / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(entity.method_36455() / 180.0f * (float)Math.PI)) * 0.4f;
        double motionZ = class_3532.method_15362((float)(entity.method_36454() / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(entity.method_36455() / 180.0f * (float)Math.PI)) * 0.4f;
        double motionY = -class_3532.method_15374((float)(entity.method_36455() / 180.0f * (float)Math.PI)) * 0.4f;
        entity.method_18800(motionX, motionY, motionZ);
    }

    public static <T extends Projectile> void registerProjectileLogic(Supplier<EntityType<T>> projectileType, ProjectileLogic<T> logic) {
        projectileLogic.put(projectileType.get(), logic);
    }

    public static <T extends ProjectileSource> void registerProjectileSourceLogic(Class<T> projectileSourceClass, ProjectileSourceLogic<T> logic) {
        projectileSourceLogic.put(projectileSourceClass, logic);
    }

    static <T extends ProjectileSource> ProjectileSourceLogic<T> getSourceLogic(Class<T> sourceClass) {
        return projectileSourceLogic.get(sourceClass);
    }

    private static <T extends Projectile> ProjectileLogic<T> getLogic(EntityType<T> projectileType) {
        return projectileLogic.get(projectileType);
    }

    static <P extends Projectile> Optional<P> defaultLaunch(ProjectileSource source, EntityType<P> projectileType, ServerLocation loc) {
        Entity projectile = ((ServerWorld)loc.world()).createEntity(projectileType, loc.position());
        if (projectile instanceof class_1682) {
            ProjectileUtil.configureThrowable((class_1682)projectile);
        }
        return ProjectileUtil.doLaunch(loc.world(), (Projectile)projectile);
    }

    static <P extends Projectile> Optional<P> doLaunch(World extent, P projectile) {
        if (extent.spawnEntity(projectile)) {
            return Optional.of(projectile);
        }
        return Optional.empty();
    }

    static {
        ProjectileUtil.registerProjectileSourceLogic(Dispenser.class, new DispenserSourceLogic());
        ProjectileUtil.registerProjectileSourceLogic(Shulker.class, new ShulkerSourceLogic());
        ProjectileUtil.registerProjectileLogic(EntityTypes.ARROW, new SimpleItemLaunchLogic<Arrow>((Supplier)EntityTypes.ARROW, class_1802.field_8107){

            @Override
            protected Optional<Arrow> createProjectile(class_1309 source, ServerLocation loc) {
                class_1667 arrow = new class_1667(source.method_37908(), source, new class_1799((class_1935)this.item), source.method_59958());
                arrow.method_7485((double)source.method_36455(), (double)source.method_36454(), 0.0, 3.0f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (Arrow)arrow);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SPECTRAL_ARROW, new SimpleItemLaunchLogic<SpectralArrow>((Supplier)EntityTypes.SPECTRAL_ARROW, class_1802.field_8236){

            @Override
            protected Optional<SpectralArrow> createProjectile(class_1309 source, ServerLocation loc) {
                class_1679 arrow = new class_1679(source.method_37908(), source, new class_1799((class_1935)this.item), source.method_59958());
                arrow.method_7485((double)source.method_36455(), (double)source.method_36454(), 0.0, 3.0f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (SpectralArrow)arrow);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.EGG, new SimpleItemLaunchLogic<Egg>((Supplier)EntityTypes.EGG, class_1802.field_8803){

            @Override
            protected Optional<Egg> createProjectile(class_1309 source, ServerLocation loc) {
                class_1681 egg = new class_1681(source.method_37908(), source, new class_1799((class_1935)class_1802.field_8803));
                egg.method_7485((double)source.method_36455(), (double)source.method_36454(), 0.0, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (Egg)egg);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SMALL_FIREBALL, new SimpleItemLaunchLogic<SmallFireball>((Supplier)EntityTypes.SMALL_FIREBALL, class_1802.field_8814){

            @Override
            protected Optional<SmallFireball> createProjectile(class_1309 source, ServerLocation loc) {
                class_243 lookVec = source.method_5828(1.0f);
                class_1677 fireball = new class_1677(source.method_37908(), source, lookVec.method_1021(4.0));
                fireball.method_5814(fireball.method_23317(), fireball.method_23318() + (double)source.method_5751(), fireball.method_23321());
                return ProjectileUtil.doLaunch(loc.world(), (SmallFireball)fireball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.FIREWORK_ROCKET, new SimpleItemLaunchLogic<FireworkRocket>((Supplier)EntityTypes.FIREWORK_ROCKET, class_1802.field_8639){

            @Override
            protected Optional<FireworkRocket> createProjectile(class_1309 source, ServerLocation loc) {
                class_1671 firework = new class_1671(source.method_37908(), loc.x(), loc.y(), loc.z(), class_1799.field_8037);
                return ProjectileUtil.doLaunch(loc.world(), (FireworkRocket)firework);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SNOWBALL, new SimpleItemLaunchLogic<Snowball>((Supplier)EntityTypes.SNOWBALL, class_1802.field_8543){

            @Override
            protected Optional<Snowball> createProjectile(class_1309 source, ServerLocation loc) {
                class_1680 snowball = new class_1680(source.method_37908(), source, new class_1799((class_1935)class_1802.field_8543));
                snowball.method_7485((double)source.method_36455(), (double)source.method_36454(), 0.0, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (Snowball)snowball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.EXPERIENCE_BOTTLE, new SimpleItemLaunchLogic<ExperienceBottle>((Supplier)EntityTypes.EXPERIENCE_BOTTLE, class_1802.field_8287){

            @Override
            protected Optional<ExperienceBottle> createProjectile(class_1309 source, ServerLocation loc) {
                class_1683 expBottle = new class_1683(source.method_37908(), source, new class_1799((class_1935)class_1802.field_8287));
                expBottle.method_7485((double)source.method_36455(), (double)source.method_36454(), -20.0, 0.7f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (ExperienceBottle)expBottle);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.ENDER_PEARL, new SimpleItemLaunchLogic<EnderPearl>((Supplier)EntityTypes.ENDER_PEARL, class_1802.field_8634){

            @Override
            protected Optional<EnderPearl> createProjectile(class_1309 source, ServerLocation loc) {
                class_1684 pearl = new class_1684(source.method_37908(), source, new class_1799((class_1935)class_1802.field_8634));
                pearl.method_7485((double)source.method_36455(), (double)source.method_36454(), 0.0, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (EnderPearl)pearl);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.FIREBALL, new SimpleDispenserLaunchLogic<ExplosiveFireball>((Supplier)EntityTypes.FIREBALL){

            @Override
            protected Optional<ExplosiveFireball> createProjectile(class_1309 source, ServerLocation loc) {
                class_243 lookVec = source.method_5828(1.0f);
                class_1674 fireball = new class_1674(source.method_37908(), source, lookVec.method_1021(4.0), 1);
                fireball.method_5814(fireball.method_23317(), fireball.method_23318() + (double)source.method_5751(), fireball.method_23321());
                return ProjectileUtil.doLaunch(loc.world(), (ExplosiveFireball)fireball);
            }

            @Override
            public Optional<ExplosiveFireball> createProjectile(ProjectileSource source, EntityType<ExplosiveFireball> projectileType, ServerLocation loc) {
                if (!(source instanceof class_2601)) {
                    return super.createProjectile(source, projectileType, loc);
                }
                class_2601 dispenser = (class_2601)source;
                class_2350 enumfacing = DispenserSourceLogic.getFacing(dispenser);
                class_1531 thrower = new class_1531(dispenser.method_10997(), loc.x() + (double)enumfacing.method_10148(), loc.y() + (double)enumfacing.method_10164(), loc.z() + (double)enumfacing.method_10165());
                class_1674 fireball = new class_1674(dispenser.method_10997(), (class_1309)thrower, class_243.field_1353, 1);
                fireball.field_51893 = 0.1;
                return ProjectileUtil.doLaunch(loc.world(), (ExplosiveFireball)fireball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.WITHER_SKULL, new SimpleDispenserLaunchLogic<WitherSkull>((Supplier)EntityTypes.WITHER_SKULL){

            @Override
            protected Optional<WitherSkull> createProjectile(class_1309 source, ServerLocation loc) {
                class_243 lookVec = source.method_5828(1.0f);
                class_1687 skull = new class_1687(source.method_37908(), source, lookVec.method_1021(4.0));
                skull.method_5814(skull.method_23317(), skull.method_23318() + (double)source.method_5751(), skull.method_23321());
                return ProjectileUtil.doLaunch(loc.world(), (WitherSkull)skull);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.EYE_OF_ENDER, new SimpleDispenserLaunchLogic(EntityTypes.EYE_OF_ENDER));
        ProjectileUtil.registerProjectileLogic(EntityTypes.FISHING_BOBBER, new SimpleDispenserLaunchLogic<FishingBobber>((Supplier)EntityTypes.FISHING_BOBBER){

            @Override
            protected Optional<FishingBobber> createProjectile(class_1309 source, ServerLocation loc) {
                if (source instanceof class_1657) {
                    class_1536 hook = new class_1536((class_1657)source, source.method_37908(), 0, 0, new class_1799((class_1935)class_1802.field_8378));
                    hook.method_5814(loc.x(), loc.y(), loc.z());
                    return ProjectileUtil.doLaunch(loc.world(), (FishingBobber)hook);
                }
                return super.createProjectile(source, loc);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.POTION, new SimpleItemLaunchLogic<Potion>((Supplier)EntityTypes.POTION, class_1802.field_8436){

            @Override
            protected Optional<Potion> createProjectile(class_1309 source, ServerLocation loc) {
                class_1686 potion = new class_1686(source.method_37908(), source, new class_1799((class_1935)this.item));
                potion.method_16940(new class_1799((class_1935)class_1802.field_8436, 1));
                potion.method_7485((double)source.method_36455(), (double)source.method_36454(), -20.0, 0.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (Potion)potion);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.LLAMA_SPIT, new SimpleEntityLaunchLogic<LlamaSpit>((Supplier)EntityTypes.LLAMA_SPIT){

            @Override
            public Optional<LlamaSpit> launch(ProjectileSource source) {
                if (!(source instanceof class_1501)) {
                    return Optional.empty();
                }
                return super.launch(source);
            }

            @Override
            public Optional<LlamaSpit> createProjectile(ProjectileSource source, EntityType<LlamaSpit> projectileType, ServerLocation loc) {
                class_1501 llama = (class_1501)source;
                class_1673 llamaSpit = new class_1673(llama.method_37908(), (class_1501)source);
                class_243 lookVec = llama.method_5828(1.0f);
                llamaSpit.method_7485(lookVec.field_1352, lookVec.field_1351, lookVec.field_1350, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (LlamaSpit)llamaSpit);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.DRAGON_FIREBALL, new SimpleDispenserLaunchLogic<DragonFireball>((Supplier)EntityTypes.DRAGON_FIREBALL){

            @Override
            protected Optional<DragonFireball> createProjectile(class_1309 source, ServerLocation loc) {
                class_243 lookVec = source.method_5828(1.0f);
                class_1670 fireball = new class_1670(source.method_37908(), source, lookVec.method_1021(4.0));
                fireball.method_5814(fireball.method_23317(), fireball.method_23318() + (double)source.method_5751(), fireball.method_23321());
                return ProjectileUtil.doLaunch(loc.world(), (DragonFireball)fireball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SHULKER_BULLET, new SimpleEntityLaunchLogic(EntityTypes.SHULKER_BULLET));
    }
}

