/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2619;
import net.minecraft.class_2674;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2846;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_3978;
import net.minecraft.class_5321;
import net.minecraft.class_9209;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.Jukebox;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.InstrumentType;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.CreateMapEvent;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.CollideBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.RotateEntityEvent;
import org.spongepowered.api.event.entity.ai.SetAITargetEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.event.sound.PlaySoundEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.map.MapInfo;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.DefaultWorldKeys;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.map.MapIdTrackerBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.storage.MapItemSavedDataBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.entity.projectile.UnknownProjectileSource;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.map.SpongeMapStorage;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3d;

public final class SpongeCommonEventFactory {
    private static final double MOVEMENT_GRID_POINTS_PER_BLOCK = 8.0;
    private static final double ROTATION_GRID_POINTS_PER_UNIT = 20.0;

    public static <T extends class_1297> CollideEntityEvent callCollideEntityEvent(@Nullable class_1297 sourceEntity, List<T> entities) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseContext<@NonNull ?> currentContext = phaseTracker.getPhaseContext();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            if (sourceEntity != null && currentContext.getSource() != sourceEntity) {
                frame.pushCause((Object)sourceEntity);
            }
            currentContext.addCreatorAndNotifierToCauseStack(frame);
            List<T> spEntities = entities;
            CollideEntityEvent event = SpongeEventFactory.createCollideEntityEvent((Cause)PhaseTracker.getInstance().currentCause(), spEntities);
            SpongeCommon.post((Event)event);
            CollideEntityEvent collideEntityEvent = event;
            return collideEntityEvent;
        }
    }

    public static boolean handlePistonEvent(TrackedWorldBridge world, class_2338 pos, class_2680 blockstate, int eventId) {
        boolean extending = eventId == 0;
        class_2350 direction = (class_2350)blockstate.method_11654((class_2769)class_2318.field_10927);
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((ServerWorld)world).state((BlockState)blockstate).position(pos.method_10263(), pos.method_10264(), pos.method_10260()).build();
        HashSet<ServerLocation> locations = new HashSet<ServerLocation>();
        locations.add(ServerLocation.of((ServerWorld)((ServerWorld)world), (int)pos.method_10263(), (int)pos.method_10264(), (int)pos.method_10260()));
        class_2674 movedBlocks = new class_2674((class_1937)((class_3218)world), pos, direction, extending);
        movedBlocks.method_11537();
        Stream.concat(movedBlocks.method_11541().stream(), movedBlocks.method_11536().stream()).map(block -> ServerLocation.of((ServerWorld)((ServerWorld)world), (int)block.method_10263(), (int)block.method_10264(), (int)block.method_10260())).collect(Collectors.toCollection(() -> locations));
        if (extending && movedBlocks.method_11536().isEmpty()) {
            List movedPositions = movedBlocks.method_11541();
            class_2338 offsetPos = movedPositions.isEmpty() ? pos.method_10093(direction) : ((class_2338)movedPositions.get(movedPositions.size() - 1)).method_10093(direction);
            locations.add(ServerLocation.of((ServerWorld)((ServerWorld)world), (int)offsetPos.method_10263(), (int)offsetPos.method_10264(), (int)offsetPos.method_10260()));
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            if (extending) {
                frame.addContext(EventContextKeys.PISTON_EXTEND, (Object)((ServerWorld)world));
            } else {
                frame.addContext(EventContextKeys.PISTON_RETRACT, (Object)((ServerWorld)world));
            }
            boolean bl = SpongeCommonEventFactory.callChangeBlockEventPre((ServerLevelBridge)((Object)world), (ImmutableList<ServerLocation>)ImmutableList.copyOf(locations), (Object)locatable).isCancelled();
            return bl;
        }
    }

    public static ChangeBlockEvent.Pre callChangeBlockEventPre(ServerLevelBridge worldIn, class_2338 pos) {
        return SpongeCommonEventFactory.callChangeBlockEventPre(worldIn, (ImmutableList<ServerLocation>)ImmutableList.of((Object)ServerLocation.of((ServerWorld)((ServerWorld)worldIn), (int)pos.method_10263(), (int)pos.method_10264(), (int)pos.method_10260())), null);
    }

    public static ChangeBlockEvent.Pre callChangeBlockEventPre(ServerLevelBridge worldIn, class_2338 pos, Object source) {
        return SpongeCommonEventFactory.callChangeBlockEventPre(worldIn, (ImmutableList<ServerLocation>)ImmutableList.of((Object)ServerLocation.of((ServerWorld)((ServerWorld)worldIn), (int)pos.method_10263(), (int)pos.method_10264(), (int)pos.method_10260())), source);
    }

    private static ChangeBlockEvent.Pre callChangeBlockEventPre(ServerLevelBridge worldIn, ImmutableList<ServerLocation> locations, @Nullable Object source) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            PhaseContext<@NonNull ?> phaseContext = PhaseTracker.getInstance().getPhaseContext();
            if (source == null) {
                source = phaseContext.getSource() == null ? worldIn : phaseContext.getSource();
            }
            class_1657 player = null;
            frame.pushCause(source);
            if (source instanceof Player && ((PlatformEntityBridge)(player = (class_1657)source)).bridge$isFakePlayer()) {
                frame.addContext(EventContextKeys.FAKE_PLAYER, (Object)((Player)player));
            }
            if (phaseContext.getCreator().isPresent()) {
                phaseContext.getCreator().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
            } else if (player instanceof ServerPlayer) {
                frame.addContext(EventContextKeys.CREATOR, (Object)((ServerPlayer)player).uniqueId());
            }
            phaseContext.applyNotifierIfAvailable(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            ChangeBlockEvent.Pre event = SpongeEventFactory.createChangeBlockEventPre((Cause)frame.currentCause(), locations, (ServerWorld)((ServerWorld)worldIn));
            SpongeCommon.post((Event)event);
            ChangeBlockEvent.Pre pre = event;
            return pre;
        }
    }

    public static InteractEntityEvent.Primary callInteractEntityEventPrimary(class_3222 player, class_1799 stack, class_1297 entity, class_1268 hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext((class_1657)player, stack, hand, null, entity, frame);
            InteractEntityEvent.Primary event = SpongeEventFactory.createInteractEntityEventPrimary((Cause)frame.currentCause(), (Entity)((Entity)entity));
            if (entity instanceof Player && !((ServerWorld)player.method_37908()).properties().pvp()) {
                event.setCancelled(true);
            }
            SpongeCommon.post((Event)event);
            InteractEntityEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractEntityEvent.Secondary callInteractEntityEventSecondary(class_3222 player, class_1799 stack, class_1297 entity, class_1268 hand, @Nullable Vector3d hitVec) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext((class_1657)player, stack, hand, null, entity, frame);
            InteractEntityEvent.Secondary.On event = hitVec == null ? SpongeEventFactory.createInteractEntityEventSecondaryOn((Cause)frame.currentCause(), (Entity)((Entity)entity)) : SpongeEventFactory.createInteractEntityEventSecondaryAt((Cause)frame.currentCause(), (Entity)((Entity)entity), (Vector3d)hitVec);
            SpongeCommon.post((Event)event);
            InteractEntityEvent.Secondary.On on = event;
            return on;
        }
    }

    public static InteractItemEvent.Primary callInteractItemEventPrimary(class_1657 player, class_1799 stack, class_1268 hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, stack, hand, null, null, frame);
            InteractItemEvent.Primary event = SpongeEventFactory.createInteractItemEventPrimary((Cause)frame.currentCause(), (ItemStackSnapshot)ItemStackUtil.snapshotOf(stack));
            SpongeCommon.post((Event)event);
            InteractItemEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractItemEvent.Secondary callInteractItemEventSecondary(class_1657 player, class_1799 stack, class_1268 hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, stack, hand, null, null, frame);
            InteractItemEvent.Secondary event = SpongeEventFactory.createInteractItemEventSecondary((Cause)frame.currentCause(), (ItemStackSnapshot)ItemStackUtil.snapshotOf(stack));
            SpongeCommon.post((Event)event);
            InteractItemEvent.Secondary secondary = event;
            return secondary;
        }
    }

    public static InteractBlockEvent.Primary callInteractBlockEventPrimary(class_2846.class_2847 action, class_1657 player, class_1799 heldItem, BlockSnapshot blockSnapshot, class_1268 hand, @Nullable class_2350 side) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, heldItem, hand, blockSnapshot, null, frame);
            Direction direction = side != null ? DirectionFacingProvider.INSTANCE.getKey(side).get() : Direction.NONE;
            InteractBlockEvent.Primary.Start event = switch (action) {
                case class_2846.class_2847.field_12968 -> SpongeEventFactory.createInteractBlockEventPrimaryStart((Cause)frame.currentCause(), (BlockSnapshot)blockSnapshot, (Direction)direction);
                case class_2846.class_2847.field_12971 -> SpongeEventFactory.createInteractBlockEventPrimaryStop((Cause)frame.currentCause(), (BlockSnapshot)blockSnapshot, (Direction)direction);
                case class_2846.class_2847.field_12973 -> SpongeEventFactory.createInteractBlockEventPrimaryFinish((Cause)frame.currentCause(), (BlockSnapshot)blockSnapshot, (Direction)direction);
                default -> throw new IllegalStateException("unreachable code");
            };
            SpongeCommon.post((Event)event);
            InteractBlockEvent.Primary.Start start = event;
            return start;
        }
    }

    public static InteractBlockEvent.Secondary callInteractBlockEventSecondary(class_1657 player, class_1799 heldItem, Vector3d hitVec, BlockSnapshot targetBlock, Direction targetSide, class_1268 hand) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            SpongeCommonEventFactory.applyCommonInteractContext(player, heldItem, hand, targetBlock, null, frame);
            InteractBlockEvent.Secondary event = SpongeEventFactory.createInteractBlockEventSecondary((Cause)frame.currentCause(), (Tristate)Tristate.UNDEFINED, (Tristate)Tristate.UNDEFINED, (Tristate)Tristate.UNDEFINED, (Tristate)Tristate.UNDEFINED, (BlockSnapshot)targetBlock, (Vector3d)hitVec, (Direction)targetSide);
            SpongeCommon.post((Event)event);
            InteractBlockEvent.Secondary secondary = event;
            return secondary;
        }
    }

    public static void applyCommonInteractContext(class_1657 player, class_1799 stack, class_1268 hand, @Nullable BlockSnapshot targetBlock, @Nullable class_1297 entity, CauseStackManager.StackFrame frame) {
        if (((PlatformEntityBridge)player).bridge$isFakePlayer()) {
            frame.addContext(EventContextKeys.FAKE_PLAYER, (Object)((Player)player));
        } else {
            frame.pushCause((Object)player);
            frame.addContext(EventContextKeys.CREATOR, (Object)player.method_5667());
            frame.addContext(EventContextKeys.NOTIFIER, (Object)player.method_5667());
        }
        if (!stack.method_7960()) {
            frame.addContext(EventContextKeys.USED_ITEM, (Object)ItemStackUtil.snapshotOf(stack));
        }
        frame.addContext(EventContextKeys.USED_HAND, (Object)((HandType)hand));
        if (targetBlock != null) {
            frame.addContext(EventContextKeys.BLOCK_HIT, (Object)targetBlock);
        }
        if (entity != null) {
            frame.addContext(EventContextKeys.ENTITY_HIT, (Object)((Entity)entity));
        }
    }

    public static void callNaturalMoveEntityEvent(class_1297 entity) {
        if (entity.method_31481()) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            frame.pushCause((Object)entity);
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, (Supplier)MovementTypes.NATURAL);
            Vector3d originalToPosition = ((Entity)entity).position();
            @Nullable Vector3d finalPosition = SpongeCommonEventFactory.callMoveEvent((Entity)entity, new Vector3d(entity.field_6038, entity.field_5971, entity.field_5989), originalToPosition);
            if (finalPosition == null) {
                entity.method_24203(entity.field_6038, entity.field_5971, entity.field_5989);
            } else if (!finalPosition.equals((Object)originalToPosition)) {
                entity.method_24203(finalPosition.x(), finalPosition.y(), finalPosition.z());
            }
        }
    }

    public static void callNaturalRotateEntityEvent(class_1297 entity) {
        if (entity.method_31481() || entity.method_36455() == entity.field_6004 && entity.method_36454() == entity.field_5982) {
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            frame.pushCause((Object)entity);
            @Nullable Vector3d finalRotation = SpongeCommonEventFactory.callRotateEvent((Entity)entity, new Vector3d(entity.field_5982, entity.field_6004, 0.0f), new Vector3d(entity.method_36454(), entity.method_36455(), 0.0f));
            if (finalRotation == null) {
                entity.method_36457(entity.field_6004);
                entity.method_36456(entity.field_5982);
            } else {
                entity.method_36457((float)finalRotation.y());
                entity.method_36456((float)finalRotation.x());
            }
        }
    }

    public static @Nullable Vector3d callMoveEvent(Entity movingEntity, Vector3d fromPosition, Vector3d toPosition) {
        Cause cause = PhaseTracker.getInstance().currentCause();
        if (ShouldFire.MOVE_ENTITY_EVENT && fromPosition != null && toPosition != null && !fromPosition.mul(8.0).toInt().equals((Object)toPosition.mul(8.0).toInt())) {
            MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent((Cause)cause, (Entity)movingEntity, (Vector3d)fromPosition, (Vector3d)toPosition, (Vector3d)toPosition);
            if (SpongeCommon.post((Event)event)) {
                return null;
            }
            return event.destinationPosition();
        }
        return toPosition;
    }

    public static @Nullable Vector3d callRotateEvent(Entity movingEntity, Vector3d fromRotation, Vector3d toRotation) {
        Cause cause = PhaseTracker.getInstance().currentCause();
        if (ShouldFire.ROTATE_ENTITY_EVENT && fromRotation != null && toRotation != null && !fromRotation.mul(20.0).toInt().equals((Object)toRotation.mul(20.0).toInt())) {
            RotateEntityEvent event = SpongeEventFactory.createRotateEntityEvent((Cause)cause, (Entity)movingEntity, (Vector3d)fromRotation, (Vector3d)toRotation);
            if (SpongeCommon.post((Event)event)) {
                return null;
            }
            return event.toRotation();
        }
        return toRotation;
    }

    public static DestructEntityEvent.Death callDestructEntityEventDeath(class_1309 entity, @Nullable class_1282 source) {
        return SpongeCommonEventFactory.callDestructEntityEventDeath(entity, source, Audience.empty());
    }

    public static DestructEntityEvent.Death callDestructEntityEventDeath(class_1309 entity, @Nullable class_1282 source, Audience originalChannel) {
        class_1297 class_12972;
        Optional<Object> sourceCreator = Optional.empty();
        boolean messageCancelled = false;
        if (source != null && (class_12972 = source.method_5526()) instanceof CreatorTrackedBridge) {
            CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)class_12972;
            sourceCreator = creatorBridge.tracker$getCreatorUUID();
        }
        Component originalMessage = SpongeAdventure.asAdventure(entity.method_6066().method_5548());
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            if (source != null) {
                frame.pushCause((Object)source);
            }
            sourceCreator.ifPresent(user -> frame.addContext(EventContextKeys.CREATOR, user));
            DestructEntityEvent.Death event = SpongeEventFactory.createDestructEntityEventDeath((Cause)frame.currentCause(), (Audience)originalChannel, Optional.of(originalChannel), (Component)originalMessage, (Component)originalMessage, (Living)((Living)entity), (boolean)((class_3218)entity.method_37908()).method_64395().method_8355(class_1928.field_19389), (boolean)false);
            SpongeCommon.post((Event)event);
            DestructEntityEvent.Death death = event;
            return death;
        }
    }

    public static boolean handleCollideBlockEvent(class_2248 block, class_1937 world, class_2338 pos, class_2680 state, class_1297 entity, Direction direction, CollisionType type) {
        if (world.field_9236) {
            return false;
        }
        if (world.method_8608() || pos.method_10264() < world.method_31607()) {
            return false;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            EntityBridge spongeEntity;
            frame.pushCause((Object)entity);
            if (entity instanceof CreatorTrackedBridge) {
                CreatorTrackedBridge spongeEntity2 = (CreatorTrackedBridge)entity;
                spongeEntity2.tracker$getCreatorUUID().ifPresent(user -> frame.addContext(EventContextKeys.CREATOR, user));
            }
            ServerLocation loc = ServerLocation.of((ServerWorld)((ServerWorld)world), (Vector3d)VecHelper.toVector3d(pos));
            boolean cancelled = SpongeCommon.post((Event)(switch (type.ordinal()) {
                case 0 -> SpongeEventFactory.createCollideBlockEventMove((Cause)frame.currentCause(), (BlockState)((BlockState)state), (ServerLocation)loc, (Direction)direction);
                case 1 -> SpongeEventFactory.createCollideBlockEventFall((Cause)frame.currentCause(), (BlockState)((BlockState)state), (ServerLocation)loc, (Direction)direction);
                case 2 -> SpongeEventFactory.createCollideBlockEventStepOn((Cause)frame.currentCause(), (BlockState)((BlockState)state), (ServerLocation)loc, (Direction)direction);
                case 3 -> SpongeEventFactory.createCollideBlockEventInside((Cause)frame.currentCause(), (BlockState)((BlockState)state), (ServerLocation)loc, (Direction)direction);
                default -> throw new IllegalArgumentException("Unknown type " + String.valueOf((Object)type));
            }));
            if (!cancelled && !pos.equals((Object)(spongeEntity = (EntityBridge)entity).bridge$getLastCollidedBlockPos())) {
                PhaseContext<?> context = PhaseTracker.getInstance().getPhaseContext();
                context.applyNotifierIfAvailable(notifier -> {
                    LevelChunkBridge spongeChunk = (LevelChunkBridge)world.method_8500(pos);
                    spongeChunk.bridge$addTrackedBlockPosition(block, pos, (UUID)notifier, PlayerTracker.Type.NOTIFIER);
                });
            }
            boolean bl = cancelled;
            return bl;
        }
    }

    public static boolean handleCollideImpactEvent(class_1297 projectile, @Nullable ProjectileSource projectileSource, class_239 movingObjectPosition) {
        class_239.class_240 movingObjectType = movingObjectPosition.method_17783();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            frame.pushCause((Object)projectile);
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, (Object)(projectileSource == null ? UnknownProjectileSource.UNKNOWN : projectileSource));
            Optional<UUID> creator = PhaseTracker.getInstance().getPhaseContext().getCreator();
            creator.ifPresent(user -> frame.addContext(EventContextKeys.CREATOR, user));
            ServerLocation impactPoint = ServerLocation.of((ServerWorld)((ServerWorld)projectile.method_37908()), (Vector3d)VecHelper.toVector3d(movingObjectPosition.method_17784()));
            boolean cancelled = false;
            if (movingObjectType == class_239.class_240.field_1332) {
                class_3965 blockMovingObjectPosition = (class_3965)movingObjectPosition;
                class_2338 blockPos = blockMovingObjectPosition.method_17777();
                if (blockPos.method_10264() < projectile.method_37908().method_31607()) {
                    boolean bl = false;
                    return bl;
                }
                BlockSnapshot targetBlock = ((ServerWorld)projectile.method_37908()).createSnapshot(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
                Direction side = DirectionFacingProvider.INSTANCE.getKey(blockMovingObjectPosition.method_17780()).get();
                CollideBlockEvent.Impact event = SpongeEventFactory.createCollideBlockEventImpact((Cause)frame.currentCause(), (ServerLocation)impactPoint, (BlockState)targetBlock.state(), (ServerLocation)((ServerLocation)targetBlock.location().get()), (Direction)side);
                cancelled = SpongeCommon.post((Event)event);
                if (!cancelled && creator.isPresent()) {
                    class_2338 targetPos = VecHelper.toBlockPos(impactPoint.blockPosition());
                    LevelChunkBridge spongeChunk = (LevelChunkBridge)projectile.method_37908().method_8500(targetPos);
                    spongeChunk.bridge$addTrackedBlockPosition((class_2248)targetBlock.state().type(), targetPos, creator.get(), PlayerTracker.Type.NOTIFIER);
                }
            } else if (movingObjectType == class_239.class_240.field_1331) {
                class_3966 entityMovingObjectPosition = (class_3966)movingObjectPosition;
                ArrayList<Entity> entityList = new ArrayList<Entity>();
                entityList.add((Entity)entityMovingObjectPosition.method_17782());
                CollideEntityEvent.Impact event = SpongeEventFactory.createCollideEntityEventImpact((Cause)frame.currentCause(), entityList, (ServerLocation)impactPoint);
                cancelled = SpongeCommon.post((Event)event);
            }
            boolean bl = cancelled;
            return bl;
        }
    }

    public static SetAITargetEvent callSetAttackTargetEvent(@Nullable Entity target, Agent agent) {
        SetAITargetEvent event = SpongeEventFactory.createSetAITargetEvent((Cause)PhaseTracker.getInstance().currentCause(), (Agent)agent, Optional.ofNullable(target));
        SpongeCommon.post((Event)event);
        return event;
    }

    public static class_1799 throwDropItemAndConstructEvent(class_1297 entity, double posX, double posY, double posZ, ItemStackSnapshot snapshot, List<ItemStackSnapshot> original, CauseStackManager.StackFrame frame) {
        class_1799 item;
        frame.pushCause((Object)entity);
        DropItemEvent.Pre dropEvent = SpongeEventFactory.createDropItemEventPre((Cause)frame.currentCause(), (List)ImmutableList.of((Object)snapshot), original);
        SpongeCommon.post((Event)dropEvent);
        if (dropEvent.isCancelled()) {
            return class_1799.field_8037;
        }
        if (dropEvent.droppedItems().isEmpty()) {
            return class_1799.field_8037;
        }
        frame.addContext(EventContextKeys.SPAWN_TYPE, (Supplier)SpawnTypes.DROPPED_ITEM);
        ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre((Cause)frame.currentCause(), (ServerLocation)ServerLocation.of((ServerWorld)((ServerWorld)entity.method_37908()), (double)posX, (double)posY, (double)posZ), (Vector3d)new Vector3d(0.0f, 0.0f, 0.0f), (EntityType)((EntityType)EntityTypes.ITEM.get()));
        frame.removeContext(EventContextKeys.SPAWN_TYPE);
        SpongeCommon.post((Event)event);
        if (event.isCancelled()) {
            return class_1799.field_8037;
        }
        class_1799 class_17992 = item = event.isCancelled() ? class_1799.field_8037 : ItemStackUtil.fromSnapshotToNative((ItemStackSnapshot)dropEvent.droppedItems().get(0));
        if (item == null) {
            return class_1799.field_8037;
        }
        return item;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable PlaySoundEvent.Broadcast callPlaySoundBroadcastEvent(CauseStackManager.StackFrame frame, LevelBridge bridge, class_2338 pos, int effectID) {
        float volume;
        DefaultedRegistryReference soundType;
        if (effectID == 1023) {
            soundType = SoundTypes.ENTITY_WITHER_SPAWN;
            volume = 1.0f;
        } else if (effectID == 1028) {
            soundType = SoundTypes.ENTITY_ENDER_DRAGON_DEATH;
            volume = 5.0f;
        } else if (effectID == 1038) {
            soundType = SoundTypes.BLOCK_END_PORTAL_SPAWN;
            volume = 1.0f;
        } else {
            return null;
        }
        ServerLocation location = ServerLocation.of((ServerWorld)((ServerWorld)bridge), (int)pos.method_10263(), (int)pos.method_10264(), (int)pos.method_10260());
        PlaySoundEvent.Broadcast event = SpongeEventFactory.createPlaySoundEventBroadcast((Cause)frame.currentCause(), (ServerLocation)location, (Sound.Source)Sound.Source.HOSTILE, (SoundType)((SoundType)soundType.get()), (float)1.0f, (float)volume);
        SpongeCommon.post((Event)event);
        return event;
    }

    public static PlaySoundEvent.FromJukebox callPlaySoundFromJukeboxEvent(Cause cause, class_2619 jukebox, MusicDisc recordType, int data) {
        Jukebox apiJuke = (Jukebox)jukebox;
        ServerLocation location = (ServerLocation)apiJuke.location();
        PlaySoundEvent.FromJukebox.Start event = data == 0 ? SpongeEventFactory.createPlaySoundEventFromJukeboxStart((Cause)cause, (Jukebox)apiJuke, (ServerLocation)location, (MusicDisc)recordType, (Sound.Source)Sound.Source.RECORD, (SoundType)recordType.sound(), (float)1.0f, (float)4.0f) : SpongeEventFactory.createPlaySoundEventFromJukeboxStop((Cause)cause, (Jukebox)apiJuke, (ServerLocation)location, (MusicDisc)recordType, (Sound.Source)Sound.Source.RECORD, (SoundType)recordType.sound(), (float)1.0f, (float)4.0f);
        SpongeCommon.post((Event)event);
        return event;
    }

    public static PlaySoundEvent.AtEntity callPlaySoundAtEntityEvent(Cause cause, @Nullable class_1657 entity, LevelBridge worldMixin, double x, double y, double z, class_3419 category, class_3414 name, float pitch, float volume) {
        ServerLocation location = ServerLocation.of((ServerWorld)((ServerWorld)worldMixin), (double)x, (double)y, (double)z);
        PlaySoundEvent.AtEntity event = SpongeEventFactory.createPlaySoundEventAtEntity((Cause)cause, (ServerLocation)location, Optional.ofNullable((ServerPlayer)entity), (Sound.Source)SpongeAdventure.asAdventure(category), (SoundType)((SoundType)name), (float)pitch, (float)volume);
        SpongeCommon.post((Event)event);
        return event;
    }

    public static PlaySoundEvent.NoteBlock callPlaySoundNoteBlockEvent(Cause cause, World world, class_2338 pos, class_3414 soundEvent, InstrumentType instrument, NotePitch notePitch, Float pitch) {
        ServerLocation location = ServerLocation.of((ServerWorld)((ServerWorld)world), (int)pos.method_10263(), (int)pos.method_10264(), (int)pos.method_10260());
        PlaySoundEvent.NoteBlock event = SpongeEventFactory.createPlaySoundEventNoteBlock((Cause)cause, (InstrumentType)instrument, (ServerLocation)location, (NotePitch)notePitch, (Sound.Source)Sound.Source.RECORD, (SoundType)((SoundType)soundEvent), (float)pitch.floatValue(), (float)3.0f);
        SpongeCommon.post((Event)event);
        return event;
    }

    public static Optional<MapInfo> fireCreateMapEvent(Cause cause) {
        return SpongeCommonEventFactory.fireCreateMapEvent(cause, Collections.emptySet());
    }

    public static Optional<MapInfo> fireCreateMapEvent(Cause cause, Set<Value<?>> values) {
        class_9209 mcId;
        class_3218 defaultWorld = (class_3218)Sponge.server().worldManager().world(DefaultWorldKeys.DEFAULT).get();
        MapIdTrackerBridge mapIdTrackerBridge = (MapIdTrackerBridge)defaultWorld.method_17983().method_17924(class_3978.method_52610(), "idcounts");
        class_22 mapData = class_22.method_32363((double)0.0, (double)0.0, (byte)0, (boolean)true, (boolean)false, (class_5321)class_1937.field_25181);
        MapInfo mapInfo = (MapInfo)mapData;
        for (Value<?> value : values) {
            mapInfo.offer(value);
        }
        CreateMapEvent event = SpongeEventFactory.createCreateMapEvent((Cause)cause, (MapInfo)mapInfo);
        SpongeCommon.post((Event)event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        int id = mapIdTrackerBridge.bridge$getHighestMapId().orElse(-1) + 1;
        if (id != (mcId = defaultWorld.method_17889()).comp_2315()) {
            SpongeCommon.logger().warn("Map size corruption, vanilla only allows 2147483647! Expected next number was not equal to the true next number.");
            SpongeCommon.logger().warn("Expected: " + id + ". Got: " + String.valueOf(mcId));
            SpongeCommon.logger().warn("Automatically cancelling map creation");
            mapIdTrackerBridge.bridge$setHighestMapId(id - 1);
            return Optional.empty();
        }
        defaultWorld.method_17890(new class_9209(id), mapData);
        ((MapItemSavedDataBridge)mapData).bridge$initMapId(id);
        ((SpongeMapStorage)Sponge.server().mapStorage()).addMapInfo(mapInfo);
        return Optional.of(mapInfo);
    }

    public static enum CollisionType {
        MOVE,
        FALL,
        STEP_ON,
        INSIDE;

    }
}

