/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.filter.delegate;

import java.lang.reflect.Field;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKey;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.filter.cause.ContextValue;
import org.spongepowered.common.event.filter.delegate.CauseFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.ParameterFilterSourceDelegate;
import org.spongepowered.common.event.manager.ListenerClassVisitor;

public class ContextValueFilterSourceDelegate
extends CauseFilterSourceDelegate {
    private static final Type EVENT_CONTEXT = Type.getType(EventContext.class);
    private static final Type EVENT_CONTEXT_KEY = Type.getType(EventContextKey.class);
    private static final Type EVENT_CONTEXT_KEYS = Type.getType(EventContextKeys.class);
    private final ContextValue anno;

    public ContextValueFilterSourceDelegate(ContextValue anno) {
        this.anno = anno;
    }

    @Override
    protected void insertCauseCall(MethodVisitor mv, ListenerClassVisitor.ListenerParameter param, Type targetType) {
        Field targetField;
        try {
            targetField = EventContextKeys.class.getField(this.anno.value());
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalArgumentException(String.format("Field %s specified by GetValue annotation was not found in EventContextKeys", this.anno.value()));
        }
        if (!EventContextKey.class.isAssignableFrom(targetField.getType())) {
            throw new IllegalArgumentException(String.format("Field %s.%s was not an EventContextKey", targetField.getName(), targetField.getType()));
        }
        mv.visitMethodInsn(182, CauseFilterSourceDelegate.CAUSE.getInternalName(), "context", "()" + EVENT_CONTEXT.getDescriptor(), false);
        mv.visitFieldInsn(178, EVENT_CONTEXT_KEYS.getInternalName(), this.anno.value(), EVENT_CONTEXT_KEY.getDescriptor());
        mv.visitMethodInsn(182, EVENT_CONTEXT.getInternalName(), "get", Type.getMethodDescriptor((Type)ParameterFilterSourceDelegate.OPTIONAL, (Type[])new Type[]{EVENT_CONTEXT_KEY}), false);
    }

    @Override
    protected void insertTransform(MethodVisitor mv, ListenerClassVisitor.ListenerParameter param, Type targetType, int local) {
        mv.visitVarInsn(25, local);
        Label failure = new Label();
        Label success = new Label();
        mv.visitMethodInsn(182, ParameterFilterSourceDelegate.OPTIONAL.getInternalName(), "isPresent", "()Z", false);
        mv.visitJumpInsn(153, failure);
        mv.visitVarInsn(25, local);
        mv.visitMethodInsn(182, ParameterFilterSourceDelegate.OPTIONAL.getInternalName(), "get", "()Ljava/lang/Object;", false);
        mv.visitVarInsn(58, local);
        mv.visitVarInsn(25, local);
        mv.visitTypeInsn(193, targetType.getInternalName());
        if (this.anno.typeFilter().length != 0) {
            mv.visitJumpInsn(153, failure);
            mv.visitVarInsn(25, local);
            for (int i = 0; i < this.anno.typeFilter().length; ++i) {
                Class filter = this.anno.typeFilter()[i];
                if (i < this.anno.typeFilter().length - 1) {
                    mv.visitInsn(89);
                }
                mv.visitTypeInsn(193, Type.getInternalName((Class)filter));
                if (this.anno.inverse()) {
                    mv.visitJumpInsn(154, failure);
                    continue;
                }
                mv.visitJumpInsn(154, success);
            }
            if (this.anno.inverse()) {
                mv.visitJumpInsn(167, success);
            }
        } else {
            mv.visitJumpInsn(154, success);
        }
        mv.visitLabel(failure);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitLabel(success);
    }
}

