/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.filter.delegate;

import java.lang.reflect.Method;
import java.util.Optional;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.event.filter.delegate.ParameterFilterSourceDelegate;
import org.spongepowered.common.event.manager.ListenerClassVisitor;

public class GetterFilterSourceDelegate
implements ParameterFilterSourceDelegate {
    private final Getter anno;

    public GetterFilterSourceDelegate(Getter a) {
        this.anno = a;
    }

    @Override
    public Tuple<Integer, Integer> write(ClassWriter cw, MethodVisitor mv, ListenerClassVisitor.DiscoveredMethod method, int paramIdx, int local, int[] plocals, ListenerClassVisitor.ListenerParameter[] params) throws ClassNotFoundException {
        Class<?> targetType = method.classByLoader(params[paramIdx].type().getClassName());
        Class<?> eventClass = method.classByLoader(params[0].type().getClassName());
        String targetMethod = this.anno.value();
        Method targetMethodObj = null;
        try {
            targetMethodObj = eventClass.getMethod(targetMethod, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Method %s specified by getter annotation was not found in type %s", targetMethod, eventClass.getName()));
        }
        if (targetMethodObj.getParameterCount() != 0) {
            throw new IllegalArgumentException("Method " + targetMethodObj.toGenericString() + " specified by getter annotation has non-zero parameter count");
        }
        if (!targetMethodObj.getReturnType().equals(Optional.class) && !targetMethodObj.getReturnType().isAssignableFrom(targetType)) {
            throw new IllegalArgumentException("Method " + targetMethodObj.toGenericString() + " does not return the correct type. Expected: " + targetType.getName() + " Found: " + targetMethodObj.getReturnType().getName());
        }
        Type returnType = Type.getReturnType((Method)targetMethodObj);
        Class<?> declaringClass = targetMethodObj.getDeclaringClass();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(declaringClass));
        int op = declaringClass.isInterface() ? 185 : 182;
        mv.visitMethodInsn(op, Type.getInternalName(declaringClass), targetMethod, "()" + returnType.getDescriptor(), declaringClass.isInterface());
        int paramLocal = local++;
        mv.visitVarInsn(returnType.getOpcode(54), paramLocal);
        if (!targetMethodObj.getReturnType().isPrimitive()) {
            Label failure = new Label();
            Label success = new Label();
            if (Optional.class.equals(targetMethodObj.getReturnType()) && !Optional.class.equals(targetType)) {
                mv.visitVarInsn(25, paramLocal);
                mv.visitMethodInsn(182, "java/util/Optional", "isPresent", "()Z", false);
                mv.visitJumpInsn(153, failure);
                mv.visitVarInsn(25, paramLocal);
                mv.visitMethodInsn(182, "java/util/Optional", "get", "()Ljava/lang/Object;", false);
                mv.visitInsn(89);
                mv.visitVarInsn(58, paramLocal);
            } else {
                mv.visitVarInsn(returnType.getOpcode(21), paramLocal);
            }
            mv.visitTypeInsn(193, Type.getInternalName(targetType));
            mv.visitJumpInsn(154, success);
            mv.visitLabel(failure);
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitLabel(success);
        }
        return new Tuple((Object)local, (Object)paramLocal);
    }
}

