/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1263;
import net.minecraft.class_1270;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1542;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1706;
import net.minecraft.class_1718;
import net.minecraft.class_1728;
import net.minecraft.class_1799;
import net.minecraft.class_1889;
import net.minecraft.class_1915;
import net.minecraft.class_2561;
import net.minecraft.class_2614;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3989;
import net.minecraft.class_747;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ChangeEntityEquipmentEvent;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.EnchantItemEvent;
import org.spongepowered.api.event.item.inventory.TransferInventoryEvent;
import org.spongepowered.api.event.item.inventory.UpdateAnvilEvent;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.inventory.container.ContainerBridge;
import org.spongepowered.common.bridge.world.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.inventory.UpdateAnvilEventCost;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.inventory.util.ContainerUtil;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.enchantment.SpongeRandomEnchantmentListBuilder;
import org.spongepowered.common.item.util.ItemStackUtil;

public class InventoryEventFactory {
    public static boolean callPlayerInventoryPickupEvent(class_1657 player, class_1542 itemToPickup) {
        boolean added;
        class_1799 stack = itemToPickup.method_6983();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance((class_3218)player.method_37908());
        ChangeInventoryEvent.Pickup.Pre event = SpongeEventFactory.createChangeInventoryEventPickupPre((Cause)phaseTracker.currentCause(), Optional.empty(), Collections.singletonList(snapshot), (Inventory)((Inventory)player.field_7512), (Item)((Item)itemToPickup), (ItemStackSnapshot)snapshot);
        SpongeCommon.post((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (event.custom().isPresent()) {
            List list = (List)event.custom().get();
            if (list.isEmpty()) {
                stack.method_7939(0);
                return true;
            }
            PhaseContext<@NonNull ?> context = phaseTracker.getPhaseContext();
            TransactionalCaptureSupplier transactor = context.getTransactor();
            try (EffectTransactor ignored = transactor.logPlayerInventoryChangeWithEffect(player, PlayerInventoryTransaction.EventCreator.PICKUP);){
                for (ItemStackSnapshot item : list) {
                    ItemStack itemStack = item.asMutable();
                    player.method_31548().method_7394(ItemStackUtil.toNative(itemStack));
                    if (itemStack.isEmpty()) continue;
                    ignored.parent.markCancelled();
                    boolean bl = false;
                    return bl;
                }
            }
            if (!TrackingUtil.processBlockCaptures(context)) {
                return false;
            }
            stack.method_7939(0);
            return true;
        }
        PhaseContext<@NonNull ?> context = phaseTracker.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        try (EffectTransactor ignored = transactor.logPlayerInventoryChangeWithEffect(player, PlayerInventoryTransaction.EventCreator.PICKUP);){
            added = player.method_31548().method_7394(stack);
        }
        if (!TrackingUtil.processBlockCaptures(context)) {
            return false;
        }
        return added;
    }

    public static class_1799 callHopperInventoryPickupEvent(class_1263 inventory, class_1542 item, class_1799 stack) {
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance((class_3218)item.method_37908());
        try (CauseStackManager.StackFrame frame = phaseTracker.pushCauseFrame();){
            frame.pushCause((Object)inventory);
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            ChangeInventoryEvent.Pickup.Pre event = SpongeEventFactory.createChangeInventoryEventPickupPre((Cause)frame.currentCause(), Optional.empty(), Collections.singletonList(snapshot), (Inventory)((Inventory)inventory), (Item)((Item)item), (ItemStackSnapshot)snapshot);
            SpongeCommon.post((Event)event);
            if (event.isCancelled()) {
                class_1799 class_17992 = stack;
                return class_17992;
            }
            int size = inventory.method_5439();
            class_1799[] prevInventory = new class_1799[size];
            for (int i = 0; i < size; ++i) {
                prevInventory[i] = inventory.method_5438(i);
            }
            if (event.custom().isPresent()) {
                class_1799 class_17993;
                if (((List)event.custom().get()).isEmpty()) {
                    class_1799 i = class_1799.field_8037;
                    return i;
                }
                boolean fullTransfer = true;
                for (ItemStackSnapshot snap : (List)event.custom().get()) {
                    class_1799 stackToAdd = ItemStackUtil.fromSnapshotToNative(snap);
                    class_1799 remaining = class_2614.method_11260(null, (class_1263)inventory, (class_1799)stackToAdd, null);
                    if (remaining.method_7960()) continue;
                    fullTransfer = false;
                    break;
                }
                if (!fullTransfer) {
                    for (int i = 0; i < prevInventory.length; ++i) {
                        inventory.method_5447(i, prevInventory[i]);
                    }
                    class_1799 class_17994 = stack;
                    return class_17994;
                }
                if (InventoryEventFactory.callInventoryPickupEvent(inventory, prevInventory)) {
                    class_17993 = class_1799.field_8037;
                    return class_17993;
                }
                class_17993 = stack;
                return class_17993;
            }
            class_1799 remainder = class_2614.method_11260(null, (class_1263)inventory, (class_1799)stack, null);
            if (InventoryEventFactory.callInventoryPickupEvent(inventory, prevInventory)) {
                class_1799 class_17995 = remainder;
                return class_17995;
            }
            class_1799 class_17996 = stack;
            return class_17996;
        }
    }

    private static boolean callInventoryPickupEvent(class_1263 inventory, class_1799[] prevInventory) {
        Inventory spongeInventory = InventoryUtil.toInventory(inventory, null);
        List<SlotTransaction> trans = InventoryEventFactory.generateTransactions(spongeInventory, inventory, prevInventory);
        if (trans.isEmpty()) {
            return true;
        }
        ChangeInventoryEvent.Pickup event = SpongeEventFactory.createChangeInventoryEventPickup((Cause)PhaseTracker.getInstance().currentCause(), (Inventory)spongeInventory, trans);
        SpongeCommon.post((Event)event);
        PacketPhaseUtil.handleSlotRestore(null, null, event.transactions(), event.isCancelled());
        return !event.isCancelled();
    }

    private static List<SlotTransaction> generateTransactions(@Nullable Inventory inv, class_1263 inventory, class_1799[] previous) {
        if (inv == null) {
            return Collections.emptyList();
        }
        ArrayList<SlotTransaction> trans = new ArrayList<SlotTransaction>();
        List slots = inv.slots();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 prevStack;
            Slot slot = (Slot)slots.get(i);
            class_1799 newStack = inventory.method_5438(i);
            if (class_1799.method_7973((class_1799)newStack, (class_1799)(prevStack = previous[i]))) continue;
            trans.add(new SlotTransaction(slot, ItemStackUtil.snapshotOf(prevStack), ItemStackUtil.snapshotOf(newStack)));
        }
        return trans;
    }

    public static boolean callInteractContainerOpenEvent(class_3222 player, class_1703 menu) {
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(menu.method_34255());
        Transaction cursorTransaction = new Transaction((DataSerializable)ItemStackSnapshot.empty(), (DataSerializable)newCursor);
        InteractContainerEvent.Open event = SpongeEventFactory.createInteractContainerEventOpen((Cause)PhaseTracker.getWorldInstance(player.method_51469()).currentCause(), (Container)((Container)player.field_7512), (Transaction)cursorTransaction);
        SpongeCommon.post((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        PacketPhaseUtil.handleCursorRestore((class_1657)player, (Transaction<ItemStackSnapshot>)event.cursorTransaction(), event.isCancelled());
        return true;
    }

    public static @Nullable class_1703 displayContainer(class_3222 player, Inventory inventory, Component displayName) {
        CarriedInventory carriedInventory;
        Object var8_7;
        class_1703 previousContainer = player.field_7512;
        Optional viewable = inventory.asViewable();
        if (viewable.isPresent()) {
            Object t = viewable.get();
            if (t instanceof class_3908) {
                class_1703 class_17032;
                class_3908 namedContainerProvider = (class_3908)t;
                if (displayName != null) {
                    namedContainerProvider = new class_747((class_1270)namedContainerProvider, SpongeAdventure.asVanilla(displayName));
                }
                if (((OptionalInt)(containerId = player.method_17355(namedContainerProvider))).isPresent() && (class_17032 = player.field_7512) instanceof class_1728) {
                    class_1728 merchantMenu = (class_1728)class_17032;
                    player.method_17354(((OptionalInt)containerId).getAsInt(), merchantMenu.method_17438(), 0, 0, false, false);
                }
            } else {
                containerId = viewable.get();
                if (containerId instanceof class_1915) {
                    OptionalInt containerId;
                    class_1915 merchant = (class_1915)containerId;
                    class_2561 display = null;
                    int level = 0;
                    if (merchant instanceof class_1646) {
                        class_1646 villager = (class_1646)merchant;
                        display = villager.method_5476();
                        level = villager.method_7231().method_16925();
                    } else if (merchant instanceof class_3989) {
                        class_3989 trader = (class_3989)merchant;
                        display = trader.method_5476();
                        level = 1;
                    }
                    if (displayName != null) {
                        display = SpongeAdventure.asVanilla(displayName);
                    }
                    if ((containerId = player.method_17355((class_3908)new class_747((id, playerInv, p) -> new class_1728(id, playerInv, merchant), display))).isPresent() && !merchant.method_8264().isEmpty()) {
                        player.method_17354(containerId.getAsInt(), merchant.method_8264(), level, merchant.method_19269(), merchant.method_19270(), merchant.method_20708());
                    }
                }
            }
        } else if (inventory instanceof CarriedInventory && (var8_7 = (carriedInventory = (CarriedInventory)inventory).carrier().orElse(null)) instanceof class_1496) {
            class_1496 horse = var8_7;
            horse.method_6722((class_1657)player);
        }
        class_1703 container = player.field_7512;
        if (previousContainer == container) {
            return null;
        }
        if (container instanceof ContainerBridge) {
            ((ContainerBridge)container).bridge$setCanInteractWith(p -> !p.method_31481());
        }
        return container;
    }

    public static TransferInventoryEvent.Pre callTransferPre(Inventory source, Inventory destination) {
        PhaseTracker.getInstance().pushCause(source);
        TransferInventoryEvent.Pre event = SpongeEventFactory.createTransferInventoryEventPre((Cause)PhaseTracker.getInstance().currentCause(), (Inventory)source, (Inventory)destination);
        SpongeCommon.post((Event)event);
        PhaseTracker.getInstance().popCause();
        return event;
    }

    public static void callTransferPost(@Nullable TrackedInventoryBridge captureSource, @Nullable Inventory source, @Nullable Inventory destination, class_1799 sourceStack, SlotTransaction sourceSlotTransaction) {
        if (captureSource == null || source == null || destination == null || sourceSlotTransaction == null) {
            return;
        }
        PhaseTracker.getInstance().pushCause(source);
        List<SlotTransaction> slotTransactions = captureSource.bridge$getCapturedSlotTransactions();
        sourceStack = sourceStack.method_7972();
        sourceStack.method_7939(1);
        ItemStackSnapshot transferredStack = ItemStackUtil.snapshotOf(sourceStack);
        Slot sourceSlot = sourceSlotTransaction.slot();
        Slot targetSlot = null;
        for (SlotTransaction transaction : slotTransactions) {
            if (transaction == sourceSlotTransaction) continue;
            targetSlot = transaction.slot();
            break;
        }
        TransferInventoryEvent.Post event = SpongeEventFactory.createTransferInventoryEventPost((Cause)PhaseTracker.getInstance().currentCause(), (Inventory)source, (Slot)sourceSlot, (Inventory)destination, targetSlot, (ItemStackSnapshot)transferredStack);
        SpongeCommon.post((Event)event);
        slotTransactions.clear();
        PhaseTracker.getInstance().popCause();
    }

    public static SlotTransaction captureTransaction(@Nullable TrackedInventoryBridge captureIn, @Nullable Inventory inv, int index, class_1799 originalStack) {
        if (captureIn == null || inv == null) {
            return null;
        }
        Optional slot = inv.slot(index);
        if (slot.isPresent()) {
            SlotTransaction trans = new SlotTransaction((Slot)slot.get(), ItemStackUtil.snapshotOf(originalStack), ItemStackUtil.snapshotOf((ItemStackLike)((Slot)slot.get()).peek()));
            captureIn.bridge$getCapturedSlotTransactions().add(trans);
            return trans;
        }
        SpongeCommon.logger().warn("Unable to capture transaction from " + String.valueOf(inv.getClass()) + " at index " + index);
        return null;
    }

    public static class_1799 captureTransaction(@Nullable TrackedInventoryBridge captureIn, @Nullable Inventory inv, int index, Supplier<class_1799> transaction) {
        if (captureIn == null || inv == null) {
            return transaction.get();
        }
        Optional slot = inv.slot(index);
        if (!slot.isPresent()) {
            SpongeCommon.logger().warn("Unable to capture transaction from " + String.valueOf(inv.getClass()) + " at index " + index);
            return transaction.get();
        }
        ItemStackSnapshot original = ItemStackUtil.snapshotOf((ItemStackLike)((Slot)slot.get()).peek());
        class_1799 remaining = transaction.get();
        if (remaining.method_7960()) {
            ItemStackSnapshot replacement = ItemStackUtil.snapshotOf((ItemStackLike)((Slot)slot.get()).peek());
            captureIn.bridge$getCapturedSlotTransactions().add(new SlotTransaction((Slot)slot.get(), original, replacement));
        }
        return remaining;
    }

    public static UpdateAnvilEvent callUpdateAnvilEvent(class_1706 anvil, class_1799 slot1, class_1799 slot2, class_1799 result, String name, int levelCost, int materialCost) {
        Transaction transaction = new Transaction((DataSerializable)ItemStackSnapshot.empty(), (DataSerializable)ItemStackUtil.snapshotOf(result));
        UpdateAnvilEventCost costs = new UpdateAnvilEventCost(levelCost, materialCost);
        UpdateAnvilEvent event = SpongeEventFactory.createUpdateAnvilEvent((Cause)PhaseTracker.getInstance().currentCause(), (Transaction)new Transaction((DataSerializable)costs, (DataSerializable)costs), (Inventory)((Inventory)anvil), (String)name, (ItemStackSnapshot)ItemStackUtil.snapshotOf(slot1), (Transaction)transaction, (ItemStackSnapshot)ItemStackUtil.snapshotOf(slot2));
        SpongeCommon.post((Event)event);
        return event;
    }

    public static ChangeEntityEquipmentEvent callChangeEntityEquipmentEvent(class_1309 entity, ItemStackSnapshot before, ItemStackSnapshot after, Slot slot) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            frame.pushCause((Object)entity);
            Transaction transaction = new Transaction((DataSerializable)before, (DataSerializable)after);
            Object event = after.isEmpty() ? SpongeEventFactory.createChangeEntityEquipmentEventBreak((Cause)frame.currentCause(), (Entity)((Entity)entity), (Slot)slot, (Transaction)transaction) : SpongeEventFactory.createChangeEntityEquipmentEvent((Cause)frame.currentCause(), (Entity)((Entity)entity), (Slot)slot, (Transaction)transaction);
            SpongeCommon.post((Event)event);
            ChangeEntityEquipmentEvent.Break break_ = event;
            return break_;
        }
    }

    public static int callEnchantEventLevelRequirement(class_1718 container, int seed, int option, int power, class_1799 itemStack, int levelRequirement) {
        Container enchantContainer = ContainerUtil.fromNative((class_1703)container);
        class_1657 viewer = (class_1657)enchantContainer.viewer();
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(viewer.field_7512.method_34255());
        Transaction cursorTrans = new Transaction((DataSerializable)cursor, (DataSerializable)cursor);
        EnchantItemEvent.CalculateLevelRequirement event = SpongeEventFactory.createEnchantItemEventCalculateLevelRequirement((Cause)PhaseTracker.getInstance().currentCause(), (int)levelRequirement, (int)levelRequirement, (Container)enchantContainer, (Transaction)cursorTrans, (ItemStackSnapshot)ItemStackUtil.snapshotOf(itemStack), (int)option, (int)power, (int)seed);
        SpongeCommon.post((Event)event);
        return event.levelRequirement();
    }

    public static List<class_1889> callEnchantEventEnchantmentList(class_1718 container, int seed, class_1799 itemStack, int option, int level, List<class_1889> list) {
        List<Enchantment> enchList = Collections.unmodifiableList(SpongeRandomEnchantmentListBuilder.fromNative(list));
        Container enchantContainer = ContainerUtil.fromNative((class_1703)container);
        class_1657 viewer = (class_1657)enchantContainer.viewer();
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(viewer.field_7512.method_34255());
        Transaction cursorTrans = new Transaction((DataSerializable)cursor, (DataSerializable)cursor);
        EnchantItemEvent.CalculateEnchantment event = SpongeEventFactory.createEnchantItemEventCalculateEnchantment((Cause)PhaseTracker.getInstance().currentCause(), enchList, enchList, (Container)enchantContainer, (Transaction)cursorTrans, (ItemStackSnapshot)ItemStackUtil.snapshotOf(itemStack), (int)level, (int)option, (int)seed);
        SpongeCommon.post((Event)event);
        if (event.enchantments() != event.originalEnchantments()) {
            return SpongeRandomEnchantmentListBuilder.toNative(event.enchantments());
        }
        return list;
    }

    public static EnchantItemEvent.Post callEnchantEventEnchantPost(class_1657 playerIn, class_1718 container, SlotTransaction enchantedItem, SlotTransaction lapisItem, int option, int seed) {
        Container enchantContainer = ContainerUtil.fromNative((class_1703)container);
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(playerIn.field_7512.method_34255());
        Transaction cursorTrans = new Transaction((DataSerializable)cursor, (DataSerializable)cursor);
        ArrayList<SlotTransaction> slotTrans = new ArrayList<SlotTransaction>();
        slotTrans.add(lapisItem);
        slotTrans.add(enchantedItem);
        EnchantItemEvent.Post event = SpongeEventFactory.createEnchantItemEventPost((Cause)PhaseTracker.getInstance().currentCause(), (Container)enchantContainer, (Transaction)cursorTrans, (Slot)enchantedItem.slot(), Optional.empty(), slotTrans, (int)option, (int)seed);
        SpongeCommon.post((Event)event);
        PacketPhaseUtil.handleSlotRestore(playerIn, (class_1703)container, event.transactions(), event.isCancelled());
        PacketPhaseUtil.handleCursorRestore(playerIn, (Transaction<ItemStackSnapshot>)event.cursorTransaction(), event.isCancelled());
        return event;
    }
}

