/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.lifecycle;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Game;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.lifecycle.RegisterTagEvent;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.registry.RegistryKey;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.common.event.lifecycle.AbstractLifecycleEvent;
import org.spongepowered.common.tag.SpongePluginTag;
import org.spongepowered.common.tag.SpongePluginTagModifier;
import org.spongepowered.common.tag.SpongePluginTagPredicate;
import org.spongepowered.common.tag.SpongePluginTags;

public final class RegisterTagEventImpl
extends AbstractLifecycleEvent
implements RegisterTagEvent {
    private final Map<Tag<?>, SpongePluginTagModifier<?>> tags = new HashMap();

    public RegisterTagEventImpl(Cause cause, Game game) {
        super(cause, game);
    }

    public <T> RegisterTagEvent.TagStep<T> tag(Tag<T> tag) {
        SpongePluginTagModifier modifier = this.tags.computeIfAbsent(tag, $ -> new SpongePluginTagModifier());
        return new TagStepImpl(modifier, null);
    }

    public SpongePluginTags tags() {
        return new SpongePluginTags(this.tags.entrySet().stream().collect(Collectors.groupingBy(e -> ((Tag)e.getKey()).registry(), Collectors.toMap(e -> ((Tag)e.getKey()).key(), Map.Entry::getValue))));
    }

    private record TagStepImpl<T>(SpongePluginTagModifier<T> pluginTagModifier, @Nullable SpongePluginTagPredicate<T> predicate) implements RegisterTagEvent.TagStep<T>
    {
        public RegisterTagEvent.TagStep<T> filter(Predicate<DefaultedRegistryReference<T>> predicate) {
            this.pluginTagModifier.filter(SpongePluginTagPredicate.key(predicate));
            return this;
        }

        public RegisterTagEvent.TagStep<T> filterTags(Predicate<Tag<T>> predicate) {
            this.pluginTagModifier.filter(SpongePluginTagPredicate.tag(predicate));
            return this;
        }

        public RegisterTagEvent.TagStep<T> filterTags(BiPredicate<Tag<T>, DefaultedRegistryReference<T>> predicate) {
            this.pluginTagModifier.filter(SpongePluginTagPredicate.tagKey(predicate));
            return this;
        }

        public RegisterTagEvent.TagStep<T> append(RegistryKey<T> key) {
            this.pluginTagModifier.append(new SpongePluginTag(key.location(), false), this.predicate);
            return this;
        }

        public RegisterTagEvent.TagStep<T> append(Tag<T> tag) {
            this.pluginTagModifier.append(new SpongePluginTag(tag.key(), true), this.predicate);
            return this;
        }

        public RegisterTagEvent.TagStep<T> test(Predicate<DefaultedRegistryReference<T>> predicate, Consumer<RegisterTagEvent.TagStep<T>> consumer) {
            consumer.accept(new TagStepImpl<T>(this.pluginTagModifier, SpongePluginTagPredicate.key(predicate).and(this.predicate)));
            return this;
        }

        public RegisterTagEvent.TagStep<T> testTags(Predicate<Tag<T>> predicate, Consumer<RegisterTagEvent.TagStep<T>> consumer) {
            consumer.accept(new TagStepImpl<T>(this.pluginTagModifier, SpongePluginTagPredicate.tag(predicate).and(this.predicate)));
            return this;
        }

        public RegisterTagEvent.TagStep<T> testTags(BiPredicate<Tag<T>, DefaultedRegistryReference<T>> predicate, Consumer<RegisterTagEvent.TagStep<T>> consumer) {
            consumer.accept(new TagStepImpl<T>(this.pluginTagModifier, SpongePluginTagPredicate.tagKey(predicate).and(this.predicate)));
            return this;
        }
    }
}

