/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.manager;

import io.leangen.geantyref.AnnotationFormatException;
import io.leangen.geantyref.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;

public class ListenerClassVisitor
extends ClassVisitor {
    public static final String LISTENER_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(Listener.class);
    public static final String SPONGE_API_ANNOTATION_PREFIX = "org.spongepowered.api";
    public static final int ASM_VERSION = 589824;
    private static final Logger LOGGER = LogManager.getLogger();
    final List<DiscoveredMethod> foundListenerMethods = new LinkedList<DiscoveredMethod>();
    final Class<?> declaringClass;

    private ListenerClassVisitor(Class<?> handle) {
        super(589824);
        this.declaringClass = handle;
    }

    static List<DiscoveredMethod> getEventListenerMethods(Class<?> handle) throws IOException, NoSuchMethodException {
        @Nullable InputStream classStream = handle.getClassLoader().getResourceAsStream(handle.getName().replace(".", "/") + ".class");
        if (classStream == null) {
            throw new IOException("Could not find class " + handle.getName());
        }
        ClassReader reader = new ClassReader(classStream);
        ListenerClassVisitor classVisitor = new ListenerClassVisitor(handle);
        reader.accept((ClassVisitor)classVisitor, 0);
        return classVisitor.foundListenerMethods();
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return new ListenerMethodVisitor(this, name, descriptor, access, signature);
    }

    public List<DiscoveredMethod> foundListenerMethods() {
        return Collections.unmodifiableList(this.foundListenerMethods);
    }

    static class ListenerMethodVisitor
    extends MethodVisitor {
        private final ListenerClassVisitor classVisitor;
        private final DiscoveredMethod discoveredMethod;

        public ListenerMethodVisitor(ListenerClassVisitor listenerClassVisitor, String name, String descriptor, int access, @Nullable String signature) {
            super(589824);
            this.classVisitor = listenerClassVisitor;
            org.objectweb.asm.Type[] type = org.objectweb.asm.Type.getArgumentTypes((String)descriptor);
            ListenerParameter[] parameters = new ListenerParameter[type.length];
            this.discoveredMethod = new DiscoveredMethod(this.classVisitor.declaringClass, access, signature, name, descriptor, parameters);
            for (int i = 0; i < type.length; ++i) {
                parameters[i] = new ListenerParameter(this.discoveredMethod, type[i]);
            }
        }

        public void visitLocalVariable(String name, String descriptor, @Nullable String signature, Label start, Label end, int index) {
            if (index == 0 || index > this.discoveredMethod.parameters.length) {
                return;
            }
            ListenerParameter parameter = this.discoveredMethod.parameters[index - 1];
            parameter.name = name;
            if (index != 1) {
                return;
            }
            if (signature != null) {
                new SignatureReader(signature).accept((SignatureVisitor)new ListenerSignatureVisitor(parameter));
            } else if (this.discoveredMethod.signature != null) {
                new SignatureReader(this.discoveredMethod.signature).accept((SignatureVisitor)new ListenerSignatureVisitor(parameter));
            }
        }

        public @Nullable AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            org.objectweb.asm.Type type = org.objectweb.asm.Type.getType((String)descriptor);
            if (Objects.equals(descriptor, LISTENER_DESCRIPTOR)) {
                this.classVisitor.foundListenerMethods.add(this.discoveredMethod);
                ListenerAnnotation e = new ListenerAnnotation(type, this.discoveredMethod);
                this.discoveredMethod.annotations.add(e);
                this.discoveredMethod.listenerAnnotation = new Listener(this){

                    public Class<? extends Annotation> annotationType() {
                        return Listener.class;
                    }

                    public Order order() {
                        return Order.DEFAULT;
                    }

                    public boolean beforeModifications() {
                        return false;
                    }
                };
                return new ListenerExtractor(this.discoveredMethod);
            }
            if (!type.getClassName().startsWith(ListenerClassVisitor.SPONGE_API_ANNOTATION_PREFIX)) {
                return null;
            }
            ListenerAnnotation e = new ListenerAnnotation(type, this.discoveredMethod);
            this.discoveredMethod.annotations.add(e);
            return new ListenerAnnotationVisitor(e);
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            ListenerAnnotation annotation = this.discoveredMethod.parameters[parameter].addAnnotation(descriptor);
            return new ListenerAnnotationVisitor(annotation);
        }
    }

    public static final class ListenerAnnotation {
        private final org.objectweb.asm.Type type;
        final DiscoveredMethod discoveredMethod;
        private final Map<String, Object> values = new ConcurrentHashMap<String, Object>();
        private final Map<String, Class<?>> returnTypes = new ConcurrentHashMap();
        private @MonotonicNonNull Annotation annotation;

        ListenerAnnotation(org.objectweb.asm.Type type, DiscoveredMethod discoveredMethod) {
            this.type = type;
            this.discoveredMethod = discoveredMethod;
        }

        public org.objectweb.asm.Type type() {
            return this.type;
        }

        public void put(String name, Object value) throws ClassNotFoundException, AnnotationFormatException {
            Class<?> returnType;
            Class<?> realValue = value;
            if (value instanceof org.objectweb.asm.Type) {
                try {
                    realValue = this.discoveredMethod.classByLoader(((org.objectweb.asm.Type)value).getClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if ((returnType = this.returnTypes.get(name)) != null && returnType.isArray()) {
                Object newArray;
                Class<?> componentType = returnType.getComponentType();
                Object previous = this.values.get(name);
                if (previous == null) {
                    newArray = Array.newInstance(componentType, 1);
                    Array.set(newArray, 0, realValue);
                } else {
                    newArray = Array.newInstance(componentType, Array.getLength(previous) + 1);
                    System.arraycopy(previous, 0, newArray, 0, Array.getLength(previous));
                    Array.set(newArray, Array.getLength(previous), realValue);
                }
                this.values.put(name, newArray);
            } else {
                this.values.put(name, realValue);
            }
            this.annotation = TypeFactory.annotation(this.discoveredMethod.classByLoader(this.type.getClassName()), this.values);
        }

        public Annotation annotation() throws ClassNotFoundException, AnnotationFormatException {
            if (this.annotation == null) {
                this.annotation = TypeFactory.annotation(this.discoveredMethod.classByLoader(this.type.getClassName()), this.values);
            }
            return this.annotation;
        }

        public void initReturnTypes() {
            try {
                for (Method element : this.discoveredMethod.classByLoader(this.type.getClassName()).getDeclaredMethods()) {
                    this.returnTypes.put(element.getName(), element.getReturnType());
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Failed to initialize return types", (Throwable)e);
            }
        }
    }

    public static final class ListenerParameter {
        private final DiscoveredMethod method;
        private final org.objectweb.asm.Type type;
        private final List<ListenerAnnotation> annotations;
        public boolean wildcard = false;
        @MonotonicNonNull org.objectweb.asm.Type baseType;
        @MonotonicNonNull org.objectweb.asm.Type genericType;
        @MonotonicNonNull String name;

        ListenerParameter(DiscoveredMethod method, org.objectweb.asm.Type type) {
            this.method = method;
            this.type = type;
            this.annotations = new LinkedList<ListenerAnnotation>();
        }

        public Class<?> clazz() throws ClassNotFoundException {
            return this.method.classByLoader(this.type.getClassName());
        }

        public org.objectweb.asm.Type type() {
            return this.type;
        }

        public ListenerAnnotation addAnnotation(String descriptor) {
            ListenerAnnotation listenerAnnotation = new ListenerAnnotation(org.objectweb.asm.Type.getType((String)descriptor), this.method);
            this.annotations.add(listenerAnnotation);
            return listenerAnnotation;
        }

        public String name() {
            return this.name;
        }

        public List<ListenerAnnotation> annotations() {
            return Collections.unmodifiableList(this.annotations);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListenerParameter that = (ListenerParameter)o;
            return this.method.equals(that.method) && this.type.equals((Object)that.type) && this.annotations.equals(that.annotations);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.type, this.annotations);
        }

        public Type genericType() throws ClassNotFoundException {
            if (this.genericType == null) {
                if (this.wildcard) {
                    return TypeFactory.parameterizedClass(this.clazz(), (Type[])new Type[]{TypeFactory.unboundWildcard()});
                }
                return TypeFactory.parameterizedClass(this.clazz(), (Type[])new Type[0]);
            }
            Class<?> gClazz = this.method.classByLoader(this.genericType.getClassName());
            return TypeFactory.parameterizedClass(this.clazz(), (Type[])new Type[]{gClazz});
        }
    }

    public static final class DiscoveredMethod {
        private final Class<?> declaringClass;
        private final int access;
        private final String methodName;
        private final String descriptor;
        final @Nullable String signature;
        final ListenerParameter[] parameters;
        final List<ListenerAnnotation> annotations;
        @MonotonicNonNull Listener listenerAnnotation;

        public DiscoveredMethod(Class<?> declaringClass, int access, @Nullable String signature, String methodName, String descriptor, ListenerParameter[] parameters) {
            this.declaringClass = declaringClass;
            this.access = access;
            this.methodName = methodName;
            this.signature = signature;
            this.parameters = parameters;
            this.descriptor = descriptor;
            this.annotations = new LinkedList<ListenerAnnotation>();
        }

        public Class<?> declaringClass() {
            return this.declaringClass;
        }

        public Class<?> classByLoader(String className) throws ClassNotFoundException {
            return Class.forName(className, false, this.declaringClass.getClassLoader());
        }

        public Optional<Class<?>> optionalClassByLoader(String className) {
            try {
                return Optional.of(this.classByLoader(className));
            }
            catch (ClassNotFoundException e) {
                return Optional.empty();
            }
        }

        public String methodName() {
            return this.methodName;
        }

        public String descriptor() {
            return this.descriptor;
        }

        public ListenerParameter[] parameterTypes() {
            return this.parameters;
        }

        public List<ListenerAnnotation> annotations() {
            return Collections.unmodifiableList(this.annotations);
        }

        public Listener listener() {
            return this.listenerAnnotation;
        }

        public int access() {
            return this.access;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiscoveredMethod that = (DiscoveredMethod)o;
            return this.access == that.access && this.declaringClass.equals(that.declaringClass) && this.methodName.equals(that.methodName) && this.descriptor.equals(that.descriptor) && Objects.equals(this.signature, that.signature) && Arrays.equals(this.parameters, that.parameters) && this.annotations.equals(that.annotations) && Objects.equals(this.listenerAnnotation, that.listenerAnnotation);
        }

        public int hashCode() {
            return Objects.hash(this.access, this.methodName, this.descriptor, this.signature, this.listenerAnnotation);
        }

        public String toString() {
            return "DiscoveredMethod{declaringClass=" + String.valueOf(this.declaringClass) + ", access=" + this.access + ", methodName='" + this.methodName + "', descriptor='" + this.descriptor + "', signature='" + this.signature + "', parameters=" + Arrays.toString(this.parameters) + ", annotations=" + String.valueOf(this.annotations) + ", listenerAnnotation=" + String.valueOf(this.listenerAnnotation) + "}";
        }
    }

    static final class ListenerExtractor
    extends AnnotationVisitor {
        private final DiscoveredMethod discoveredMethod;

        public ListenerExtractor(DiscoveredMethod discoveredMethod) {
            super(589824);
            this.discoveredMethod = discoveredMethod;
        }

        public void visit(String name, final Object value) {
            if ("beforeModifications".equals(name)) {
                final Listener existing = this.discoveredMethod.listenerAnnotation;
                this.discoveredMethod.listenerAnnotation = new Listener(){

                    public Order order() {
                        return existing.order();
                    }

                    public boolean beforeModifications() {
                        return (Boolean)value;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return Listener.class;
                    }
                };
            }
        }

        public void visitEnum(String name, String descriptor, String value) {
            if ("order".equals(name)) {
                final Order order = Order.valueOf((String)value);
                final Listener existing = this.discoveredMethod.listenerAnnotation;
                this.discoveredMethod.listenerAnnotation = new Listener(){

                    public Order order() {
                        return order;
                    }

                    public boolean beforeModifications() {
                        return existing.beforeModifications();
                    }

                    public Class<? extends Annotation> annotationType() {
                        return Listener.class;
                    }
                };
            }
        }
    }

    static final class ListenerAnnotationVisitor
    extends AnnotationVisitor {
        private final ListenerAnnotation annotation;

        public ListenerAnnotationVisitor(ListenerAnnotation annotation) {
            super(589824);
            this.annotation = annotation;
        }

        public void visit(@Nullable String name, Object value) {
            try {
                this.annotation.put(name == null ? "value" : name, value);
            }
            catch (AnnotationFormatException | ClassNotFoundException e) {
                LOGGER.error("Failed to visit annotation primitive value", e);
            }
        }

        public AnnotationVisitor visitArray(String name) {
            this.annotation.initReturnTypes();
            return this;
        }

        public void visitEnum(String name, String descriptor, String value) {
            try {
                String className = org.objectweb.asm.Type.getType((String)descriptor).getClassName();
                this.visit(name, Enum.valueOf(this.annotation.discoveredMethod.classByLoader(className), value));
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Failed to visit annotation enum value", (Throwable)e);
            }
        }
    }

    static final class ListenerSignatureVisitor
    extends SignatureVisitor {
        private final ListenerParameter parameter;
        private boolean secondType = true;
        private boolean isGeneric = false;

        public ListenerSignatureVisitor(ListenerParameter parameter) {
            super(589824);
            this.parameter = parameter;
        }

        public void visitClassType(String name) {
            if (!this.secondType) {
                return;
            }
            if (this.parameter.baseType == null) {
                this.parameter.baseType = org.objectweb.asm.Type.getType((String)("L" + name + ";"));
                return;
            }
            if (this.isGeneric && this.parameter.genericType == null) {
                this.parameter.genericType = org.objectweb.asm.Type.getType((String)("L" + name + ";"));
            }
            this.secondType = false;
        }

        public void visitTypeArgument() {
            this.parameter.wildcard = true;
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            this.isGeneric = true;
            return this;
        }
    }
}

