/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.Order;
import org.spongepowered.common.event.SpongeEventListener;
import org.spongepowered.common.event.manager.EventType;
import org.spongepowered.plugin.PluginContainer;

public final class RegisteredListener<T extends Event>
implements SpongeEventListener<T>,
Comparable<RegisteredListener<?>> {
    private final PluginContainer plugin;
    private final EventType<T> eventType;
    private final Order order;
    private final EventListener<? super T> listener;
    private final boolean beforeModifications;

    RegisteredListener(PluginContainer plugin, EventType<T> eventType, Order order, EventListener<? super T> listener, boolean beforeModifications) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.eventType = Objects.requireNonNull(eventType, "eventType");
        this.order = Objects.requireNonNull(order, "order");
        this.listener = Objects.requireNonNull(listener, "listener");
        this.beforeModifications = beforeModifications;
    }

    public PluginContainer getPlugin() {
        return this.plugin;
    }

    public EventType<T> getEventType() {
        return this.eventType;
    }

    public Order getOrder() {
        return this.order;
    }

    public boolean isBeforeModifications() {
        return this.beforeModifications;
    }

    @Override
    public Object getHandle() {
        if (this.listener instanceof SpongeEventListener) {
            return ((SpongeEventListener)this.listener).getHandle();
        }
        return this.listener;
    }

    public void handle(T event) throws Exception {
        this.listener.handle(event);
    }

    @Override
    public int compareTo(RegisteredListener<?> handler) {
        return this.order.compareTo((Enum)handler.order);
    }

    public static final class Cache {
        private final List<RegisteredListener<?>> listeners;
        private final List<RegisteredListener<?>> beforeModifications = new ArrayList();
        private final List<RegisteredListener<?>> afterModifications = new ArrayList();
        private final EnumMap<Order, List<RegisteredListener<?>>> listenersByOrder;

        Cache(List<RegisteredListener<?>> listeners) {
            this.listeners = listeners;
            this.listenersByOrder = new EnumMap(Order.class);
            for (RegisteredListener<?> handler : listeners) {
                List list = this.listenersByOrder.computeIfAbsent(handler.getOrder(), order -> new ArrayList());
                list.add(handler);
                if (handler.beforeModifications) {
                    this.beforeModifications.add(handler);
                    continue;
                }
                this.afterModifications.add(handler);
            }
        }

        public List<RegisteredListener<?>> getListeners() {
            return this.listeners;
        }

        public List<RegisteredListener<?>> getListenersByOrder(Order order) {
            List<RegisteredListener<?>> list = this.listenersByOrder.get(Objects.requireNonNull(order, "order"));
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }

        public List<RegisteredListener<?>> beforeModifications() {
            return Collections.unmodifiableList(this.beforeModifications);
        }

        public List<RegisteredListener<?>> afterModifications() {
            return Collections.unmodifiableList(this.afterModifications);
        }
    }
}

