/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.manager;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.leangen.geantyref.GenericTypeReflector;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.EventListenerRegistration;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.event.GenericEvent;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.impl.AbstractEvent;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.inventory.container.ContainerBridge;
import org.spongepowered.common.event.ListenerLookups;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.filter.FilterGenerator;
import org.spongepowered.common.event.manager.AnnotatedEventListener;
import org.spongepowered.common.event.manager.ClassEventListenerFactory;
import org.spongepowered.common.event.manager.EventType;
import org.spongepowered.common.event.manager.ListenerChecker;
import org.spongepowered.common.event.manager.ListenerClassVisitor;
import org.spongepowered.common.event.manager.RegisteredListener;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.EventListenerPhaseContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.util.TypeTokenUtil;
import org.spongepowered.configurate.util.Types;
import org.spongepowered.plugin.PluginContainer;

public abstract class SpongeEventManager
implements EventManager {
    private static final NoExceptionClosable NULL_CLOSABLE = new NoExceptionClosable();
    public final ListenerChecker checker;
    private final Object lock;
    private final Multimap<Class<?>, RegisteredListener<?>> handlersByEvent;
    protected final LoadingCache<EventType<?>, RegisteredListener.Cache> handlersCache = Caffeine.newBuilder().initialCapacity(150).build(this::bakeHandlers);
    private final Set<Object> registeredListeners;

    public SpongeEventManager() {
        this.lock = new Object();
        this.handlersByEvent = HashMultimap.create();
        this.registeredListeners = new ReferenceOpenHashSet();
        this.checker = new ListenerChecker(ShouldFire.class);
    }

    private static @Nullable String getHandlerErrorOrNull(ListenerClassVisitor.DiscoveredMethod method) throws ClassNotFoundException {
        ListenerClassVisitor.ListenerParameter[] parameters;
        int modifiers = method.access();
        ArrayList<String> errors = new ArrayList<String>();
        if (Modifier.isStatic(modifiers)) {
            errors.add("method must not be static");
        }
        if (Modifier.isAbstract(modifiers)) {
            errors.add("method must not be abstract");
        }
        if (method.declaringClass().isInterface()) {
            errors.add("interfaces cannot declare listeners");
        }
        if (!method.descriptor().endsWith("V")) {
            errors.add("method must return void");
        }
        if ((parameters = method.parameterTypes()).length == 0 || !Event.class.isAssignableFrom(parameters[0].clazz())) {
            errors.add("method must have an Event as its first parameter");
        }
        if (errors.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)", ", errors);
    }

    private static <T extends Event> RegisteredListener<T> createRegistration(PluginContainer plugin, Type eventType, Order order, boolean beforeModifications, EventListener<? super T> handler) {
        Type genericType = null;
        Class erased = GenericTypeReflector.erase((Type)eventType);
        if (GenericEvent.class.isAssignableFrom(erased)) {
            genericType = TypeTokenUtil.typeArgumentFromSupertype(eventType, GenericEvent.class, 0);
        }
        return new RegisteredListener<T>(plugin, new EventType(erased, genericType), order, handler, beforeModifications);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends Event> RegisteredListener.Cache bakeHandlers(EventType<T> eventType) {
        ArrayList handlers = new ArrayList();
        Stream<Class> types = Types.allSuperTypesAndInterfaces(eventType.getType()).map(GenericTypeReflector::erase).filter(Event.class::isAssignableFrom);
        Object object = this.lock;
        synchronized (object) {
            Iterator it = types.iterator();
            while (it.hasNext()) {
                Class type = (Class)it.next();
                Collection listeners = this.handlersByEvent.get((Object)type);
                if (GenericEvent.class.isAssignableFrom(type)) {
                    Type genericType = Objects.requireNonNull(eventType.getGenericType());
                    for (RegisteredListener listener : listeners) {
                        Type genericType1 = Objects.requireNonNull(listener.getEventType().getGenericType());
                        if (!TypeTokenUtil.isAssignable(genericType, genericType1)) continue;
                        handlers.add(listener);
                    }
                    continue;
                }
                handlers.addAll(listeners);
            }
        }
        Collections.sort(handlers);
        return new RegisteredListener.Cache(handlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(List<RegisteredListener<? extends Event>> handlers) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            for (RegisteredListener<? extends Event> handler : handlers) {
                Class<? extends Event> raw = handler.getEventType().getType();
                if (!this.handlersByEvent.put(raw, handler)) continue;
                changed = true;
                this.checker.registerListenerFor(raw);
            }
        }
        if (changed) {
            this.handlersCache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(RegisteredListener<? extends Event> handler) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            Class<? extends Event> raw = handler.getEventType().getType();
            if (this.handlersByEvent.put(raw, handler)) {
                changed = true;
                this.checker.registerListenerFor(raw);
            }
        }
        if (changed) {
            this.handlersCache.invalidateAll();
        }
    }

    private void registerListener(PluginContainer plugin, Object listenerObject, @Nullable MethodHandles.Lookup customLookup) {
        String error;
        Objects.requireNonNull(plugin, "plugin");
        Objects.requireNonNull(listenerObject, "listener");
        if (this.registeredListeners.contains(listenerObject)) {
            SpongeCommon.logger().warn("Plugin {} attempted to register an already registered listener ({})", (Object)plugin.metadata().id(), (Object)listenerObject.getClass().getName());
            Thread.dumpStack();
            return;
        }
        ArrayList<RegisteredListener<? extends Event>> handlers = new ArrayList<RegisteredListener<? extends Event>>();
        HashMap<ListenerClassVisitor.DiscoveredMethod, String> methodErrors = new HashMap<ListenerClassVisitor.DiscoveredMethod, String>();
        Class<?> handle = listenerObject.getClass();
        MethodHandles.Lookup lookup = customLookup;
        if (lookup == null && (lookup = ListenerLookups.get(handle)) == null) {
            SpongeCommon.logger().warn("No lookup found for listener {}.", (Object)handle.getName());
            return;
        }
        ClassEventListenerFactory handlerFactory = new ClassEventListenerFactory(FilterGenerator::create);
        try {
            List<ListenerClassVisitor.DiscoveredMethod> methods = ListenerClassVisitor.getEventListenerMethods(handle);
            for (ListenerClassVisitor.DiscoveredMethod method : methods) {
                Listener listener = method.listener();
                error = SpongeEventManager.getHandlerErrorOrNull(method);
                if (error == null) {
                    AnnotatedEventListener handler;
                    Type eventType = method.parameterTypes()[0].genericType();
                    try {
                        handler = handlerFactory.create(listenerObject, method, lookup);
                    }
                    catch (Throwable thr) {
                        SpongeCommon.logger().error("Failed to create handler for {} on {}", (Object)method, handle, (Object)thr);
                        continue;
                    }
                    handlers.add(SpongeEventManager.createRegistration(plugin, eventType, listener.order(), listener.beforeModifications(), handler));
                    continue;
                }
                methodErrors.put(method, error);
            }
        }
        catch (IOException ioe) {
            SpongeCommon.logger().warn("Exception trying to register class listeners", (Throwable)ioe);
        }
        catch (NoSuchMethodException nsme) {
            SpongeCommon.logger().warn("Discovered method listener somehow not found for class " + handle.getName(), (Throwable)nsme);
        }
        catch (ClassNotFoundException e) {
            SpongeCommon.logger().warn("Somehow couldn't classload a class while trying to register event listeners for containing class: " + handle.getName(), (Throwable)e);
        }
        for (Class<?> handleParent = handle; handleParent != Object.class; handleParent = handleParent.getSuperclass()) {
            try {
                List<ListenerClassVisitor.DiscoveredMethod> methods = ListenerClassVisitor.getEventListenerMethods(handleParent);
                for (ListenerClassVisitor.DiscoveredMethod method : methods) {
                    if (methodErrors.containsKey(method) || (error = SpongeEventManager.getHandlerErrorOrNull(method)) == null) continue;
                    methodErrors.put(method, error);
                }
                continue;
            }
            catch (RuntimeException re) {
                if (re.getMessage().startsWith("Attempted to load class")) continue;
                SpongeCommon.logger().warn("Exception trying to register superclass listeners", (Throwable)re);
                continue;
            }
            catch (Exception e) {
                SpongeCommon.logger().warn("Attempted to register listeners but had an exception loading listeners for super classes", (Throwable)e);
            }
        }
        for (Map.Entry method : methodErrors.entrySet()) {
            SpongeCommon.logger().warn("Invalid listener method {} in {}: {}", method.getKey(), (Object)((ListenerClassVisitor.DiscoveredMethod)method.getKey()).declaringClass().getName(), method.getValue());
        }
        this.registeredListeners.add(listenerObject);
        this.register(handlers);
    }

    public <E extends Event> EventManager registerListener(EventListenerRegistration<E> registration) {
        Objects.requireNonNull(registration, "registration");
        RegisteredListener handler = SpongeEventManager.createRegistration(registration.plugin(), registration.eventType(), registration.order(), registration.beforeModifications(), registration.listener());
        this.register(handler);
        return this;
    }

    public SpongeEventManager registerListeners(PluginContainer plugin, Object listener) {
        this.registerListener(plugin, listener, null);
        return this;
    }

    public SpongeEventManager registerListeners(PluginContainer plugin, Object listener, MethodHandles.Lookup lookup) {
        MethodHandles.Lookup usedLookup;
        Objects.requireNonNull(lookup, "lookup");
        try {
            usedLookup = MethodHandles.privateLookupIn(listener.getClass(), lookup);
        }
        catch (IllegalAccessException ex) {
            String errorMessage = "The plugin " + plugin.metadata().id() + " supplied a lookup with insufficient privileges to register listeners";
            throw new IllegalArgumentException(errorMessage, ex);
        }
        this.registerListener(plugin, listener, usedLookup);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(Predicate<RegisteredListener<?>> unregister) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            Iterator itr = this.handlersByEvent.values().iterator();
            while (itr.hasNext()) {
                RegisteredListener handler = (RegisteredListener)itr.next();
                if (!unregister.test(handler)) continue;
                itr.remove();
                changed = true;
                this.checker.unregisterListenerFor(handler.getEventType().getType());
                this.registeredListeners.remove(handler.getHandle());
            }
        }
        if (changed) {
            this.handlersCache.invalidateAll();
        }
    }

    public SpongeEventManager unregisterListeners(Object obj) {
        if (obj instanceof PluginContainer) {
            this.unregister(handler -> obj.equals(handler.getPlugin()));
        } else {
            this.unregister(handler -> Objects.requireNonNull(obj, "obj").equals(handler.getHandle()));
        }
        return this;
    }

    protected RegisteredListener.Cache getHandlerCache(Event event) {
        Class eventClass = Objects.requireNonNull(event, "event").getClass();
        EventType eventType = event instanceof GenericEvent ? new EventType(eventClass, Objects.requireNonNull(((GenericEvent)event).paramType().getType())) : new EventType(eventClass, null);
        return (RegisteredListener.Cache)this.handlersCache.get(eventType);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected final boolean post(Event event, List<RegisteredListener<?>> handlers) {
        for (RegisteredListener<?> handler : handlers) {
            try {
                CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();
                try {
                    @Nullable @NonNull EventListenerPhaseContext context = SpongeEventManager.createListenerContext(handler.getPlugin());
                    try {
                        frame.pushCause((Object)handler.getPlugin());
                        if (context != null) {
                            context.buildAndSwitch();
                        }
                        if (event instanceof AbstractEvent) {
                            ((AbstractEvent)event).currentOrder = handler.getOrder();
                        }
                        handler.handle(event);
                    }
                    finally {
                        if (context == null) continue;
                        ((PhaseContext)context).close();
                    }
                }
                finally {
                    if (frame == null) continue;
                    frame.close();
                }
            }
            catch (Throwable e) {
                SpongeCommon.logger().error("Could not pass {} to {}", (Object)event.getClass().getSimpleName(), (Object)handler.getPlugin().metadata().id(), (Object)e);
            }
        }
        if (event instanceof AbstractEvent) {
            ((AbstractEvent)event).currentOrder = null;
        }
        return event instanceof Cancellable && ((Cancellable)event).isCancelled();
    }

    public static @Nullable EventListenerPhaseContext createListenerContext(@Nullable PluginContainer plugin) {
        if (PhaseTracker.getInstance().getPhaseContext().allowsEventListener()) {
            EventListenerPhaseContext context = PluginPhase.Listener.GENERAL_LISTENER.createPhaseContext(PhaseTracker.getInstance());
            if (plugin != null) {
                context.source(plugin);
            }
            return context;
        }
        return null;
    }

    public boolean post(Event event) {
        try (NoExceptionClosable ignored = this.preparePost(event);){
            boolean bl = this.post(event, this.getHandlerCache(event).getListeners());
            return bl;
        }
    }

    public boolean postToPlugin(Event event, PluginContainer plugin) {
        List<RegisteredListener<?>> listeners = this.getHandlerCache(event).getListeners();
        List<RegisteredListener<?>> pluginListeners = listeners.stream().filter(l -> l.getPlugin() == plugin).collect(Collectors.toList());
        return this.post(event, pluginListeners);
    }

    protected final NoExceptionClosable preparePost(Event event) {
        if (event instanceof InteractContainerEvent) {
            ContainerBridge bridge = (ContainerBridge)((InteractContainerEvent)event).container();
            bridge.bridge$setInUse(true);
            return new ContainerInUseClosable(bridge);
        }
        return NULL_CLOSABLE;
    }

    protected static class NoExceptionClosable
    implements AutoCloseable {
        NoExceptionClosable() {
        }

        @Override
        public void close() {
        }
    }

    protected static final class ContainerInUseClosable
    extends NoExceptionClosable {
        final ContainerBridge containerBridge;

        ContainerInUseClosable(ContainerBridge containerBridge) {
            this.containerBridge = containerBridge;
        }

        @Override
        public void close() {
            this.containerBridge.bridge$setInUse(false);
        }
    }
}

