/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.config.core.SpongeConfigs;
import org.spongepowered.common.event.tracking.EmptyContext;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseStateProxy;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.PooledPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.util.MemoizedSupplier;
import org.spongepowered.common.util.Preconditions;
import org.spongepowered.common.util.PrettyPrinter;

public class PhaseContext<P extends PhaseContext<P>>
implements PhaseStateProxy<P>,
AutoCloseable {
    private static @MonotonicNonNull Supplier<PhaseContext<@NonNull ?>> EMPTY = MemoizedSupplier.memoize(() -> new EmptyContext(new PhaseTracker()).markEmpty());
    protected final PhaseTracker createdTracker;
    private @MonotonicNonNull TransactionalCaptureSupplier transactor;
    protected final IPhaseState<P> state;
    protected boolean isCompleted = false;
    private @Nullable StackTraceElement[] stackTrace;
    protected @Nullable UUID creator;
    protected @Nullable UUID notifier;
    private boolean allowsBlockEvents = true;
    private boolean allowsEntityEvents = true;
    private boolean allowsBulkBlockCaptures = true;
    private boolean allowsBulkEntityCaptures = true;
    @Nullable Deque<// Could not load outer class - annotation placement on inner may be incorrect
    CauseStackManager.StackFrame> usedFrame;
    private @Nullable Object source;

    public static PhaseContext<@NonNull ?> empty() {
        return EMPTY.get();
    }

    public P source(Object owner) {
        Preconditions.checkState(!this.isCompleted, "Cannot add a new object to the context if it's already marked as completed!");
        this.source = owner;
        return (P)this;
    }

    public P creator(Supplier<Optional<UUID>> supplier) {
        supplier.get().ifPresent(this::creator);
        return (P)this;
    }

    public P creator(UUID owner) {
        this.checkNotCompleted();
        if (this.creator != null) {
            throw new IllegalStateException("Owner for this phase context is already set!");
        }
        this.creator = Objects.requireNonNull(owner, "Owner cannot be null!");
        return (P)this;
    }

    public P notifier(Supplier<Optional<UUID>> supplier) {
        supplier.get().ifPresent(this::notifier);
        return (P)this;
    }

    public P notifier(UUID notifier) {
        this.checkNotCompleted();
        if (this.notifier != null) {
            throw new IllegalStateException("Notifier for this phase context is already set!");
        }
        this.notifier = Objects.requireNonNull(notifier, "Notifier cannot be null!");
        return (P)this;
    }

    public P setBulkBlockCaptures(boolean captures) {
        this.allowsBulkBlockCaptures = captures;
        return (P)this;
    }

    public boolean allowsBulkBlockCaptures() {
        return this.allowsBulkBlockCaptures;
    }

    public P setBlockEvents(boolean events) {
        this.allowsBlockEvents = events;
        return (P)this;
    }

    public boolean allowsBlockEvents() {
        return this.allowsBlockEvents;
    }

    protected P setEntitySpawnEvents(boolean b) {
        this.allowsEntityEvents = b;
        return (P)this;
    }

    public boolean allowsEntityEvents() {
        return this.allowsEntityEvents;
    }

    protected P setBulkEntityCaptures(boolean b) {
        this.allowsBulkEntityCaptures = b;
        return (P)this;
    }

    public boolean allowsBulkEntityCaptures() {
        return this.allowsBulkEntityCaptures;
    }

    public P buildAndSwitch() {
        this.isCompleted = true;
        if (SpongeConfigs.getCommon().get().phaseTracker.generateStackTracePerPhase) {
            this.stackTrace = new Exception("Debug Trace").getStackTrace();
        }
        this.createdTracker.switchToPhase(this.state, this);
        return (P)this;
    }

    public boolean isComplete() {
        return this.isCompleted;
    }

    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        if (this.stackTrace != null) {
            printer.add(s + "StackTrace On Entry").add(this.stackTrace);
        }
        if (this.creator != null) {
            printer.add(s + "- %s: %s", "Owner", this.creator);
        }
        if (this.source != null) {
            printer.add(s + "- %s: %s", "Source", this.source);
        }
        if (this.transactor != null && !this.transactor.isEmpty()) {
            printer.add(s + "- %s: %s", "CapturedTransactions", this.transactor);
        }
        return printer;
    }

    public boolean notAllCapturesProcessed() {
        return false;
    }

    public <T> Optional<T> getSource(Class<T> sourceClass) {
        if (this.source == null) {
            return Optional.empty();
        }
        if (sourceClass.isInstance(this.source)) {
            return Optional.of(this.source);
        }
        return Optional.empty();
    }

    public @Nullable Object getSource() {
        return this.source;
    }

    public <T> T requireSource(Class<T> targetClass) {
        return this.getSource(targetClass).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", this));
    }

    public Optional<UUID> getCreator() {
        return Optional.ofNullable(this.creator);
    }

    public boolean applyOwnerIfAvailable(Consumer<? super UUID> consumer) {
        if (this.creator != null) {
            consumer.accept(this.creator);
            return true;
        }
        return false;
    }

    public Optional<UUID> getNotifier() {
        return Optional.ofNullable(this.notifier);
    }

    public boolean applyNotifierIfAvailable(Consumer<? super UUID> consumer) {
        if (this.notifier != null) {
            consumer.accept(this.notifier);
            return true;
        }
        return false;
    }

    public TransactionalCaptureSupplier getTransactor() {
        if (this.transactor == null) {
            this.transactor = new TransactionalCaptureSupplier(this);
        }
        return this.transactor;
    }

    public boolean hasCaptures() {
        return this.transactor != null && !this.transactor.isEmpty();
    }

    public void addCreatorAndNotifierToCauseStack(CauseStackManager.StackFrame frame) {
        if (this.creator != null) {
            frame.addContext(EventContextKeys.CREATOR, (Object)this.creator);
        }
        if (this.notifier != null) {
            frame.addContext(EventContextKeys.NOTIFIER, (Object)this.notifier);
        }
    }

    protected PhaseContext(IPhaseState<P> state, PhaseTracker tracker) {
        this.state = state;
        this.createdTracker = Objects.requireNonNull(tracker, "Null PhaseTracker!");
    }

    public int hashCode() {
        return Objects.hash(this.isCompleted);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PhaseContext other = (PhaseContext)obj;
        return Objects.equals(this.isCompleted, other.isCompleted);
    }

    public String toString() {
        return new StringJoiner(", ", PhaseContext.class.getSimpleName() + "[", "]").add("isCompleted=" + this.isCompleted).toString();
    }

    protected P markEmpty() {
        this.isCompleted = true;
        return (P)this;
    }

    public boolean isEmpty() {
        return this == EMPTY.get();
    }

    @Override
    public void close() {
        if (this.isEmpty()) {
            PhasePrinter.printMessageWithCaughtException(this.createdTracker.stack, "Closing an empty Phasecontext", "We should never be closing an empty phase context (or complete phase) This is likely an error from sponge.", this.state, this, (Throwable)new IllegalStateException("Closing empty phase context"));
            return;
        }
        this.createdTracker.completePhase(this);
        if (this.usedFrame != null) {
            this.usedFrame.iterator().forEachRemaining(this.createdTracker::popCauseFrame);
            this.usedFrame = null;
        } else if (this.shouldProvideModifiers()) {
            this.createdTracker.popFrameMutator(this);
        }
        this.reset();
        this.isCompleted = false;
        if (this.state instanceof PooledPhaseState) {
            ((PooledPhaseState)this.state).releaseContextFromPool(this);
        }
    }

    protected void reset() {
        this.source = null;
        this.stackTrace = null;
        this.creator = null;
        this.notifier = null;
        if (this.transactor != null) {
            this.transactor.reset();
        }
    }

    public void printTrace(PrettyPrinter printer) {
        if (SpongeConfigs.getCommon().get().phaseTracker.generateStackTracePerPhase) {
            printer.add("Entrypoint:").add(this.stackTrace);
        }
    }

    public @Nullable UUID getActiveUserUUID() {
        if (this.notifier != null) {
            return this.notifier;
        }
        if (this.creator != null) {
            return this.creator;
        }
        if (this.source != null && this.source instanceof ServerPlayer) {
            return ((ServerPlayer)this.source).uniqueId();
        }
        return null;
    }

    public boolean isClientSide() {
        return false;
    }

    public Optional<ServerLocation> containerLocation() {
        return Optional.empty();
    }

    protected boolean isRunaway(PhaseContext<?> phaseContext) {
        return phaseContext.getClass() == this.getClass();
    }

    protected P defensiveCopy(PhaseTracker tracker) {
        Object newCopy = this.state instanceof PooledPhaseState ? ((PooledPhaseState)this.state).createNewContext(tracker) : this.state.createPhaseContext(tracker);
        ((PhaseContext)newCopy).source(this.source);
        return (P)newCopy;
    }

    private void checkNotCompleted() {
        if (this.isCompleted) {
            throw new IllegalStateException("Cannot add a new object to the context if it's already marked as completed!");
        }
    }

    @Override
    public IPhaseState<P> getState() {
        return this.state;
    }

    @Override
    public P asContext() {
        return (P)this;
    }
}

