/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.util.Preconditions;

final class PhaseStack {
    private static final int DEFAULT_QUEUE_SIZE = 16;
    private final Deque<PhaseContext<?>> phases;

    PhaseStack() {
        this(16);
    }

    private PhaseStack(int size) {
        this.phases = new ArrayDeque(size);
    }

    PhaseContext<?> peek() {
        PhaseContext<?> phase = this.phases.peek();
        return phase == null ? PhaseContext.empty() : phase;
    }

    IPhaseState<?> peekState() {
        PhaseContext<?> peek = this.phases.peek();
        return peek == null ? GeneralPhase.State.COMPLETE : peek.state;
    }

    PhaseContext<?> peekContext() {
        PhaseContext<?> peek = this.phases.peek();
        return peek == null ? PhaseContext.empty() : peek;
    }

    PhaseContext<?> pop() {
        return this.phases.pop();
    }

    PhaseStack push(IPhaseState<?> state, PhaseContext<?> context) {
        Objects.requireNonNull(context, "Tuple cannot be null!");
        Preconditions.checkArgument(context.state == state, () -> String.format("Illegal IPhaseState not matching PhaseContext: %s", context));
        Preconditions.checkArgument(context.isComplete(), () -> String.format("Phase context must be complete: %s", context));
        this.phases.push(context);
        return this;
    }

    public void forEach(Consumer<PhaseContext<?>> consumer) {
        this.phases.forEach(consumer);
    }

    public boolean isEmpty() {
        return this.phases.isEmpty();
    }

    public int size() {
        return this.phases.size();
    }

    public int hashCode() {
        return Objects.hash(this.phases);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PhaseStack other = (PhaseStack)obj;
        return Objects.equals(this.phases, other.phases);
    }

    public String toString() {
        return new StringJoiner(", ", PhaseStack.class.getSimpleName() + "[", "]").add("phases=" + String.valueOf(this.phases)).toString();
    }

    boolean checkForRunaways(IPhaseState<?> state, @Nullable PhaseContext<?> phaseContext) {
        int totalCount = this.phases.size();
        if (totalCount < 2) {
            return false;
        }
        Object[] allContexts = this.phases.toArray();
        for (int index = 0; index < allContexts.length; ++index) {
            if (index >= allContexts.length - 1) continue;
            PhaseContext latestContext = (PhaseContext)allContexts[index];
            IPhaseState latestState = latestContext.state;
            if (latestState != state || latestState != ((PhaseContext)allContexts[index + 1]).state || phaseContext != null && !latestContext.isRunaway(phaseContext)) continue;
            return true;
        }
        return false;
    }
}

