/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1919;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.TickBlockEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.inventory.ViewableInventoryBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.phase.tick.BlockEventTickContext;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.event.tracking.phase.tick.FluidTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;
import org.spongepowered.common.util.Preconditions;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;

public final class TrackingUtil {
    public static final Marker ENTITY_TICK = MarkerManager.getMarker((String)"ENTITY TICK");
    public static final Marker BLOCK_ENTITY_TICK = MarkerManager.getMarker((String)"TILE ENTITY TICK");
    public static final Marker PLAYER_TICK = MarkerManager.getMarker((String)"PLAYER TICK");
    public static final Marker BLOCK_TICK = MarkerManager.getMarker((String)"BLOCK TICK");
    public static final Marker FLUID_TICK = MarkerManager.getMarker((String)"FLUID TICK");
    public static final int WIDTH = 40;

    public static void tickEntity(class_1297 entity, Runnable tick) {
        Preconditions.checkArgument(entity instanceof Entity, () -> String.format("Entity %s is not an instance of SpongeAPI's Entity!", entity));
        Objects.requireNonNull(entity, "Cannot capture on a null ticking entity!");
        if (!((TrackableBridge)entity).bridge$shouldTick()) {
            return;
        }
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance((class_3218)entity.method_37908());
        EntityTickContext tickContext = TickPhase.Tick.ENTITY.createPhaseContext(phaseTracker).source(entity);
        try (EntityTickContext context = tickContext;){
            if (entity instanceof CreatorTrackedBridge) {
                CreatorTrackedBridge ctb = (CreatorTrackedBridge)entity;
                ctb.tracker$getNotifierUUID().ifPresent(context::notifier);
                ctb.tracker$getCreatorUUID().ifPresent(context::creator);
            }
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(ENTITY_TICK, () -> "Wrapping Entity Tick: " + entity.toString());
            tick.run();
            if (ShouldFire.MOVE_ENTITY_EVENT) {
                SpongeCommonEventFactory.callNaturalMoveEntityEvent(entity);
            }
            if (ShouldFire.ROTATE_ENTITY_EVENT) {
                SpongeCommonEventFactory.callNaturalRotateEntityEvent(entity);
            }
        }
        catch (Exception e) {
            PhasePrinter.printExceptionFromPhase(phaseTracker.stack, e, tickContext);
        }
    }

    public static void tickTileEntity(class_2586 blockEntity, Runnable tick) {
        Objects.requireNonNull(blockEntity, "Cannot capture on a null ticking tile entity!");
        if (!((BlockEntity)blockEntity).isTicking()) {
            return;
        }
        if (!((TrackableBridge)blockEntity).bridge$shouldTick()) {
            return;
        }
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance((class_3218)blockEntity.method_10997());
        TileEntityTickContext context = TickPhase.Tick.TILE_ENTITY.createPhaseContext(phaseTracker).source(blockEntity);
        try (TileEntityTickContext phaseContext = context;){
            ViewableInventoryBridge vib;
            Set<class_3222> players;
            if (blockEntity instanceof CreatorTrackedBridge) {
                CreatorTrackedBridge ctb = (CreatorTrackedBridge)blockEntity;
                ctb.tracker$getNotifierUUID().ifPresent(phaseContext::notifier);
                ctb.tracker$getCreatorUUID().ifPresent(phaseContext::creator);
            }
            phaseContext.buildAndSwitch();
            PhaseTracker.LOGGER.trace(BLOCK_ENTITY_TICK, () -> "Wrapping Entity Tick: " + String.valueOf(blockEntity));
            tick.run();
            if (blockEntity instanceof ViewableInventoryBridge && !(players = (vib = (ViewableInventoryBridge)blockEntity).viewableBridge$getViewers()).isEmpty()) {
                players.forEach(player -> player.field_7512.method_7623());
            }
        }
        catch (Exception e) {
            PhasePrinter.printExceptionFromPhase(phaseTracker.stack, e, context);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void updateTickBlock(TrackedWorldBridge mixinWorld, class_2680 block, class_2338 pos, Runnable tick) {
        class_3218 world = (class_3218)mixinWorld;
        ServerWorld apiWorld = (ServerWorld)world;
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance(world);
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot snapshot = mixinWorld.bridge$createSnapshot(block, pos, BlockChangeFlags.NONE);
            TickBlockEvent.Scheduled event = SpongeEventFactory.createTickBlockEventScheduled((Cause)phaseTracker.currentCause(), (BlockSnapshot)snapshot);
            SpongeCommon.post((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.method_10263(), pos.method_10264(), pos.method_10260()).state((BlockState)block).build();
        BlockTickContext phaseContext = TickPhase.Tick.BLOCK.createPhaseContext(phaseTracker).source(locatable);
        PhaseContext<@NonNull BlockTickContext> currentContext = phaseTracker.getPhaseContext();
        currentContext.appendNotifierPreBlockTick(world, pos, phaseContext);
        try (@NonNull BlockTickContext context = phaseContext;){
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(BLOCK_TICK, () -> "Wrapping Block Tick: " + block.toString());
            tick.run();
        }
        catch (Exception | NoClassDefFoundError e) {
            PhasePrinter.printExceptionFromPhase(phaseTracker.stack, e, phaseContext);
        }
    }

    public static void updateTickFluid(TrackedWorldBridge mixinWorld, class_3610 fluidState, class_2338 pos, class_2680 blockState, Runnable tick) {
        class_3218 world = (class_3218)mixinWorld;
        ServerWorld apiWorld = (ServerWorld)world;
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance(world);
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot snapshot = mixinWorld.bridge$createSnapshot(blockState, pos, BlockChangeFlags.NONE);
            TickBlockEvent.Scheduled event = SpongeEventFactory.createTickBlockEventScheduled((Cause)phaseTracker.currentCause(), (BlockSnapshot)snapshot);
            SpongeCommon.post((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.method_10263(), pos.method_10264(), pos.method_10260()).state((BlockState)blockState).build();
        FluidTickContext phaseContext = TickPhase.Tick.FLUID.createPhaseContext(phaseTracker).source(locatable).fluid(fluidState);
        PhaseContext<@NonNull FluidTickContext> currentContext = phaseTracker.getPhaseContext();
        currentContext.appendNotifierPreBlockTick(world, pos, phaseContext);
        try (FluidTickContext context = phaseContext;){
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(FLUID_TICK, () -> "Wrapping Fluid Tick: " + fluidState.toString());
            tick.run();
        }
        catch (Exception | NoClassDefFoundError e) {
            PhasePrinter.printExceptionFromPhase(phaseTracker.stack, e, phaseContext);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void randomTickBlock(TrackedWorldBridge mixinWorld, class_2680 state, class_2338 pos, class_5819 random, Runnable tick) {
        class_3218 world = (class_3218)mixinWorld;
        ServerWorld apiWorld = (ServerWorld)world;
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance(world);
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot currentTickBlock = mixinWorld.bridge$createSnapshot(state, pos, BlockChangeFlags.NONE);
            TickBlockEvent.Random event = SpongeEventFactory.createTickBlockEventRandom((Cause)phaseTracker.currentCause(), (BlockSnapshot)currentTickBlock);
            SpongeCommon.post((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.method_10263(), pos.method_10264(), pos.method_10260()).state((BlockState)state).build();
        BlockTickContext phaseContext = TickPhase.Tick.RANDOM_BLOCK.createPhaseContext(phaseTracker).source(locatable);
        PhaseContext<@NonNull BlockTickContext> currentContext = phaseTracker.getPhaseContext();
        currentContext.appendNotifierPreBlockTick(world, pos, phaseContext);
        try (@NonNull BlockTickContext context = phaseContext;){
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(BLOCK_TICK, "Wrapping Random Block Tick: {}", (Object)state);
            tick.run();
        }
        catch (Exception | NoClassDefFoundError e) {
            PhasePrinter.printExceptionFromPhase(phaseTracker.stack, e, phaseContext);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void randomTickFluid(TrackedWorldBridge mixinWorld, class_3610 state, class_2338 pos, class_5819 random, Runnable tick) {
        class_3218 world = (class_3218)mixinWorld;
        ServerWorld apiWorld = (ServerWorld)world;
        PhaseTracker phaseTracker = PhaseTracker.getWorldInstance(world);
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot currentTickBlock = mixinWorld.bridge$createSnapshot(state.method_15759(), pos, BlockChangeFlags.NONE);
            TickBlockEvent.Random event = SpongeEventFactory.createTickBlockEventRandom((Cause)phaseTracker.currentCause(), (BlockSnapshot)currentTickBlock);
            SpongeCommon.post((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.method_10263(), pos.method_10264(), pos.method_10260()).state((BlockState)state.method_15759()).build();
        FluidTickContext phaseContext = TickPhase.Tick.RANDOM_FLUID.createPhaseContext(phaseTracker).source(locatable).fluid(state);
        PhaseContext<@NonNull FluidTickContext> currentContext = phaseTracker.getPhaseContext();
        currentContext.appendNotifierPreBlockTick(world, pos, phaseContext);
        try (@NonNull FluidTickContext context = phaseContext;){
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(FLUID_TICK, () -> "Wrapping Random Fluid Tick: " + state.toString());
            tick.run();
        }
        catch (Exception | NoClassDefFoundError e) {
            PhasePrinter.printExceptionFromPhase(phaseTracker.stack, e, phaseContext);
        }
    }

    public static boolean fireMinecraftBlockEvent(class_3218 worldIn, class_1919 event, BooleanSupplier tick) {
        BlockEntity source;
        TrackableBlockEventDataBridge blockEvent = (TrackableBlockEventDataBridge)event;
        Object object = source = blockEvent.bridge$getTileEntity() != null ? blockEvent.bridge$getTileEntity() : blockEvent.bridge$getTickingLocatable();
        if (source == null) {
            return tick.getAsBoolean();
        }
        BlockEventTickContext phaseContext = TickPhase.Tick.BLOCK_EVENT.createPhaseContext(PhaseTracker.getWorldInstance(worldIn));
        phaseContext.source(source);
        UUID user = ((TrackableBlockEventDataBridge)event).bridge$getSourceUserUUID();
        if (user != null) {
            phaseContext.creator = user;
            phaseContext.notifier = user;
        }
        boolean result = true;
        try (BlockEventTickContext o = phaseContext;){
            o.buildAndSwitch();
            phaseContext.setEventSucceeded(tick.getAsBoolean());
            result = phaseContext.wasNotCancelled();
        }
        return result;
    }

    private TrackingUtil() {
    }

    public static @Nullable UUID getNotifierOrOwnerFromBlock(class_3218 world, class_2338 blockPos) {
        LevelChunkBridge mixinChunk = (LevelChunkBridge)world.method_8500(blockPos);
        UUID notifier = mixinChunk.bridge$getBlockNotifierUUID(blockPos).orElse(null);
        if (notifier != null) {
            return notifier;
        }
        return mixinChunk.bridge$getBlockCreatorUUID(blockPos).orElse(null);
    }

    public static Supplier<IllegalStateException> throwWithContext(String s, PhaseContext<?> phaseContext) {
        return () -> {
            PrettyPrinter printer = new PrettyPrinter(60);
            printer.add("Exception trying to process over a phase!").centre().hr();
            printer.addWrapped(40, "%s : %s", "State", phaseContext.state);
            printer.addWrapped(40, "%s :", "PhaseContext");
            PhasePrinter.CONTEXT_PRINTER.accept(printer, phaseContext);
            printer.add("Stacktrace:");
            IllegalStateException exception = new IllegalStateException(s + " Please analyze the current phase context. ");
            printer.add(exception);
            printer.trace(System.err, SpongeCommon.logger(), Level.ERROR);
            return exception;
        };
    }

    public static boolean processBlockCaptures(PhaseContext<@NonNull ?> context) {
        TransactionalCaptureSupplier transactor = context.getTransactor();
        if (transactor.isEmpty()) {
            return false;
        }
        return transactor.processTransactions(context);
    }

    public static void associateTrackerToTarget(BlockChange blockChange, BlockTransactionReceipt receipt, UUID uuid) {
        BlockSnapshot finalSnapshot = receipt.finalBlock();
        SpongeBlockSnapshot spongeSnapshot = (SpongeBlockSnapshot)finalSnapshot;
        class_2338 pos = spongeSnapshot.getBlockPos();
        class_2248 block = ((class_2680)spongeSnapshot.state()).method_26204();
        spongeSnapshot.getServerWorld().map(world -> world.method_8500(pos)).map(chunk -> (LevelChunkBridge)chunk).ifPresent(spongeChunk -> {
            PlayerTracker.Type trackerType = blockChange == BlockChange.PLACE ? PlayerTracker.Type.CREATOR : PlayerTracker.Type.NOTIFIER;
            spongeChunk.bridge$addTrackedBlockPosition(block, pos, uuid, trackerType);
        });
    }

    public static void setCreatorReference(List<Entity> entities, class_3222 player) {
        for (Entity currentEntity : entities) {
            if (currentEntity instanceof CreatorTrackedBridge) {
                ((CreatorTrackedBridge)currentEntity).tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, ((ServerPlayer)player).uniqueId());
                continue;
            }
            currentEntity.offer(Keys.CREATOR, (Object)player.method_5667());
        }
    }

    public static void addTileEntityToBuilder(class_2586 existing, SpongeBlockSnapshot.BuilderImpl builder) {
        try {
            class_2487 compound = existing.method_38242((class_7225.class_7874)existing.method_10997().method_30349());
            builder.addUnsafeCompound(compound);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String phaseStateToString(String type, IPhaseState<?> state) {
        return TrackingUtil.phaseStateToString(type, null, state);
    }

    public static String phaseStateToString(String type, @Nullable String extra, IPhaseState<?> state) {
        String name = state.getClass().getSimpleName();
        name = name.replace("Phase", "");
        name = name.replace("State", "");
        name = name.replace(type, "");
        if (extra == null) {
            return type + "{" + name + "}";
        }
        if (name.isEmpty()) {
            return type + "{" + extra + "}";
        }
        return type + "{" + name + ":" + extra + "}";
    }

    public static SpongeBlockSnapshot createPooledSnapshot(class_2680 state, class_2338 pos, BlockChangeFlag updateFlag, int limit, @Nullable class_2586 blockEntity, Supplier<class_3218> worldSupplier, Supplier<Optional<UUID>> creatorSupplier, Supplier<Optional<UUID>> notifierSupplier) {
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled();
        builder.reset();
        builder.blockState(state).world(worldSupplier.get()).position(VecHelper.toVector3i(pos));
        creatorSupplier.get().ifPresent(builder::creator);
        notifierSupplier.get().ifPresent(builder::notifier);
        if (blockEntity != null) {
            TrackingUtil.addTileEntityToBuilder(blockEntity, builder);
        }
        builder.flag(updateFlag);
        return builder.build();
    }
}

