/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;

final class DeepIterator
implements Iterator<GameTransaction<?>> {
    private GameTransaction<@NonNull ?> parent;
    private Iterator<GameTransaction<@NonNull ?>> child;
    private @Nullable GameTransaction<@NonNull ?> next;

    DeepIterator(GameTransaction<@NonNull ?> pointer) {
        this.parent = pointer;
        this.child = pointer.childIterator();
        this.next = pointer;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.child.hasNext()) {
            this.next = this.child.next();
            return true;
        }
        if (this.parent.next != null) {
            GameTransaction<@NonNull ?> next = this.parent.next;
            this.parent = next;
            this.child = next.childIterator();
            this.next = next;
            return true;
        }
        return false;
    }

    @Override
    public GameTransaction<@NonNull ?> next() {
        if (this.next != null) {
            GameTransaction<@NonNull ?> next = this.next;
            this.next = null;
            return next;
        }
        if (this.hasNext()) {
            return this.next();
        }
        throw new NoSuchElementException("No GameTransaction left to go to");
    }
}

