/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_6760;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.scheduler.ScheduledUpdate;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.UnwindingPhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.StatefulTransaction;
import org.spongepowered.common.event.tracking.context.transaction.WrapperTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.AddBlockEventTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.AddTileEntity;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.block.NeighborNotification;
import org.spongepowered.common.event.tracking.context.transaction.block.PrepareBlockDropsTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.RemoveBlockEntity;
import org.spongepowered.common.event.tracking.context.transaction.block.ReplaceBlockEntity;
import org.spongepowered.common.event.tracking.context.transaction.block.ScheduleUpdateTransaction;
import org.spongepowered.common.event.tracking.context.transaction.effect.BlockAddedEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.EntityPerformingDropsEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.InventoryEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.PrepareBlockDrops;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ClickCreativeMenuTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ClickMenuTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.CloseMenuTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerSlotTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.CraftingPreviewTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.CraftingTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.DropFromPlayerInventoryTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ExplicitInventoryOmittedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.InventoryTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.OpenMenuTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlaceRecipeTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.SelectTradeTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.SetCarriedItemTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.SetPlayerContainerTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ShiftCraftingResultTransaction;
import org.spongepowered.common.event.tracking.context.transaction.world.EntityPerformingDropsTransaction;
import org.spongepowered.common.event.tracking.context.transaction.world.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.volume.VolumeStreamUtils;

interface TransactionSink {
    @Deprecated
    public void logTransaction(StatefulTransaction var1);

    public EffectTransactor pushEffect(ResultingTransactionBySideEffect var1);

    default public ChangeBlock logBlockChange(SpongeBlockSnapshot originalBlockSnapshot, class_2680 newState, BlockChangeFlag flags) {
        ChangeBlock changeBlock = new ChangeBlock(originalBlockSnapshot, newState, (SpongeBlockChangeFlag)flags);
        this.logTransaction(changeBlock);
        return changeBlock;
    }

    default public void logBlockEvent(class_2680 state, TrackedWorldBridge serverWorld, class_2338 pos, TrackableBlockEventDataBridge blockEvent) {
        WeakReference<class_3218> worldRef = new WeakReference<class_3218>((class_3218)serverWorld);
        Supplier<class_3218> worldSupplier = () -> Objects.requireNonNull((class_3218)worldRef.get(), "ServerWorld dereferenced");
        @Nullable class_2586 tileEntity = ((class_3218)serverWorld).method_8321(pos);
        SpongeBlockSnapshot original = TrackingUtil.createPooledSnapshot(state, pos, BlockChangeFlags.NONE, 512, tileEntity, worldSupplier, Optional::empty, Optional::empty);
        original.blockChange = BlockChange.MODIFY;
        AddBlockEventTransaction transaction = new AddBlockEventTransaction(original, blockEvent);
        this.logTransaction(transaction);
    }

    default public @Nullable EffectTransactor logBlockDrops(class_1937 serverWorld, class_2338 pos, class_2680 state, @Nullable class_2586 tileEntity) {
        WeakReference<class_3218> worldRef = new WeakReference<class_3218>((class_3218)serverWorld);
        Supplier<class_3218> worldSupplier = () -> Objects.requireNonNull((class_3218)worldRef.get(), "ServerWorld dereferenced");
        SpongeBlockSnapshot original = TrackingUtil.createPooledSnapshot(state, pos, BlockChangeFlags.NONE, 512, tileEntity, worldSupplier, Optional::empty, Optional::empty);
        original.blockChange = BlockChange.MODIFY;
        PrepareBlockDropsTransaction transaction = new PrepareBlockDropsTransaction(pos, state, original);
        this.logTransaction(transaction);
        if (transaction.recorded()) {
            return this.pushEffect(new ResultingTransactionBySideEffect(PrepareBlockDrops.getInstance()));
        }
        return null;
    }

    default public <T> void logScheduledUpdate(class_3218 serverWorld, class_6760<T> data) {
        WeakReference<class_3218> worldRef = new WeakReference<class_3218>(serverWorld);
        WeakReference dataRef = new WeakReference(data);
        Supplier<class_3218> worldSupplier = () -> Objects.requireNonNull((class_3218)worldRef.get(), "ServerWorld dereferenced");
        Supplier dataSupplier = () -> Objects.requireNonNull((class_6760)dataRef.get(), "Data dereferenced");
        ScheduledUpdate spongeData = (ScheduledUpdate)data;
        ScheduleUpdateTransaction<Object> transaction = new ScheduleUpdateTransaction<Object>(worldSupplier, dataSupplier, data.comp_253(), data.comp_252(), spongeData.delay(), spongeData.priority());
        this.logTransaction(transaction);
    }

    default public void logNeighborNotification(Supplier<class_3218> serverWorldSupplier, class_2338 immutableFrom, class_2248 blockIn, class_2338 immutableTarget, class_2680 targetBlockState, @Nullable class_2586 existingTile) {
        NeighborNotification notificationTransaction = new NeighborNotification(serverWorldSupplier, targetBlockState, immutableTarget, blockIn, immutableFrom, existingTile);
        this.logTransaction(notificationTransaction);
    }

    default public void logEntitySpawn(PhaseContext<@NonNull ?> current, TrackedWorldBridge serverWorld, class_1297 entityIn) {
        WeakReference<class_3218> worldRef = new WeakReference<class_3218>((class_3218)serverWorld);
        Supplier<class_3218> worldSupplier = () -> Objects.requireNonNull((class_3218)worldRef.get(), "ServerWorld dereferenced");
        Supplier<SpawnType> contextualType = current.getSpawnTypeForTransaction(entityIn);
        SpawnEntityTransaction transaction = new SpawnEntityTransaction(worldSupplier, entityIn, contextualType);
        this.logTransaction(transaction);
    }

    default public WrapperTransaction logWrapper() {
        WrapperTransaction transaction = new WrapperTransaction();
        this.logTransaction(transaction);
        this.pushEffect(new ResultingTransactionBySideEffect(BlockAddedEffect.getInstance()));
        return transaction;
    }

    default public boolean logTileReplacement(class_2338 pos, @Nullable class_2586 existing, @Nullable class_2586 proposed, Supplier<class_3218> worldSupplier) {
        if (proposed == null) {
            return false;
        }
        this.logTransaction(new ReplaceBlockEntity(pos, existing, proposed, worldSupplier));
        return true;
    }

    default public boolean logTileAddition(class_2586 tileEntity, Supplier<class_3218> worldSupplier, class_2818 chunk) {
        this.logTransaction(this.createTileAdditionTransaction(tileEntity, worldSupplier, chunk));
        return true;
    }

    default public AddTileEntity createTileAdditionTransaction(class_2586 tileentity, Supplier<class_3218> worldSupplier, class_2818 chunk) {
        Supplier<class_2818> weaklyReferencedSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(chunk, "LevelChunk");
        return new AddTileEntity(tileentity, worldSupplier, weaklyReferencedSupplier);
    }

    default public boolean logTileRemoval(@Nullable class_2586 tileentity, Supplier<class_3218> worldSupplier) {
        if (tileentity == null) {
            return false;
        }
        this.logTransaction(new RemoveBlockEntity(tileentity, worldSupplier));
        return true;
    }

    default public @Nullable EffectTransactor ensureEntityDropTransactionEffect(class_1297 entity) {
        EntityPerformingDropsTransaction transaction = new EntityPerformingDropsTransaction(entity);
        this.logTransaction(transaction);
        if (transaction.recorded()) {
            return this.pushEffect(new ResultingTransactionBySideEffect(EntityPerformingDropsEffect.getInstance()));
        }
        return null;
    }

    default public void logSlotTransaction(PhaseContext<@NonNull ?> phaseContext, SlotTransaction newTransaction, class_1703 abstractContainerMenu) {
        if (abstractContainerMenu instanceof class_1723) {
            if (phaseContext instanceof UnwindingPhaseContext) {
                return;
            }
            if (phaseContext instanceof EntityTickContext) {
                SpongeCommon.logger().warn("Ignoring slot transaction on InventoryMenu during {}. {}\nNo Event will be fired for this", (Object)phaseContext.getClass().getSimpleName(), (Object)newTransaction);
                return;
            }
        }
        ContainerSlotTransaction transaction = new ContainerSlotTransaction(abstractContainerMenu, newTransaction);
        this.logTransaction(transaction);
    }

    default public void logPlayerCarriedItem(class_1657 player, int newSlot) {
        SetCarriedItemTransaction transaction = new SetCarriedItemTransaction(player, newSlot);
        this.logTransaction(transaction);
    }

    default public void logPlayerInventoryChange(class_1657 player, PlayerInventoryTransaction.EventCreator eventCreator) {
        PlayerInventoryTransaction transaction = new PlayerInventoryTransaction(player, eventCreator);
        this.logTransaction(transaction);
    }

    default public EffectTransactor logClickContainer(class_1703 menu, int slotNum, int buttonNum, class_1713 clickType, class_1657 player) {
        Slot slot = null;
        if (buttonNum >= 0) {
            slot = ((InventoryAdapter)menu).inventoryAdapter$getSlot(slotNum).orElse(null);
        }
        ClickMenuTransaction transaction = new ClickMenuTransaction(player, menu, slotNum, buttonNum, clickType, slot, ItemStackUtil.snapshotOf(player.field_7512.method_34255()));
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logPlayerInventoryChangeWithEffect(class_1657 player, PlayerInventoryTransaction.EventCreator eventCreator) {
        PlayerInventoryTransaction transaction = new PlayerInventoryTransaction(player, eventCreator);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logCreativeClickContainer(int slotNum, ItemStackSnapshot creativeStack, class_1657 player) {
        ClickCreativeMenuTransaction transaction = new ClickCreativeMenuTransaction(player, slotNum, creativeStack);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logDropFromPlayerInventory(class_3222 player, boolean dropAll) {
        DropFromPlayerInventoryTransaction transaction = new DropFromPlayerInventoryTransaction(player, dropAll);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logOpenInventory(class_1657 player) {
        OpenMenuTransaction transaction = new OpenMenuTransaction(player);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logCloseInventory(PhaseContext<@NonNull ?> current, class_1657 player) {
        CloseMenuTransaction transaction = new CloseMenuTransaction(player, current.isClientSide());
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logPlaceRecipe(boolean shift, class_8786<?> recipe, class_3222 player, CraftingInventory craftInv) {
        PlaceRecipeTransaction transaction = new PlaceRecipeTransaction(player, shift, recipe, craftInv);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public void logSelectTrade(class_3222 player, int item) {
        SelectTradeTransaction transaction = new SelectTradeTransaction(player, item);
        this.logTransaction(transaction);
    }

    default public void logShiftCraftingResult(class_1735 slot, class_1799 result) {
        ShiftCraftingResultTransaction transaction = new ShiftCraftingResultTransaction(slot, result);
        this.logTransaction(transaction);
    }

    default public void logContainerSet(class_1657 player) {
        SetPlayerContainerTransaction transaction = new SetPlayerContainerTransaction(player);
        this.logTransaction(transaction);
    }

    default public void logCraftingPreview(class_3222 player, CraftingInventory craftingInventory, class_8566 craftSlots) {
        CraftingPreviewTransaction transaction = new CraftingPreviewTransaction(player, craftingInventory, craftSlots);
        this.logTransaction(transaction);
    }

    default public void logCrafting(class_1657 player, @Nullable class_1799 craftedStack, CraftingInventory craftInv, @Nullable class_8786<class_3955> lastRecipe) {
        CraftingTransaction transaction = new CraftingTransaction(player, craftedStack, craftInv, lastRecipe);
        this.logTransaction(transaction);
    }

    default public EffectTransactor logIgnoredInventory(class_1703 containerMenu) {
        ExplicitInventoryOmittedTransaction transaction = new ExplicitInventoryOmittedTransaction(containerMenu);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logInventoryTransaction(class_1703 containerMenu) {
        InventoryTransaction transaction = new InventoryTransaction((Inventory)containerMenu);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }
}

