/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.block;

import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import net.minecraft.class_1919;
import net.minecraft.class_2680;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.common.accessor.server.level.ServerLevelAccessor;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.BlockEventBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;

public class AddBlockEventTransaction
extends BlockEventBasedTransaction {
    private final class_1919 blockEvent;
    private final SpongeBlockSnapshot original;

    public AddBlockEventTransaction(SpongeBlockSnapshot original, TrackableBlockEventDataBridge blockEvent) {
        super(original.getBlockPos(), (class_2680)original.state(), original.world());
        this.blockEvent = (class_1919)blockEvent;
        this.original = original;
    }

    @Override
    protected boolean actualBlockTransaction() {
        return false;
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.original;
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, // Could not load outer class - annotation placement on inner may be incorrect
    CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("AddBlockEvent").add(" %s : %s", "Original Block", this.original).add(" %s : %s", "Original State", this.originalState).add(" %s : %s", "EventData", this.blockEvent);
    }

    @Override
    public void restore(PhaseContext<?> context, ChangeBlockEvent.All event) {
        this.original.getServerWorld().ifPresent(world -> ((ServerLevelAccessor)world).accessor$blockEvents().remove((Object)this.blockEvent));
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", AddBlockEventTransaction.class.getSimpleName() + "[", "]").add("blockEvent=" + String.valueOf(this.blockEvent)).add("original=" + String.valueOf(this.original)).add("affectedPosition=" + String.valueOf(this.affectedPosition)).add("originalState=" + String.valueOf(this.originalState)).add("worldKey=" + String.valueOf(this.worldKey)).add("cancelled=" + this.cancelled).toString();
    }
}

