/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.block;

import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.level.block.entity.BlockEntityBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.block.BlockEventBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.BlockChange;

public final class AddTileEntity
extends BlockEventBasedTransaction {
    final class_2586 added;
    private @MonotonicNonNull SpongeBlockSnapshot oldSnapshot;
    private @MonotonicNonNull SpongeBlockSnapshot addedSnapshot;
    private final Supplier<class_3218> worldSupplier;
    private final Supplier<class_2818> chunkSupplier;

    public AddTileEntity(class_2586 blockEntity, Supplier<class_3218> worldSupplier, Supplier<class_2818> chunkSupplier) {
        super(blockEntity.method_11016().method_10062(), chunkSupplier.get().method_8320(blockEntity.method_11016()), ((ServerWorld)worldSupplier.get()).key());
        this.added = blockEntity;
        this.worldSupplier = worldSupplier;
        this.chunkSupplier = chunkSupplier;
    }

    @Override
    protected void captureState() {
        super.captureState();
        @Nullable class_2586 existingTile = this.chunkSupplier.get().method_12201(this.affectedPosition, class_2818.class_2819.field_12859);
        SpongeBlockSnapshot added = TrackingUtil.createPooledSnapshot(this.originalState, this.affectedPosition, BlockChangeFlags.NONE, 512, this.added, this.worldSupplier, Optional::empty, Optional::empty);
        SpongeBlockSnapshot existing = TrackingUtil.createPooledSnapshot(this.originalState, this.affectedPosition, BlockChangeFlags.NONE, 512, existingTile, this.worldSupplier, Optional::empty, Optional::empty);
        existing.blockChange = BlockChange.MODIFY;
        this.oldSnapshot = existing;
        this.addedSnapshot = added;
    }

    @Override
    public Optional<TransactionFlow.AbsorbingFlowStep> parentAbsorber() {
        return Optional.of((ctx, tx) -> tx.acceptTileAddition(this.added));
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, // Could not load outer class - annotation placement on inner may be incorrect
    CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("AddTileEntity").addWrapped(120, " %s : %s", this.affectedPosition, ((BlockEntityBridge)this.added).bridge$getPrettyPrinterString());
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, ChangeBlockEvent.All event) {
        this.oldSnapshot.restore(true, BlockChangeFlags.NONE);
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        return this.addedSnapshot;
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.oldSnapshot;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", AddTileEntity.class.getSimpleName() + "[", "]").add("added=" + String.valueOf(this.added)).add("affectedPosition=" + String.valueOf(this.affectedPosition)).add("originalState=" + String.valueOf(this.originalState)).add("worldKey=" + String.valueOf(this.worldKey)).add("cancelled=" + this.cancelled).toString();
    }
}

