/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.block;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.transaction.BlockTransaction;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.context.transaction.world.WorldBasedTransaction;

abstract class BlockEventBasedTransaction
extends WorldBasedTransaction<ChangeBlockEvent.All> {
    final class_2338 affectedPosition;
    final class_2680 originalState;
    private @MonotonicNonNull BlockTransaction eventTransaction;

    BlockEventBasedTransaction(class_2338 affectedPosition, class_2680 originalState, ResourceKey worldKey) {
        super((TransactionType)TransactionTypes.BLOCK.get(), worldKey);
        this.affectedPosition = affectedPosition.method_10062();
        this.originalState = originalState;
    }

    @Override
    public final Optional<ChangeBlockEvent.All> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<ChangeBlockEvent.All>> transactions, Cause currentCause) {
        Optional<ServerWorld> o = ((SpongeServer)SpongeCommon.server()).worldManager().world(this.worldKey);
        if (!o.isPresent()) {
            return Optional.empty();
        }
        HashMap<class_2338, BlockTransaction> eventTransactions = new HashMap<class_2338, BlockTransaction>();
        for (GameTransaction transaction : transactions) {
            BlockEventBasedTransaction blockTransaction = (BlockEventBasedTransaction)transaction;
            if (!blockTransaction.actualBlockTransaction()) continue;
            SpongeBlockSnapshot original = blockTransaction.getOriginalSnapshot();
            SpongeBlockSnapshot result = blockTransaction.getResultingSnapshot();
            Operation operation = context.getBlockOperation(original, result);
            BlockTransaction eventTransaction = new BlockTransaction((BlockSnapshot)original, (BlockSnapshot)result, operation);
            blockTransaction.eventTransaction = eventTransactions.merge(blockTransaction.affectedPosition, eventTransaction, (oldValue, newValue) -> {
                ImmutableList.Builder intermediary = ImmutableList.builderWithExpectedSize((int)(oldValue.intermediary().size() + 1));
                intermediary.addAll((Iterable)oldValue.intermediary());
                intermediary.add((Object)((BlockSnapshot)oldValue.finalReplacement()));
                Operation mergedOperation = context.getBlockOperation((SpongeBlockSnapshot)oldValue.original(), (SpongeBlockSnapshot)newValue.finalReplacement());
                return new BlockTransaction((BlockSnapshot)oldValue.original(), (BlockSnapshot)newValue.finalReplacement(), (List)intermediary.build(), mergedOperation);
            });
        }
        if (eventTransactions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SpongeEventFactory.createChangeBlockEventAll((Cause)currentCause, (List)ImmutableList.copyOf(eventTransactions.values()), (ServerWorld)o.get()));
    }

    protected boolean actualBlockTransaction() {
        return true;
    }

    protected abstract SpongeBlockSnapshot getResultingSnapshot();

    protected abstract SpongeBlockSnapshot getOriginalSnapshot();

    @Override
    public final boolean markCancelledTransactions(ChangeBlockEvent.All event, ImmutableList<? extends GameTransaction<ChangeBlockEvent.All>> blockTransactions) {
        boolean cancelledAny = false;
        if (event.isCancelled()) {
            event.transactions().forEach(Transaction::invalidate);
        }
        for (GameTransaction gameTransaction : blockTransactions) {
            BlockEventBasedTransaction blockTransaction = (BlockEventBasedTransaction)gameTransaction;
            if (blockTransaction.eventTransaction == null || blockTransaction.eventTransaction.isValid()) continue;
            cancelledAny = true;
            gameTransaction.markCancelled();
        }
        return cancelledAny;
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, ChangeBlockEvent.All event) {
        for (BlockTransaction transaction : event.transactions()) {
            if (!transaction.isValid()) continue;
            transaction.custom().ifPresent(b -> ((BlockSnapshot)transaction.original()).location().ifPresent(l -> ((BlockSnapshot)b.withLocation(l)).restore(true, transaction.customFlag())));
        }
    }

    @Override
    public void markEventAsCancelledIfNecessary(ChangeBlockEvent.All event) {
        super.markEventAsCancelledIfNecessary(event);
        event.transactions().forEach(Transaction::invalidate);
    }
}

