/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.block;

import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.BlockEventBasedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.PrepareBlockDropsTransaction;
import org.spongepowered.common.event.tracking.context.transaction.effect.BlockAddedEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.CheckBlockPostPlacementIsSameEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.ChunkChangeCompleteEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.OldBlockOnReplaceEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.SetBlockToChunkSectionEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateChunkLightManagerEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateHeightMapEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateLightSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateOrCreateNewTileEntityPostPlacementEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class ChangeBlock
extends BlockEventBasedTransaction {
    public final SpongeBlockSnapshot original;
    final int originalOpacity;
    final class_2680 newState;
    final SpongeBlockChangeFlag blockChangeFlag;
    public @Nullable class_2586 queuedRemoval;
    public @Nullable class_2586 queuedAdd;

    public ChangeBlock(SpongeBlockSnapshot attachedSnapshot, class_2680 newState, SpongeBlockChangeFlag blockChange) {
        super(attachedSnapshot.getBlockPos(), (class_2680)attachedSnapshot.state(), attachedSnapshot.world());
        this.original = attachedSnapshot;
        this.newState = newState;
        this.blockChangeFlag = blockChange;
        this.originalOpacity = this.originalState.method_26193();
    }

    public class_2680 getNewState() {
        return this.newState;
    }

    public SpongeBlockChangeFlag getBlockChangeFlag() {
        return this.blockChangeFlag;
    }

    public void populateChunkEffects(ChunkPipeline.Builder builder) {
        builder.addEffect(SetBlockToChunkSectionEffect.getInstance());
        builder.addEffect(UpdateHeightMapEffect.getInstance());
        builder.addEffect(UpdateChunkLightManagerEffect.getInstance());
        builder.addEffect(UpdateLightSideEffect.getInstance());
        builder.addEffect(OldBlockOnReplaceEffect.getInstance());
        builder.addEffect(CheckBlockPostPlacementIsSameEffect.getInstance());
        builder.addEffect(BlockAddedEffect.getInstance());
        builder.addEffect(UpdateOrCreateNewTileEntityPostPlacementEffect.getInstance());
        builder.addEffect(ChunkChangeCompleteEffect.getInstance());
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", ChangeBlock.class.getSimpleName() + "[", "]").add("affectedPosition=" + String.valueOf(this.affectedPosition)).add("originalState=" + String.valueOf(this.originalState)).add("originalOpacity=" + this.originalOpacity).add("newState=" + String.valueOf(this.newState)).add("blockChangeFlag=" + String.valueOf(this.blockChangeFlag)).add("queuedRemoval=" + String.valueOf(this.queuedRemoval)).add("queuedAdd=" + String.valueOf(this.queuedAdd)).add("worldKey=" + String.valueOf(this.worldKey)).add("cancelled=" + this.cancelled).toString();
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, // Could not load outer class - annotation placement on inner may be incorrect
    CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of(PhaseContext::addCreatorAndNotifierToCauseStack);
    }

    @Override
    public boolean acceptTileAddition(class_2586 tileEntity) {
        if (this.queuedAdd == tileEntity) {
            return true;
        }
        if (this.queuedAdd != null) {
            return false;
        }
        if (!this.affectedPosition.equals((Object)tileEntity.method_11016())) {
            return false;
        }
        this.queuedAdd = tileEntity;
        return true;
    }

    @Override
    public boolean acceptTileRemoval(@Nullable class_2586 tileentity) {
        if (this.queuedRemoval == tileentity) {
            return true;
        }
        if (this.queuedRemoval != null) {
            return false;
        }
        if (!this.affectedPosition.equals((Object)tileentity.method_11016())) {
            return false;
        }
        this.queuedRemoval = tileentity;
        return true;
    }

    @Override
    public boolean acceptTileReplacement(@Nullable class_2586 existing, class_2586 proposed) {
        return this.acceptTileRemoval(existing) && this.acceptTileAddition(proposed);
    }

    @Override
    public void restore(PhaseContext<?> context, ChangeBlockEvent.All event) {
        this.original.restore(true, BlockChangeFlagManager.fromNativeInt(-1610612678));
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("ChangeBlock").add(" %s : %s", "Original Block", this.original).add(" %s : %s", "New State", this.newState).add(" %s : %s", "RemovedTile", this.queuedRemoval).add(" %s : %s", "AddedTile", this.queuedAdd).add(" %s : %s", "ChangeFlag", this.blockChangeFlag);
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled().position(this.original.position()).blockState((BlockState)this.newState);
        if (this.original.getServerWorld().isPresent()) {
            builder.world(this.original.getServerWorld().get());
        } else {
            builder.world(this.original.world());
        }
        return builder.build();
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.original;
    }

    @Override
    public boolean absorbBlockDropsPreparation(PhaseContext<@NonNull ?> context, PrepareBlockDropsTransaction transaction) {
        return this.original.blockChange == BlockChange.BREAK && this.affectedPosition.equals((Object)transaction.affectedPosition) && this.original.state() == transaction.getOriginalSnapshot().state();
    }
}

