/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.transaction.NotificationTicket;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.NotifyNeighborBlockEvent;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeNotificationTicket;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.context.transaction.world.WorldBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3i;

public final class NeighborNotification
extends WorldBasedTransaction<NotifyNeighborBlockEvent> {
    final class_2680 original;
    final class_2338 notifyPos;
    final class_2248 sourceBlock;
    final class_2338 sourcePos;
    final class_2338 affectedPosition;
    final class_2680 originalState;
    private final Supplier<class_3218> serverWorld;
    private Supplier<LocatableBlock> locatableBlock;
    private Supplier<SpongeBlockSnapshot> targetSnapshot;
    private Supplier<NotificationTicket> ticketSupplier;

    public NeighborNotification(Supplier<class_3218> serverWorldSupplier, class_2680 notifyState, class_2338 notifyPos, class_2248 sourceBlock, class_2338 sourcePos, @Nullable class_2586 existingTile) {
        super((TransactionType)TransactionTypes.NEIGHBOR_NOTIFICATION.get(), ((ServerWorld)serverWorldSupplier.get()).key());
        this.affectedPosition = sourcePos;
        this.originalState = notifyState;
        this.serverWorld = serverWorldSupplier;
        this.notifyPos = notifyPos;
        this.sourceBlock = sourceBlock;
        this.sourcePos = sourcePos;
        this.original = serverWorldSupplier.get().method_8320(sourcePos);
        this.locatableBlock = () -> {
            LocatableBlock locatableBlock = new SpongeLocatableBlockBuilder().world(this.serverWorld).position(this.sourcePos.method_10263(), this.sourcePos.method_10264(), this.sourcePos.method_10260()).state((BlockState)this.original).build();
            this.locatableBlock = () -> locatableBlock;
            return locatableBlock;
        };
        this.targetSnapshot = () -> {
            SpongeBlockSnapshot.BuilderImpl pooled = SpongeBlockSnapshot.BuilderImpl.pooled();
            pooled.world(this.serverWorld.get()).position(new Vector3i(notifyPos.method_10263(), notifyPos.method_10264(), notifyPos.method_10260())).blockState(notifyState);
            if (existingTile != null) {
                pooled.tileEntity(existingTile);
            }
            SpongeBlockSnapshot snapshot = pooled.build();
            this.targetSnapshot = () -> snapshot;
            return snapshot;
        };
        this.ticketSupplier = () -> {
            LocatableBlock notifier = this.locatableBlock.get();
            SpongeBlockSnapshot target = this.targetSnapshot.get();
            SpongeNotificationTicket ticket = new SpongeNotificationTicket(notifier, target);
            this.ticketSupplier = () -> ticket;
            return ticket;
        };
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", NeighborNotification.class.getSimpleName() + "[", "]").add("notifyState=" + String.valueOf(this.originalState)).add("notifyPos=" + String.valueOf(this.notifyPos)).add("sourceBlock=" + String.valueOf(this.sourceBlock)).add("sourcePos=" + String.valueOf(this.sourcePos)).add("actualSourceState=" + String.valueOf(this.originalState)).toString();
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, // Could not load outer class - annotation placement on inner may be incorrect
    CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, frame) -> {
            if (parent instanceof ChangeBlock) {
                frame.pushCause((Object)((ChangeBlock)parent).original);
            }
            frame.pushCause((Object)this.ticketSupplier.get());
        });
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("NeighborNotification").add(" %s : %s, %s", "Source Pos", this.sourceBlock, this.sourcePos).add(" %s : %s, %s", "Notification", this.originalState, this.notifyPos);
    }

    @Override
    public Optional<NotifyNeighborBlockEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<NotifyNeighborBlockEvent>> transactions, Cause currentCause) {
        ImmutableList tickets = (ImmutableList)transactions.stream().map(transaction -> ((NeighborNotification)transaction).ticketSupplier.get()).collect(ImmutableList.toImmutableList());
        return Optional.of(SpongeEventFactory.createNotifyNeighborBlockEvent((Cause)currentCause, (List)tickets));
    }

    @Override
    public void restore(PhaseContext<?> context, NotifyNeighborBlockEvent event) {
    }

    @Override
    public boolean markCancelledTransactions(NotifyNeighborBlockEvent event, ImmutableList<? extends GameTransaction<NotifyNeighborBlockEvent>> blockTransactions) {
        boolean cancelledAny = false;
        for (NotificationTicket transaction : event.tickets()) {
            if (transaction.valid()) continue;
            cancelledAny = true;
            for (GameTransaction gameTransaction : blockTransactions) {
                NeighborNotification blockTransaction = (NeighborNotification)gameTransaction;
                Vector3i position = transaction.targetPosition();
                class_2338 affectedPosition = blockTransaction.affectedPosition;
                if (position.x() != affectedPosition.method_10263() || position.y() != affectedPosition.method_10264() || position.z() != affectedPosition.method_10260()) continue;
                gameTransaction.markCancelled();
            }
        }
        return cancelledAny;
    }

    @Override
    public void markEventAsCancelledIfNecessary(NotifyNeighborBlockEvent event) {
        super.markEventAsCancelledIfNecessary(event);
        event.tickets().forEach(NotificationTicket::invalidate);
    }
}

