/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.block;

import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.level.block.entity.BlockEntityBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.block.BlockEventBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.math.vector.Vector3i;

public final class RemoveBlockEntity
extends BlockEventBasedTransaction {
    private final class_2586 removed;
    private final Supplier<class_3218> levelSupplier;
    private @MonotonicNonNull SpongeBlockSnapshot tileSnapshot;

    public RemoveBlockEntity(class_2586 removed, Supplier<class_3218> levelSupplier) {
        super(removed.method_11016().method_10062(), removed.method_11010(), ((ServerWorld)levelSupplier.get()).key());
        this.removed = removed;
        this.levelSupplier = levelSupplier;
    }

    @Override
    protected void captureState() {
        super.captureState();
        SpongeBlockSnapshot snapshot = TrackingUtil.createPooledSnapshot(this.originalState, this.affectedPosition, BlockChangeFlags.NONE, 512, this.removed, this.levelSupplier, Optional::empty, Optional::empty);
        snapshot.blockChange = BlockChange.MODIFY;
        this.tileSnapshot = snapshot;
    }

    @Override
    public Optional<TransactionFlow.AbsorbingFlowStep> parentAbsorber() {
        return Optional.of((ctx, tx) -> tx.acceptTileRemoval(this.removed));
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, // Could not load outer class - annotation placement on inner may be incorrect
    CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("RemoveTileEntity").add(" %s : %s", this.affectedPosition, ((BlockEntityBridge)this.removed).bridge$getPrettyPrinterString()).add(" %s : %s", this.affectedPosition, this.originalState);
    }

    @Override
    public void restore(PhaseContext<?> context, ChangeBlockEvent.All event) {
        this.tileSnapshot.restore(true, BlockChangeFlags.NONE);
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        return SpongeBlockSnapshot.BuilderImpl.pooled().world((class_3218)this.removed.method_10997()).position(new Vector3i(this.affectedPosition.method_10263(), this.affectedPosition.method_10264(), this.affectedPosition.method_10260())).blockState(this.originalState).build();
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.tileSnapshot;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", RemoveBlockEntity.class.getSimpleName() + "[", "]").add("affectedPosition=" + String.valueOf(this.affectedPosition)).add("originalState=" + String.valueOf(this.originalState)).add("worldKey=" + String.valueOf(this.worldKey)).add("cancelled=" + this.cancelled).add("removed=" + String.valueOf(this.removed)).toString();
    }
}

