/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.block;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import io.leangen.geantyref.TypeToken;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_6760;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.transaction.ScheduleUpdateTicket;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ScheduleBlockUpdateEvent;
import org.spongepowered.api.scheduler.TaskPriority;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.block.SpongeScheduleUpdateTicket;
import org.spongepowered.common.bridge.world.ticks.TickNextTickDataBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.context.transaction.world.WorldBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3i;

public class ScheduleUpdateTransaction<T>
extends WorldBasedTransaction<ScheduleBlockUpdateEvent<T>> {
    private final class_2338 affectedPosition;
    private final class_2680 originalState;
    private final TypeToken<T> typeToken;
    private Supplier<class_6760<T>> dataSupplier;
    private Supplier<ScheduleUpdateTicket<T>> ticketSupplier;

    public ScheduleUpdateTransaction(Supplier<class_3218> serverWorldSupplier, Supplier<class_6760<T>> dataSupplier, class_2338 affectedPosition, T target, Duration delay, TaskPriority priority) {
        super((TransactionType)TransactionTypes.SCHEDULE_BLOCK_UPDATE.get(), ((ServerWorld)serverWorldSupplier.get()).key());
        this.affectedPosition = affectedPosition;
        this.originalState = serverWorldSupplier.get().method_8320(affectedPosition);
        this.typeToken = TypeToken.get(target.getClass());
        this.dataSupplier = dataSupplier;
        this.ticketSupplier = Suppliers.memoize(() -> {
            LocatableBlock locatableBlock = new SpongeLocatableBlockBuilder().world(serverWorldSupplier).position(this.affectedPosition.method_10263(), this.affectedPosition.method_10264(), this.affectedPosition.method_10260()).state((BlockState)this.originalState).build();
            return new SpongeScheduleUpdateTicket<Object>(locatableBlock, target, delay, priority);
        });
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, // Could not load outer class - annotation placement on inner may be incorrect
    CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public Optional<ScheduleBlockUpdateEvent<T>> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<ScheduleBlockUpdateEvent<T>>> gameTransactions, Cause currentCause) {
        ImmutableList tickets = (ImmutableList)gameTransactions.stream().map(transaction -> ((ScheduleUpdateTransaction)transaction).ticketSupplier.get()).collect(ImmutableList.toImmutableList());
        return Optional.of(SpongeEventFactory.createScheduleBlockUpdateEvent((Cause)currentCause, this.typeToken, (List)tickets));
    }

    @Override
    public void restore(PhaseContext<?> context, ScheduleBlockUpdateEvent<T> event) {
        ((TickNextTickDataBridge)this.dataSupplier.get()).bridge$cancelForcibly();
    }

    @Override
    public boolean markCancelledTransactions(ScheduleBlockUpdateEvent<T> event, ImmutableList<? extends GameTransaction<ScheduleBlockUpdateEvent<T>>> gameTransactions) {
        boolean cancelledAny = false;
        for (ScheduleUpdateTicket transaction : event.tickets()) {
            if (transaction.valid()) continue;
            cancelledAny = true;
            for (GameTransaction gameTransaction : gameTransactions) {
                ScheduleUpdateTransaction scheduleUpdateTransaction = (ScheduleUpdateTransaction)gameTransaction;
                Vector3i position = transaction.block().blockPosition();
                class_2338 affectedPosition = scheduleUpdateTransaction.affectedPosition;
                if (position.x() != affectedPosition.method_10263() || position.y() != affectedPosition.method_10264() || position.z() != affectedPosition.method_10260()) continue;
                gameTransaction.markCancelled();
            }
        }
        return cancelledAny;
    }

    @Override
    public void markEventAsCancelledIfNecessary(ScheduleBlockUpdateEvent<T> event) {
        super.markEventAsCancelledIfNecessary(event);
        event.tickets().forEach(ScheduleUpdateTicket::invalidate);
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("ScheduleUpdate").add(" %s : %s", "Affected Position", this.affectedPosition).add(" %s : %s", "Original State", this.originalState);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", ScheduleUpdateTransaction.class.getSimpleName() + "[", "]").add("affectedPosition=" + String.valueOf(this.affectedPosition)).add("worldKey=" + String.valueOf(this.worldKey)).add("originalState=" + String.valueOf(this.originalState)).add("cancelled=" + this.cancelled).toString();
    }

    @Override
    protected boolean shouldBuildEventAndRestartBatch(GameTransaction<@NonNull ?> pointer, PhaseContext<@NonNull ?> context) {
        return super.shouldBuildEventAndRestartBatch(pointer, context) || !this.typeToken.equals(((ScheduleUpdateTransaction)pointer).typeToken);
    }
}

