/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2813;
import net.minecraft.class_3222;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerBasedTransaction;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.util.ItemStackUtil;

public class ClickCreativeMenuTransaction
extends ContainerBasedTransaction {
    private final class_3222 player;
    private final int slotNum;
    private final @Nullable Slot slot;
    private final ItemStackSnapshot creativeStack;
    private final ItemStackSnapshot originalCursor;

    public ClickCreativeMenuTransaction(class_1657 player, int slotNum, ItemStackSnapshot creativeStack) {
        super(player.field_7512);
        this.player = (class_3222)player;
        this.slotNum = slotNum;
        this.creativeStack = creativeStack;
        this.originalCursor = ItemStackUtil.snapshotOf(player.field_7512.method_34255());
        this.slot = slotNum >= 0 ? (Slot)((InventoryAdapter)this.menu).inventoryAdapter$getSlot(slotNum).orElse(null) : null;
    }

    @Override
    Optional<ClickContainerEvent> createInventoryEvent(List<SlotTransaction> slotTransactions, List<Entity> entities, PhaseContext<@NonNull ?> context, Cause cause) {
        if (slotTransactions.isEmpty() && this.slotNum >= 0 && this.slot != null) {
            ItemStackSnapshot item = this.slot.peek().asImmutable();
            slotTransactions.add(new SlotTransaction(this.slot, item, this.creativeStack));
        }
        Transaction cursorTransaction = new Transaction((DataSerializable)this.originalCursor, (DataSerializable)ItemStackSnapshot.empty());
        if (entities.isEmpty()) {
            return Optional.of(SpongeEventFactory.createClickContainerEventCreativeSet((Cause)cause, (Container)((Container)this.menu), (Transaction)cursorTransaction, Optional.ofNullable(this.slot), slotTransactions));
        }
        Cause causeWithSpawnType = Cause.builder().from(cause).build(EventContext.builder().from(cause.context()).add(EventContextKeys.SPAWN_TYPE, (Object)((SpawnType)SpawnTypes.DROPPED_ITEM.get())).build());
        return Optional.of(SpongeEventFactory.createClickContainerEventCreativeDrop((Cause)causeWithSpawnType, (Container)((Container)this.menu), (Transaction)cursorTransaction, (ItemStackSnapshot)this.creativeStack, entities, Optional.ofNullable(this.slot), slotTransactions));
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, ClickContainerEvent event) {
        this.handleEventResults((class_1657)this.player, event);
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, ClickContainerEvent event) {
        this.handleEventResults((class_1657)this.player, event);
    }

    @Override
    boolean isContainerEventAllowed(PhaseContext<@Nullable ?> context) {
        if (!(context instanceof InventoryPacketContext)) {
            return false;
        }
        int containerId = ((class_2813)((InventoryPacketContext)context).getPacket()).method_12194();
        return containerId != this.player.field_7512.field_7763;
    }
}

