/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_2813;
import net.minecraft.class_3222;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerBasedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ShiftCraftingResultTransaction;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.item.util.ItemStackUtil;

public class ClickMenuTransaction
extends ContainerBasedTransaction {
    private final class_3222 player;
    private final int slotNum;
    private final int buttonNum;
    private final class_1713 clickType;
    private final @Nullable Slot slot;
    private final ItemStackSnapshot cursor;

    public ClickMenuTransaction(class_1657 player, class_1703 menu, int slotNum, int buttonNum, class_1713 clickType, @Nullable Slot slot, ItemStackSnapshot cursor) {
        super(menu);
        this.player = (class_3222)player;
        this.slotNum = slotNum;
        this.buttonNum = buttonNum;
        this.clickType = clickType;
        this.slot = slot;
        this.cursor = cursor;
    }

    @Override
    Optional<ClickContainerEvent> createInventoryEvent(List<SlotTransaction> slotTransactions, List<Entity> entities, PhaseContext<@NonNull ?> context, Cause cause) {
        ItemStackSnapshot resultingCursor = ItemStackUtil.snapshotOf(this.player.field_7512.method_34255());
        Transaction cursorTransaction = new Transaction((DataSerializable)this.cursor, (DataSerializable)resultingCursor);
        @Nullable ClickContainerEvent event = context.createContainerEvent(cause, this.player, (Container)this.menu, (Transaction<ItemStackSnapshot>)cursorTransaction, slotTransactions, entities, this.buttonNum, this.slot);
        return Optional.ofNullable(event);
    }

    @Override
    public boolean absorbShiftClickResult(PhaseContext<@NonNull ?> context, ShiftCraftingResultTransaction transaction) {
        this.shiftCraftingResult = transaction.itemStack;
        return true;
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, ClickContainerEvent event) {
        this.handleEventResults((class_1657)this.player, event);
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, ClickContainerEvent event) {
        this.handleEventResults((class_1657)this.player, event);
    }

    @Override
    boolean isContainerEventAllowed(PhaseContext<@NonNull ?> context) {
        if (!(context instanceof InventoryPacketContext)) {
            return false;
        }
        int containerId = ((class_2813)((InventoryPacketContext)context).getPacket()).method_12194();
        return containerId != this.player.field_7512.field_7763;
    }
}

