/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2645;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3944;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerSlotTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.MenuBasedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.PrettyPrinter;

public class CloseMenuTransaction
extends MenuBasedTransaction<InteractContainerEvent> {
    private final class_3222 player;
    private final ItemStackSnapshot cursor;
    private boolean clientSource;
    private @MonotonicNonNull List<SlotTransaction> slotTransactions;

    public CloseMenuTransaction(class_1657 player, boolean clientSource) {
        super((TransactionType)TransactionTypes.INTERACT_CONTAINER_EVENT.get(), player.field_7512);
        this.player = (class_3222)player;
        this.cursor = ItemStackUtil.snapshotOf(player.field_7512.method_34255());
        this.clientSource = clientSource;
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, // Could not load outer class - annotation placement on inner may be incorrect
    CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public Optional<InteractContainerEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<InteractContainerEvent>> gameTransactions, Cause currentCause) {
        return Optional.empty();
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, InteractContainerEvent event) {
        if (this.clientSource) {
            this.reopen(this.player, this.menu);
        }
        PacketPhaseUtil.handleCursorRestore((class_1657)this.player, (Transaction<ItemStackSnapshot>)event.cursorTransaction(), event.isCancelled());
        if (event instanceof ChangeInventoryEvent) {
            PacketPhaseUtil.handleSlotRestore((class_1657)this.player, this.menu, ((ChangeInventoryEvent)event).transactions(), event.isCancelled());
        }
        this.player.field_7498.method_7623();
    }

    @Override
    public boolean absorbSlotTransaction(ContainerSlotTransaction slotTransaction) {
        if (this.menu != slotTransaction.menu) {
            return this.player.field_7498 == slotTransaction.menu;
        }
        if (this.slotTransactions == null) {
            this.slotTransactions = new ArrayList<SlotTransaction>();
        }
        this.slotTransactions.add(slotTransaction.transaction);
        return true;
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, InteractContainerEvent event) {
        if (!this.clientSource) {
            this.player.field_13987.method_14364((class_2596)new class_2645(this.player.field_7512.field_7763));
        }
        this.player.field_7512 = this.player.field_7498;
        PacketPhaseUtil.handleCursorRestore((class_1657)this.player, (Transaction<ItemStackSnapshot>)event.cursorTransaction(), event.isCancelled());
        if (event instanceof ChangeInventoryEvent) {
            PacketPhaseUtil.handleSlotRestore((class_1657)this.player, this.menu, ((ChangeInventoryEvent)event).transactions(), event.isCancelled());
        }
        this.player.field_7498.method_7623();
    }

    @Override
    public boolean markCancelledTransactions(InteractContainerEvent event, ImmutableList<? extends GameTransaction<InteractContainerEvent>> gameTransactions) {
        if (event.isCancelled()) {
            event.cursorTransaction().invalidate();
            return true;
        }
        return !event.cursorTransaction().isValid();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    private void reopen(class_3222 player, class_1703 container) {
        if (container.method_7611(0) == null) {
            return;
        }
        if (!(container instanceof class_1723)) {
            player.field_7512 = container;
            class_1735 slot = container.method_7611(0);
            class_1263 slotInventory = slot.field_7871;
            class_2561 title = slotInventory instanceof class_3908 ? ((class_3908)slotInventory).method_5476() : null;
            slotInventory.method_5435((class_1657)player);
            player.field_13987.method_14364((class_2596)new class_3944(container.field_7763, container.method_17358(), title));
            container.method_37420();
        }
    }
}

